/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.business.schedule;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtp.business.attconfirm.AttConfirmHelper;
import kd.wtc.wtp.business.attconfirm.AttConfirmServiceFactory;
import kd.wtc.wtp.business.attconfirm.IAttConfirmOpService;
import kd.wtc.wtp.business.attconfirm.impl.AttConfirmQueryServiceImpl;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordModeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordOverHandleTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordStatusEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmRecordOpEnum;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordModel;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordOpParam;
import kd.wtc.wtp.common.model.attconfirm.AttConfirmRecordQueryParam;

public class AttConfirmStatusUpdateTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(AttConfirmStatusUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (LOG.isInfoEnabled()) {
            LOG.info("AttConfirmStatusUpdateTask.execute start");
        }
        AttConfirmRecordQueryParam attConfirmRecordQueryParam = new AttConfirmRecordQueryParam();
        HashSet<AttConRecordOverHandleTypeEnum> attConRecordOverHandleTypeEnumSet = new HashSet<AttConRecordOverHandleTypeEnum>();
        attConRecordOverHandleTypeEnumSet.add(AttConRecordOverHandleTypeEnum.AUTO_CONFIRM);
        attConRecordOverHandleTypeEnumSet.add(AttConRecordOverHandleTypeEnum.NOT_ABLE_CONFIRM);
        attConfirmRecordQueryParam.setStatus(AttConfirmRecordQueryParam.getQueryAttConRecordStatusEnum((AttConRecordStatusEnum[])new AttConRecordStatusEnum[]{AttConRecordStatusEnum.SEND, AttConRecordStatusEnum.GEN}));
        attConfirmRecordQueryParam.setHandleTypeEnumSet(attConRecordOverHandleTypeEnumSet);
        Date nowDate = new Date();
        Date zeroDate = WTCDateUtils.getZeroDate((Date)nowDate);
        QFilter qFilter = new QFilter("confirmendtime", "<", (Object)zeroDate);
        attConfirmRecordQueryParam.setCustomQFilter(qFilter);
        List attConfirmRecordModelList = AttConfirmQueryServiceImpl.getInstance().queryAttConfirmRecordModelList(attConfirmRecordQueryParam);
        if (WTCCollections.isNotEmpty((Collection)attConfirmRecordModelList)) {
            List<AttConfirmRecordModel> autoConfirmData = attConfirmRecordModelList.stream().filter(d -> AttConRecordOverHandleTypeEnum.AUTO_CONFIRM == d.getOverHandleType()).collect(Collectors.toList());
            List<AttConfirmRecordModel> notAbleConfirmData = attConfirmRecordModelList.stream().filter(d -> AttConRecordOverHandleTypeEnum.NOT_ABLE_CONFIRM == d.getOverHandleType()).collect(Collectors.toList());
            AttConfirmRecordOpParam attConfirmRecordOpParam = new AttConfirmRecordOpParam();
            IAttConfirmOpService attConfirmService = AttConfirmServiceFactory.getInstance().getAttConfirmService(AttConfirmRecordOpEnum.PROXY);
            autoConfirmData.forEach(attConfirmRecordModel -> {
                attConfirmRecordModel.setConfirmTime(nowDate);
                attConfirmRecordModel.setStatus(AttConRecordStatusEnum.CONFIRM);
                attConfirmRecordModel.setConfirmMode(AttConRecordModeEnum.SYS_CONFIRM);
                attConfirmRecordModel.setConFirmer(0L);
            });
            attConfirmRecordOpParam.setAttConfirmRecordModelList(autoConfirmData);
            attConfirmService.opAttConfirmRecord(attConfirmRecordOpParam);
            notAbleConfirmData.forEach(d -> d.setStatus(AttConRecordStatusEnum.NOT_CONFIRM));
            AttConfirmHelper.getInstance().updateAttConfirmRecordData(notAbleConfirmData);
            if (LOG.isInfoEnabled()) {
                LOG.info("AttConfirmStatusUpdateTask.execute end");
            }
        }
    }
}

