/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.business.upgarde;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.common.enums.attconfirm.AttConfirmDataStatusEnum;

public class AttConfirmDataStatusUpgrade
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(AbstractWtcTaskUpgrade.class);

    protected String getJobId() {
        return "4D7NT/JTJ62X";
    }

    protected String getScheduleId() {
        return "4D7U02WO=244";
    }

    protected boolean process() {
        HRBaseServiceHelper attConfirmRecordHelper = new HRBaseServiceHelper("wtam_attconrecord");
        DynamicObject[] dataStatusEmptyDys = attConfirmRecordHelper.query("id, attfile, perattperiod, datastatus", new QFilter[]{new QFilter("datastatus", "=", (Object)"")});
        if (dataStatusEmptyDys == null || dataStatusEmptyDys.length == 0) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("AttConfirmDataStatusUpgrade.process allRecord count : " + dataStatusEmptyDys.length);
        }
        Set attFileIds = Arrays.stream(dataStatusEmptyDys).map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfile")).collect(Collectors.toSet());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"-1"}));
        attFileQueryParam.setSetBoIds(attFileIds);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        List attFileDys = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        List discardFileIds = attFileDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            LOG.debug("AttConfirmDataStatusUpgrade.process discardFileIds count : " + dataStatusEmptyDys.length);
        }
        List perAttPeriodIds = Arrays.stream(dataStatusEmptyDys).map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"perattperiod")).distinct().collect(Collectors.toList());
        PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam(false);
        queryParam.setExtendQFilter(new QFilter("id", "in", perAttPeriodIds));
        queryParam.setBusiStatus("0");
        List perAttPeriodList = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodEntity(queryParam);
        List invalidPerAttPeriodIds = perAttPeriodList.stream().map(PerAttPeriod::getPrimaryId).collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            LOG.debug("AttConfirmDataStatusUpgrade.process invalidPerAttPeriodIds count : " + dataStatusEmptyDys.length);
        }
        for (DynamicObject statusEmptyDy : dataStatusEmptyDys) {
            if (discardFileIds.contains(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)statusEmptyDy, (String)"attfile"))) {
                statusEmptyDy.set("datastatus", (Object)AttConfirmDataStatusEnum.DISCARD.getCode());
                continue;
            }
            if (invalidPerAttPeriodIds.contains(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)statusEmptyDy, (String)"perattperiod"))) {
                statusEmptyDy.set("datastatus", (Object)AttConfirmDataStatusEnum.INVALID.getCode());
                continue;
            }
            statusEmptyDy.set("datastatus", (Object)AttConfirmDataStatusEnum.EFFECT.getCode());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("AttConfirmDataStatusUpgrade.process updateRecord count : " + dataStatusEmptyDys.length);
        }
        attConfirmRecordHelper.updateDatas(dataStatusEmptyDys);
        return true;
    }
}

