/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtam.business.upgarde;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtam.business.upgarde.UpgradeCommonService;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.common.predata.wtam.PreDataWFProcCote;

public class SupSignChangeWorkflowCategoryUpgrade
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(SupSignChangeWorkflowCategoryUpgrade.class);
    private static final String UPDATE_PROC_COTE = "update t_wf_model set fcategory = ? where fid=?;";
    private static final String dbKey = "wf";

    protected String getJobId() {
        return "44ECSXFLXJ=U";
    }

    protected String getScheduleId() {
        return "44EFZ=8IOROD";
    }

    protected boolean process() {
        LOG.info("SupSignChangeWorkflowCategoryUpgrade start process...");
        try (TXHandle txHandle = TX.required();){
            LOG.info("SupSignChangeWorkflowCategoryUpgrade start ...");
            DBRoute dbRoute = new DBRoute(dbKey);
            long wtamId = UpgradeCommonService.getInstance().cateGoryId(dbRoute);
            HRDBUtil.executeBatch((DBRoute)dbRoute, (String)UPDATE_PROC_COTE, this.getPresetProcParams(wtamId));
            LOG.info("SupSignChangeWorkflowCategoryUpgrade end ...");
        }
        return true;
    }

    private List<Object[]> getPresetProcParams(Long groupId) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        params.add(new Object[]{groupId, PreDataWFProcCote.PD_WTPM_SUPSIGNCHAGNE});
        params.add(new Object[]{groupId, PreDataWFProcCote.PD_WTPM_SUPSIGN_SELF_CHAGNE});
        params.add(new Object[]{groupId, PreDataWFProcCote.PD_WTS_SWSHIFTBILL});
        params.add(new Object[]{groupId, PreDataWFProcCote.PD_WTS_SWSHIFTSELFBILL});
        return params;
    }
}

