/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.validator.datetype;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbd.business.datetype.DateTypeService;
import kd.wtc.wtbd.common.constants.workschedule.WorkSchKDString;

public class DateTypeSaveValidator
extends HRDataBaseValidator {
    private static final Log LOG = LogFactory.getLog(DateTypeSaveValidator.class);

    public void validate() {
        Object[] ids = Arrays.stream(this.getDataEntities()).filter(dt -> dt.getDataEntity().getDataEntityState().getFromDatabase()).map(ExtendedDataEntity::getBillPkId).toArray();
        LOG.info("DateTypeSaveOp.saveValidate:{}", ids);
        if (ids.length > 0) {
            this.validateRefUnMod(ids);
        }
        this.validateMaxTypeNum();
    }

    private void validateRefUnMod(Object[] ids) {
        Map refMap = DateTypeService.existReferences((String)"wtbd_datetype", (Object[])ids);
        if (!refMap.isEmpty()) {
            for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                BaseDataCheckRefrenceResult refResult = (BaseDataCheckRefrenceResult)refMap.get(dataEntity.getBillPkId());
                if (refResult == null || !refResult.isRefence()) continue;
                this.addErrorMessage(dataEntity, WorkSchKDString.getRefedModErrTip());
            }
        }
    }

    private void validateMaxTypeNum() {
        List propList = Arrays.stream(this.getDataEntities()).map(dt -> dt.getDataEntity().getString("dateproperty.number")).collect(Collectors.toList());
        Map datePropCountMap = DateTypeService.getInstance().getCountByDateProp(propList);
        for (ExtendedDataEntity ext : this.getDataEntities()) {
            DynamicObject dataEntity = ext.getDataEntity();
            String dateProp = dataEntity.getString("dateproperty.number");
            Set datePropSet = (Set)datePropCountMap.get(dateProp);
            if (datePropSet.size() < 10 || datePropSet.contains(dataEntity.getPkValue())) continue;
            this.addFatalErrorMessage(ext, MessageFormat.format(WorkSchKDString.getMaxTypeNumberErrTip(), dataEntity.getString("dateproperty.name")));
        }
    }
}

