/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.validator.duringcycle;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.common.constants.WtbdMustInputKDString;
import kd.wtc.wtbd.opplugin.validator.common.WtbdMustInputValidator;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class CySetSaveValidator
extends WtbdMustInputValidator {
    private static final Log LOG = LogFactory.getLog(CySetSaveValidator.class);

    @Override
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            this.validateCycProperties(dataEntity);
        }
    }

    private void validateCycProperties(ExtendedDataEntity dataEntity) {
        Object selfDate;
        Object cycRefDate;
        String proStartDate;
        DynamicObject dy = dataEntity.getDataEntity();
        StringBuilder buf = new StringBuilder();
        boolean isCheckCyCass = dy.getBoolean("ischeckcycass");
        String attachType = dy.getString("attachtype");
        String attachUnit = dy.getString("attachunit");
        if (isCheckCyCass) {
            if (HRStringUtils.isEmpty((String)attachType)) {
                buf.append(WtbdMustInputKDString.attachTypeTips());
            }
            if (HRStringUtils.isEmpty((String)attachUnit)) {
                buf.append(WtbdMustInputKDString.attachUnitTips());
            }
        }
        if ("A".equals(proStartDate = dy.getString("prostartdate")) && HRObjectUtils.isEmpty((Object)(cycRefDate = dy.get("cycrefdate")))) {
            buf.append(WtbdMustInputKDString.cycRefDateTips());
        }
        if ("B".equals(proStartDate) && HRObjectUtils.isEmpty((Object)(selfDate = dy.get("selfdate")))) {
            buf.append(WtbdMustInputKDString.cycSelfDateTips());
        }
        this.validateCycType(dy, buf);
        if (StringUtils.isNotBlank((CharSequence)buf)) {
            buf.deleteCharAt(buf.length() - 1);
            this.addErrorMessage(dataEntity, WtbdMustInputKDString.baseMsg((String)buf.toString()));
        }
    }

    private void validateCycType(DynamicObject dy, StringBuilder buf) {
        boolean isCycToData;
        String cycType = dy.getString("cyctype");
        if ("B".equals(cycType) || "D".equals(cycType)) {
            Object unit;
            Object gapInt = dy.get("gapint");
            if (HRObjectUtils.isEmpty((Object)gapInt)) {
                buf.append(WtbdMustInputKDString.gapIntTips());
            }
            if (HRObjectUtils.isEmpty((Object)(unit = dy.get("unit"))) && "D".equals(cycType)) {
                buf.append(WtbdMustInputKDString.gapUnitTips());
            }
        }
        if (isCycToData = dy.getBoolean("iscyctodata")) {
            Object cycDate;
            String cycUnit = dy.getString("cycunit");
            if ("C".equals(cycUnit) || "B".equals(cycUnit)) {
                Object cycSelect = dy.get("cycselec");
                if (HRObjectUtils.isEmpty((Object)cycSelect)) {
                    buf.append(WtbdMustInputKDString.cycSelectTips());
                }
            } else if ("D".equals(cycUnit) && HRObjectUtils.isEmpty((Object)(cycDate = dy.get("cycdate")))) {
                buf.append(WtbdMustInputKDString.cycDateTips());
            }
        }
    }
}

