/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.validator.takecard;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.common.constants.WtbdMustInputKDString;
import kd.wtc.wtbd.opplugin.validator.common.WtbdMustInputValidator;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtbd.common.enums.TakeCardRuleRefDayEnum;

public class TakeCardRuleValidator
extends WtbdMustInputValidator {
    private static final Log LOG = LogFactory.getLog(TakeCardRuleValidator.class);

    @Override
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject dy = dataEntity.getDataEntity();
            boolean isOff = dy.getBoolean("isoff");
            if (isOff) {
                this.validateOff(dataEntity);
                continue;
            }
            this.validateNotOff(dataEntity);
        }
    }

    private void validateOff(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        StringBuilder bufBase = new StringBuilder();
        int takeCardStartTime = dy.getInt("takecardstarttime");
        int takeCardEndTime = dy.getInt("takecardendtime");
        String refDayStart = dy.getString("offrefdaystart");
        String refDayEnd = dy.getString("offrefdayend");
        if (TakeCardRuleRefDayEnum.CURRENT_DAY.refDay.equals(refDayStart) && TakeCardRuleRefDayEnum.CURRENT_DAY.refDay.equals(refDayEnd) && takeCardStartTime == 0 && takeCardEndTime == 0) {
            bufBase.append(WtbdMustInputKDString.takeCardStartTips()).append(WtbdMustInputKDString.takeCardEndTips());
            bufBase.deleteCharAt(bufBase.length() - 1);
            this.addErrorMessage(dataEntity, WtbdMustInputKDString.baseMsg((String)bufBase.toString()));
        }
    }

    private void validateNotOff(ExtendedDataEntity dataEntity) {
        String cardShape;
        String getNum;
        String timeNum;
        DynamicObject dy = dataEntity.getDataEntity();
        StringBuilder buf = new StringBuilder();
        DynamicObject takeConfigDy = dy.getDynamicObject("takecardconfig");
        if (HRObjectUtils.isEmpty((Object)takeConfigDy)) {
            buf.append(WtbdMustInputKDString.takeCardConfigTips());
        }
        if (HRStringUtils.isEmpty((String)(timeNum = dy.getString("classtimenum")))) {
            buf.append(WtbdMustInputKDString.timeNumTips());
        }
        if (HRStringUtils.isEmpty((String)(getNum = dy.getString("classgetnum")))) {
            buf.append(WtbdMustInputKDString.getNumTips());
        }
        if (HRStringUtils.isEmpty((String)(cardShape = dy.getString("takecardshape")))) {
            buf.append(WtbdMustInputKDString.cardShapeTips());
        }
        if (StringUtils.isNotBlank((CharSequence)buf)) {
            buf.deleteCharAt(buf.length() - 1);
            this.addErrorMessage(dataEntity, WtbdMustInputKDString.baseMsg((String)buf.toString()));
            return;
        }
        DynamicObjectCollection entryEntity = dy.getDynamicObjectCollection("wtbd_tcardruleentry");
        boolean illegal = false;
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObject entry = (DynamicObject)entryEntity.get(index);
            StringBuilder entityBuf = this.validateNotOffEntryEntity(entry, index, entryEntity.size());
            if (!StringUtils.isNotBlank((CharSequence)entityBuf)) continue;
            illegal = true;
            entityBuf.deleteCharAt(entityBuf.length() - 1);
            buf.append(WtbdMustInputKDString.workSeqTips((int)(index + 1), (String)entityBuf.toString()));
        }
        if (illegal) {
            this.addErrorMessage(dataEntity, WtbdMustInputKDString.baseMsg((String)buf.toString()));
        }
    }

    private StringBuilder validateNotOffEntryEntity(DynamicObject entry, int index, int size) {
        boolean endSeq;
        StringBuilder entityBuf = new StringBuilder();
        int sBeforeScope = entry.getInt("sbeforescope");
        int sAfterScope = entry.getInt("safterscope");
        String sRule = entry.getString("stakecardrule");
        String sSameLen = entry.getString("stakecardsamelen");
        int eBeforeScope = entry.getInt("ebeforescope");
        int eAfterScope = entry.getInt("eafterscope");
        String eRule = entry.getString("etakecardrule");
        String eSameLen = entry.getString("etakecardsamelen");
        boolean startSeq = index == 0;
        boolean bl = endSeq = index == size - 1;
        if (startSeq) {
            if (sBeforeScope == 0) {
                entityBuf.append(WtbdMustInputKDString.sBeforeScopeTips());
            }
            if (sAfterScope == 0) {
                entityBuf.append(WtbdMustInputKDString.sAfterScopeTips());
            }
            if (HRStringUtils.isEmpty((String)sRule)) {
                entityBuf.append(WtbdMustInputKDString.sRuleTips());
            }
            if (HRStringUtils.equals((String)sRule, (String)"5") && HRStringUtils.isEmpty((String)sSameLen)) {
                entityBuf.append(WtbdMustInputKDString.sSameLenTips());
            }
        } else if (endSeq) {
            if (eBeforeScope == 0) {
                entityBuf.append(WtbdMustInputKDString.eBeforeScopeTips());
            }
            if (eAfterScope == 0) {
                entityBuf.append(WtbdMustInputKDString.eAfterScopeTips());
            }
            if (HRStringUtils.isEmpty((String)eRule)) {
                entityBuf.append(WtbdMustInputKDString.eRuleTips());
            }
            if (HRStringUtils.equals((String)eRule, (String)"5") && HRStringUtils.isEmpty((String)eSameLen)) {
                entityBuf.append(WtbdMustInputKDString.eSameLenTips());
            }
        }
        return entityBuf;
    }
}

