/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.validator.workschedule.datetypeadj;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbd.common.constants.workschedule.WorkSchKDString;
import kd.wtc.wtbs.common.enums.workschedule.DateTypeEnum;

public class DateTypeAdjSaveValidator
extends HRDataBaseValidator {
    private static final Log LOG = LogFactory.getLog(DateTypeAdjSaveValidator.class);

    public void validate() {
        super.validate();
        this.validateMustInput4SpecialDate();
        this.validateEntryInput();
    }

    private void validateEntryInput() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            LOG.info("validateEntryInput.pkid:{}", extendedDataEntity.getBillPkId());
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            boolean isAllNullTODateType = entryEntity.stream().allMatch(dyo -> dyo.getLong("todatetype.id") == 0L);
            if (!isAllNullTODateType) continue;
            this.addFatalErrorMessage(extendedDataEntity, WorkSchKDString.getDateTypeAdjEntryInputTip());
        }
    }

    private void validateMustInput4SpecialDate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            LOG.info("validateMustInput4SpecialDate.pkid:{}", extendedDataEntity.getBillPkId());
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            boolean isHasSpecialDate = entryEntity.stream().anyMatch(dyo -> DateTypeEnum.REST_SPECIAL.getId().equals(dyo.getLong("todatetype.id")));
            long specialDateId = dataEntity.getLong("specialdate.id");
            if (!isHasSpecialDate || specialDateId != 0L) continue;
            this.addFatalErrorMessage(extendedDataEntity, WorkSchKDString.getSpecialDateInputTip());
        }
    }
}

