/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.web.basedata.shiftperiod;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbd.business.basedata.shiftperiod.ShiftPeriodService;
import kd.wtc.wtbd.common.constants.shift.ShiftKDString;
import kd.wtc.wtbs.common.cache.IWTCAppCache;
import kd.wtc.wtbs.common.cache.relate.WTCAppCache;

public class ShiftPeriodDeleteOp
extends HRDataBaseOp {
    private boolean mutex = false;
    private final IWTCAppCache appCache = WTCAppCache.get((String)"wtbd_shiftperiod");

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        args.getFieldKeys().add("index");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator(new AbstractValidator(){

            public void validate() {
                Set parentIds = Arrays.stream(this.getDataEntities()).map(dy -> dy.getDataEntity().getLong("parent.id")).collect(Collectors.toSet());
                Map indexesOfPeriodMap = ShiftPeriodService.getInstance().getIndexesOfPeriodByParentId(parentIds);
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    long parentId = dataEntity.getLong("parent.id");
                    int index = dataEntity.getInt("index");
                    List indexes = (List)indexesOfPeriodMap.get(parentId);
                    if (!CollectionUtils.isEmpty((Collection)indexes) && (Integer)indexes.get(indexes.size() - 1) != index) {
                        this.addErrorMessage(extendedDataEntity, ShiftKDString.getDeleteShiftPeriodOnlyMaxIndexTip());
                    }
                    if (ShiftPeriodDeleteOp.this.mutex) continue;
                    this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(ShiftKDString.getShiftPeriodMutexTip(), this.getOperationName(), indexes.size()));
                }
            }
        });
    }

    public void initialize(InitOperationArgs args) {
        super.initialize(args);
        this.mutex = ShiftPeriodService.getInstance().requireShiftPeriodOpMutex(this.appCache);
    }

    public void onReturnOperation(ReturnOperationArgs args) {
        super.onReturnOperation(args);
        if (this.mutex) {
            ShiftPeriodService.getInstance().removeMutex(this.appCache);
        }
    }
}

