/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.web.basedata.shiftperiod;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbd.business.basedata.shiftperiod.ShiftPeriodService;
import kd.wtc.wtbd.common.constants.basedata.shiftperiod.ShiftPeriodConst;
import kd.wtc.wtbd.common.constants.shift.ShiftKDString;
import kd.wtc.wtbs.common.cache.IWTCAppCache;
import kd.wtc.wtbs.common.cache.relate.WTCAppCache;

public class ShiftPeriodSaveOp
extends HRDataBaseOp {
    private static final Log LOG = LogFactory.getLog(ShiftPeriodSaveOp.class);
    private Map<Long, List<Integer>> indexesOfPeriodMap;
    private boolean mutex = false;
    private final IWTCAppCache appCache = WTCAppCache.get((String)"wtbd_shiftperiod");

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        args.getFieldKeys().add("parent");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator(new AbstractValidator(){

            public void validate() {
                Set parentIds = Arrays.stream(this.getDataEntities()).map(dy -> dy.getDataEntity().getLong("parent.id")).collect(Collectors.toSet());
                ShiftPeriodSaveOp.this.indexesOfPeriodMap = ShiftPeriodService.getInstance().getIndexesOfPeriodByParentId(parentIds);
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    long parentId = dataEntity.getLong("parent.id");
                    if (!ShiftPeriodConst.CUSTOM_PERIOD_SET.contains(parentId)) {
                        this.addFatalErrorMessage(extendedDataEntity, ShiftKDString.getNoParentErrTip());
                        continue;
                    }
                    if (dataEntity.getDataEntityState().getFromDatabase() || ShiftPeriodSaveOp.this.mutex) continue;
                    this.addFatalErrorMessage(extendedDataEntity, MessageFormat.format(ShiftKDString.getShiftPeriodMutexTip(), this.getOperationName()));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        LOG.info("ShiftPeriodSaveOp.setInfo:{}", (Object)Arrays.stream(args.getDataEntities()).map(dy -> dy.getString("number")).collect(Collectors.joining()));
        for (DynamicObject dataEntity : args.getDataEntities()) {
            if (dataEntity.getDataEntityState().getFromDatabase()) continue;
            long parentId = dataEntity.getLong("parent.id");
            ILocaleString parentName = dataEntity.getLocaleString("parent.name");
            List<Integer> indexes = this.indexesOfPeriodMap.get(parentId);
            if (indexes == null) continue;
            int currIndex = indexes.size() + 1;
            dataEntity.set("number", (Object)ShiftPeriodService.getInstance().getNumber(parentId, currIndex));
            dataEntity.set("name", (Object)ShiftPeriodService.getInstance().getName(parentName, currIndex));
            dataEntity.set("index", (Object)(indexes.get(indexes.size() - 1) + 1));
        }
    }

    public void initialize(InitOperationArgs args) {
        super.initialize(args);
        this.mutex = ShiftPeriodService.getInstance().requireShiftPeriodOpMutex(this.appCache);
    }

    public void onReturnOperation(ReturnOperationArgs args) {
        super.onReturnOperation(args);
        if (this.mutex) {
            ShiftPeriodService.getInstance().removeMutex(this.appCache);
        }
    }
}

