/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.web.holiday.validate;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbd.common.constants.workschedule.WorkSchKDString;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.workschedule.specialdate.SpecialDateService;
import kd.wtc.wtbs.common.enums.DateAttribute;

public class HolidayValidator
extends HRDataBaseValidator {
    public void validate() {
        this.validateDateType();
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            String holidayType;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            if (!this.validateMustInput(dataEntity, dynamicObject, holidayType = dynamicObject.getString("holidaytype")) && !this.validateUnfix(dataEntity, dynamicObject, holidayType)) continue;
        }
    }

    private void validateDateType() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dateTypeDy = null;
            Object dateTypeObj = extendedDataEntity.getDataEntity().get("datetype");
            if (dateTypeObj instanceof DynamicObject) {
                dateTypeDy = (DynamicObject)dateTypeObj;
            } else if (dateTypeObj instanceof Long) {
                dateTypeDy = BusinessDataServiceHelper.loadSingle((Object)dateTypeObj, (String)"wtbd_datetype");
            }
            if (dateTypeDy != null && WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dateTypeDy, (String)"dateproperty") == DateAttribute.HOLIDAY.getId()) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u5c5e\u6027\u4e3a\u201c\u8282\u5047\u65e5\u201d\u7684\u65e5\u671f\u7c7b\u578b\u3002", (String)"HolidayValidator_14", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean validateMustInput(ExtendedDataEntity dataEntity, DynamicObject dynamicObject, String holidayType) {
        String fixType = dynamicObject.getString("fixedtype");
        if ("A".equals(holidayType)) {
            if (fixType == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5faa\u73af\u7c7b\u578b\u201d\u3002", (String)"HolidayValidator_1", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
                return true;
            }
            if ("A".equals(fixType)) {
                String month = dynamicObject.getString("month");
                String day = dynamicObject.getString("day");
                if (month == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9759\u6001\u6708\u4efd\u201d", (String)"HolidayValidator_2", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
                    return true;
                }
                if (day == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u65e5\u671f\u201d\u3002", (String)"HolidayValidator_3", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
                    return true;
                }
            } else {
                String month = dynamicObject.getString("dymonth");
                String week = dynamicObject.getString("week");
                String day = dynamicObject.getString("dyday");
                if (month == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u52a8\u6001\u6708\u4efd\u201d\u3002", (String)"HolidayValidator_7", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
                    return true;
                }
                if (week == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7b2c\u51e0\u4e2a\u661f\u671f\u201d\u3002", (String)"HolidayValidator_8", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
                    return true;
                }
                if (day == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u661f\u671f\u503c\u201d\u3002", (String)"HolidayValidator_9", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
                    return true;
                }
            }
        }
        return false;
    }

    private boolean validateUnfix(ExtendedDataEntity dataEntity, DynamicObject dynamicObject, String holidayType) {
        DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("unfixentry");
        if ("B".equals(holidayType) && entrys.isEmpty()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u975e\u5faa\u73af\u5047\u671f\u201d\u3002", (String)"HolidayValidator_12", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
            return true;
        }
        if ("B".equals(holidayType)) {
            for (DynamicObject entry : entrys) {
                Date startDate = entry.getDate("ufstartdate");
                Date endDate = entry.getDate("ufenddate");
                if (startDate == null || endDate == null || !startDate.after(endDate)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u5f00\u59cb\u65e5\u671f\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u7ed3\u675f\u65e5\u671f\u201d,\u8bf7\u91cd\u65b0\u8bbe\u5b9a\u3002", (String)"HolidayValidator_15", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
                return true;
            }
            boolean isCross = SpecialDateService.getInstance().validateTimeCross(entrys, "ufstartdate", "ufenddate");
            if (isCross) {
                this.addErrorMessage(dataEntity, WorkSchKDString.getTimePeriodCrossErrTip());
                return true;
            }
        }
        return false;
    }
}

