/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.web.hp.validate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbd.business.hp.HpHolidayCalculateService;
import kd.wtc.wtbd.business.hp.HpHolidayInfoService;
import kd.wtc.wtbd.common.entity.workschedule.WorkSchHolidayParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class HpConflictedValidator
extends HRDataBaseValidator {
    private static final long STATUTORY_HOLIDAY_FULL = 1050L;
    private static final long STATUTORY_HOLIDAY_HALF = 1060L;

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HpHolidayInfoService hpHolidayInfoService = new HpHolidayInfoService();
        HpHolidayCalculateService calculateService = new HpHolidayCalculateService();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject hpDy = dataEntity.getDataEntity();
            DynamicObject hpInfoDy = hpHolidayInfoService.getHpInfoDy(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hpDy, (String)"boid").longValue(), (List)Lists.newArrayList((Object[])new DynamicObject[]{hpDy}), Collections.emptyMap());
            ArrayList workSchHolidayParamList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
            WorkSchHolidayParam workSchHolidayParam = new WorkSchHolidayParam();
            workSchHolidayParam.setHolidayPortFolioIds((List)Lists.newArrayList((Object[])new Long[]{HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hpDy, (String)"boid")}));
            workSchHolidayParam.setStartDate(WTCDateUtils.getMinEndDate());
            workSchHolidayParam.setEndDate(WTCDateUtils.getMaxEndDate());
            workSchHolidayParamList.add(workSchHolidayParam);
            Map conflictedDy = calculateService.getConflictedDy((List)workSchHolidayParamList, new DynamicObject[]{hpInfoDy});
            if (CollectionUtils.isEmpty((Map)conflictedDy)) continue;
            for (Map.Entry entry : conflictedDy.entrySet()) {
                LinkedHashMap value = (LinkedHashMap)entry.getValue();
                for (Map.Entry data : value.entrySet()) {
                    Date conflictDate = (Date)data.getKey();
                    List dys = (List)data.getValue();
                    if (this.verifyInStatutoryHoliday(dys)) continue;
                    HashSet conflictNameSet = Sets.newHashSetWithExpectedSize((int)dys.size());
                    dys.forEach(dy -> conflictNameSet.add(dy.getString("name")));
                    String content = ResManager.loadKDString((String)"%1$s\u5b58\u5728\u91cd\u53e0\u5047\u671f\uff1a%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HpConflictedValidator_0", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]);
                    String conflictName = String.join((CharSequence)"\u3001", conflictNameSet);
                    this.addErrorMessage(dataEntity, String.format(content, WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)conflictDate), conflictName));
                }
            }
        }
    }

    private boolean verifyInStatutoryHoliday(List<DynamicObject> holidayDys) {
        LinkedHashSet dateTypeIds = Sets.newLinkedHashSetWithExpectedSize((int)holidayDys.size());
        for (DynamicObject holidayDy : holidayDys) {
            long dateType = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)holidayDy, (String)"datetype");
            dateTypeIds.add(dateType);
        }
        return dateTypeIds.contains(1050L) || dateTypeIds.contains(1060L);
    }
}

