/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.web.hp.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbd.business.hp.HpHolidayCalculateService;
import kd.wtc.wtbd.business.hp.HpHolidayInfoService;
import kd.wtc.wtbd.common.entity.workschedule.WorkSchHolidayParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class HpHolidayDateTypeValidator
extends HRDataBaseValidator {
    private static final Integer MAX_DATE_TYPE_NUM = 5;

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HpHolidayInfoService hpHolidayInfoService = new HpHolidayInfoService();
        HpHolidayCalculateService calculateService = new HpHolidayCalculateService();
        HashMap dataEntityAndHolidayInfo = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject hpDy = dataEntity.getDataEntity();
            DynamicObject hpInfoDy = hpHolidayInfoService.getHpInfoDy(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hpDy, (String)"boid").longValue(), (List)Lists.newArrayList((Object[])new DynamicObject[]{hpDy}), Collections.emptyMap());
            WorkSchHolidayParam workSchHolidayParam = new WorkSchHolidayParam();
            workSchHolidayParam.setHolidayPortFolioIds((List)Lists.newArrayList((Object[])new Long[]{HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)hpDy, (String)"boid")}));
            workSchHolidayParam.setStartDate(WTCDateUtils.getMinEndDate());
            workSchHolidayParam.setEndDate(WTCDateUtils.getMaxEndDate());
            LinkedHashMap dateListLinkedHashMap = calculateService.groupHoliday(workSchHolidayParam, new DynamicObject[]{hpInfoDy});
            dataEntityAndHolidayInfo.put(dataEntity, dateListLinkedHashMap);
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.checkOverDateType(dataEntity, dataEntityAndHolidayInfo);
        }
    }

    private void checkOverDateType(ExtendedDataEntity dataEntity, Map<ExtendedDataEntity, LinkedHashMap<Date, List<Long>>> dataEntityAndHolidayInfo) {
        String tip = ResManager.loadKDString((String)"\u540c\u4e00\u5929\u6700\u591a\u652f\u63015\u4e2a\u76f8\u540c\u65e5\u671f\u7c7b\u578b\u7684\u5047\u671f\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"HpHolidayDateTypeValidator_0", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]);
        LinkedHashMap<Date, List<Long>> dateAndHolidayIdMap = dataEntityAndHolidayInfo.get(dataEntity);
        LinkedHashMap<Date, List<Long>> dateAndDateTypeIdMap = dataEntityAndHolidayInfo.get(dataEntity);
        Map<Long, Long> holidayIdAndDateMap = this.getHolidayIdAndDateMap(dataEntity);
        for (Map.Entry<Date, List<Long>> entry : dateAndHolidayIdMap.entrySet()) {
            List<Long> holidayIds = entry.getValue();
            ArrayList dateTypeIds = Lists.newArrayListWithExpectedSize((int)holidayIds.size());
            for (Long holidayId : holidayIds) {
                Long dateType = holidayIdAndDateMap.get(holidayId);
                if (dateType == 0L) continue;
                dateTypeIds.add(dateType);
            }
            dateAndDateTypeIdMap.put(entry.getKey(), dateTypeIds);
        }
        for (Map.Entry<Date, List<Long>> entry : dateAndDateTypeIdMap.entrySet()) {
            List<Long> dateTypeIds = entry.getValue();
            HashMap countData = Maps.newHashMapWithExpectedSize((int)dateTypeIds.size());
            for (Long dateTypeId : dateTypeIds) {
                countData.put(dateTypeId, 0);
            }
            for (Long dateTypeId : dateTypeIds) {
                Integer newVal = (Integer)countData.get(dateTypeId) + 1;
                countData.put(dateTypeId, newVal);
            }
            Collection values = countData.values();
            for (Integer num : values) {
                if (num <= MAX_DATE_TYPE_NUM) continue;
                this.addErrorMessage(dataEntity, tip);
                return;
            }
        }
    }

    private Map<Long, Long> getHolidayIdAndDateMap(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection holidayArr = dataEntity.getDataEntity().getDynamicObjectCollection("holidayentity");
        HashMap result = Maps.newHashMapWithExpectedSize((int)holidayArr.size());
        if (CollectionUtils.isEmpty((Collection)holidayArr)) {
            return Collections.emptyMap();
        }
        for (DynamicObject holidayEntryDy : holidayArr) {
            DynamicObject holidayDy = holidayEntryDy.getDynamicObject("holiday");
            result.put(holidayDy.getLong("id"), HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)holidayDy, (String)"datetype"));
        }
        return result;
    }
}

