/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.web.origintime.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.web.DataBaseValidatorService;

public class AbstractOriginTimeValidator
extends HRDataBaseValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            this.checkNumber(dataEntity, dynamicObject);
            this.validateMustInput(dataEntity, dynamicObject);
        }
    }

    private void checkNumber(ExtendedDataEntity dataEntity, DynamicObject dynamicObject) {
        String number = dynamicObject.getString("number");
        String errMsg = DataBaseValidatorService.checkNumber((String)number);
        if (HRStringUtils.isNotEmpty((String)errMsg)) {
            this.addErrorMessage(dataEntity, errMsg);
        }
    }

    private void validateMustInput(ExtendedDataEntity dataEntity, DynamicObject dynamicObject) {
        String number = dynamicObject.getString("number");
        String name = dynamicObject.getString("name");
        if (StringUtils.isBlank((CharSequence)number)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u201c\u7f16\u7801\u201d\u3002", (String)"AbstractOriginTimeValidator_01", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u201c\u540d\u79f0\u201d\u3002", (String)"AbstractOriginTimeValidator_02", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
        }
    }
}

