/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.web.origintime.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbd.opplugin.web.origintime.validator.AbstractOriginTimeValidator;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class ProjectMapConfigValidator
extends AbstractOriginTimeValidator {
    @Override
    public void validate() {
        super.validate();
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = entity.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                return;
            }
            HashSet set = Sets.newHashSet();
            AtomicInteger num = new AtomicInteger();
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String dateAttr = dynamicObject.getString("dateattr");
                String timePropertyId = dynamicObject.getString("shifttbprop");
                String attendanceStatusId = dynamicObject.getString("attstsid");
                if (StringUtils.isBlank((CharSequence)dateAttr) || StringUtils.isBlank((CharSequence)timePropertyId) || StringUtils.isBlank((CharSequence)attendanceStatusId)) continue;
                List<String> dateAttrList = this.stringReplaceToList(dateAttr);
                List<String> timePropertyIdList = this.stringReplaceToList(timePropertyId);
                if (dateAttrList == null) continue;
                dateAttrList.stream().forEach(attr -> timePropertyIdList.stream().forEach(propertyId -> {
                    set.add(attendanceStatusId + ":" + attr + ":" + propertyId);
                    num.getAndIncrement();
                }));
            }
            if (set.size() >= num.intValue()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ec4\u5408\u91cd\u590d\u3002", (String)"ProjectMapConfigValidator_02", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
        }
    }

    private List<String> stringReplaceToList(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        String[] split = value.split(",");
        return Arrays.asList(split).stream().filter(str -> StringUtils.isNotBlank((CharSequence)str)).collect(Collectors.toList());
    }
}

