/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.web.retrieval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbd.business.retrieval.RetrievalItemHelper;
import kd.wtc.wtbd.opplugin.web.retrieval.validator.RetrievalConfigValidator;
import kd.wtc.wtbs.common.util.WTCCollections;

public class RetrievalConfigOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("fetchfieldentry");
        fieldKeys.add("fetchfieldentry.id");
        fieldKeys.add("enable");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new RetrievalConfigValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String opKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        List<Long> pkIds = Arrays.stream(dataEntities).map(param -> param.getLong("id")).collect(Collectors.toList());
        switch (opKey) {
            case "save": {
                this.doSaveFetchConfigItem(args.getDataEntities()[0]);
                break;
            }
            case "delete": {
                pkIds.forEach(id -> RetrievalItemHelper.updateItemConfigIdField((Long)id, null));
                break;
            }
        }
    }

    private void doSaveFetchConfigItem(DynamicObject dynamicObject) {
        long fetchConfigId = dynamicObject.getLong("id");
        DynamicObjectCollection objects = dynamicObject.getDynamicObjectCollection("fetchfieldentry");
        if (WTCCollections.isEmpty((Collection)objects)) {
            return;
        }
        ArrayList<Long> newestItemIds = new ArrayList<Long>(10);
        for (DynamicObject obj : objects) {
            long fetchItemId = obj.getLong("fetchitem.id");
            if (fetchItemId == 0L) continue;
            newestItemIds.add(fetchItemId);
        }
        RetrievalItemHelper.updateItemConfigIdField((Long)fetchConfigId, newestItemIds);
    }
}

