/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.web.retrieval.validator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbd.business.retrieval.RetrievalItemHelper;
import kd.wtc.wtbd.common.constants.retrieval.RetrievalRuleKDString;
import kd.wtc.wtbd.common.constants.scenecfg.SceneCfgKDString;
import kd.wtc.wtbs.common.util.WTCCollections;

public class RetrievalGroupValidator
extends HRDataBaseValidator {
    private HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtbd_retrievalgroup");

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "delete": {
                this.checkDelete(dataEntities);
                break;
            }
            case "save": {
                this.checkNameUnique(dataEntities);
                break;
            }
        }
    }

    private void checkDelete(ExtendedDataEntity[] dataEntities) {
        List pkIds = Arrays.stream(dataEntities).map(param -> param.getDataEntity().getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("parent", "in", pkIds);
        DynamicObject[] dynamicObjects = this.serviceHelper.loadDynamicObjectArray(qFilter.toArray());
        Map<Long, Long> map = Arrays.stream(dynamicObjects).collect(Collectors.toMap(key -> key.getLong("parent.id"), value -> value.getLong("id"), (oldValue, newValue) -> newValue));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long id = dynamicObject.getLong("id");
            if (!map.containsKey(id)) continue;
            this.addErrorMessage(dataEntity, SceneCfgKDString.existReferences());
        }
    }

    private void checkNameUnique(ExtendedDataEntity[] dataEntities) {
        DynamicObject[] dynamicObjects;
        List pkIds = Arrays.stream(dataEntities).filter(param -> param.getDataEntity().getLong("id") != 0L).map(param -> param.getDataEntity().getLong("id")).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(pkIds)) {
            QFilter qFilter = new QFilter("id", "in", pkIds);
            dynamicObjects = this.serviceHelper.queryOriginalArray("id,name", new QFilter[]{qFilter});
        } else {
            dynamicObjects = new DynamicObject[]{};
        }
        Map<Long, DynamicObject> idDyMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(key -> key.getLong("id"), value -> value, (oldValue, newValue) -> newValue));
        ArrayList<String> names = new ArrayList<String>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String name = dynamicObject.getString("name");
            if (!HRStringUtils.isNotEmpty((String)name)) continue;
            names.add(name);
        }
        Map nameToItemMap = RetrievalItemHelper.checkNameUnique(names, Stream.of("2", "3").collect(Collectors.toList()));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long id = dynamicObject.getLong("id");
            String name = dynamicObject.getString("name");
            if (HRStringUtils.isNotEmpty((String)name) && idDyMap.containsKey(id) && HRStringUtils.equals((String)name, (String)idDyMap.get(id).getString("name")) || !HRStringUtils.isNotEmpty((String)name) || !nameToItemMap.containsKey(name)) continue;
            this.addErrorMessage(dataEntity, MessageFormat.format(RetrievalRuleKDString.itemNameExist(), name));
        }
    }
}

