/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.web.retrieval.validator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbd.business.retrieval.RetrievalConfigHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalItemHelper;
import kd.wtc.wtbd.common.constants.retrieval.RetrievalRuleKDString;
import kd.wtc.wtbs.business.util.BaseDataUtils;
import kd.wtc.wtbs.common.util.WTCCollections;

public class RetrievalItemValidator
extends HRDataBaseValidator {
    private static final String[] STR_FIELDS = new String[]{"numberx", "way", "type", "number", "scale", "tailprocessing", "uniquecode", "description", "assigntype"};
    private static final String[] DY_FIELDS = new String[]{"parent", "belongobj", "applyorg"};
    private static final HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtbd_scenefieldcfg");

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "delete": {
                this.checkUsedByFormula(dataEntities);
                break;
            }
            case "save": {
                this.checkNameUnique(dataEntities);
                this.checkAssignTypeAndApplyOrgChange(dataEntities);
                break;
            }
        }
    }

    private void checkUsedByFormula(ExtendedDataEntity[] dataEntities) {
        Map<Long, String> idToUnicodeMap = Arrays.stream(dataEntities).collect(Collectors.toMap(key -> key.getDataEntity().getLong("id"), value -> value.getDataEntity().getString("uniquecode")));
        Set fetchItemIdSet = Arrays.stream(dataEntities).map(single -> single.getDataEntity().getString("id")).collect(Collectors.toSet());
        Map unicodeToFormulaSetNameMap = RetrievalItemHelper.checkUsedByFormula(idToUnicodeMap);
        Map queryUsedItemConfigMap = RetrievalConfigHelper.queryUsedItemConfigMap(fetchItemIdSet);
        Map referenceMap = BaseDataUtils.existReferences((String)"wtbd_scenefieldcfg", (Object[])fetchItemIdSet.toArray());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            BaseDataCheckRefrenceResult refResult;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long id = dynamicObject.getLong("id");
            if (null != referenceMap && referenceMap.containsKey(id) && (refResult = (BaseDataCheckRefrenceResult)referenceMap.get(id)) != null && refResult.isRefence()) {
                this.addFatalErrorMessage(dataEntity, RetrievalRuleKDString.itemUsedByUnknown());
                continue;
            }
            if (unicodeToFormulaSetNameMap.containsKey(id)) {
                this.addErrorMessage(dataEntity, MessageFormat.format(RetrievalRuleKDString.itemUsedByFormula(), unicodeToFormulaSetNameMap.get(id)));
                continue;
            }
            if (!queryUsedItemConfigMap.containsKey(String.valueOf(id))) continue;
            this.addErrorMessage(dataEntity, MessageFormat.format(RetrievalRuleKDString.itemUsedByConfig(), queryUsedItemConfigMap.get(String.valueOf(id))));
        }
    }

    private void checkNameUnique(ExtendedDataEntity[] dataEntities) {
        DynamicObject[] dynamicObjects;
        List pkIds = Arrays.stream(dataEntities).filter(param -> param.getDataEntity().getLong("id") != 0L).map(param -> param.getDataEntity().getLong("id")).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(pkIds)) {
            QFilter qFilter = new QFilter("id", "in", pkIds);
            dynamicObjects = serviceHelper.queryOriginalArray("id,name", new QFilter[]{qFilter});
        } else {
            dynamicObjects = new DynamicObject[]{};
        }
        Map<Long, DynamicObject> idDyMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(key -> key.getLong("id"), value -> value, (oldValue, newValue) -> newValue));
        ArrayList<String> names = new ArrayList<String>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String name = dynamicObject.getString("name");
            if (!HRStringUtils.isNotEmpty((String)name)) continue;
            names.add(name);
        }
        Map nameToItemMap = RetrievalItemHelper.checkNameUnique(names, Stream.of("1").collect(Collectors.toList()));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long id = dynamicObject.getLong("id");
            String name = dynamicObject.getString("name");
            if (HRStringUtils.isNotEmpty((String)name) && idDyMap.containsKey(id) && HRStringUtils.equals((String)name, (String)idDyMap.get(id).getString("name")) || !HRStringUtils.isNotEmpty((String)name) || !nameToItemMap.containsKey(name)) continue;
            this.addErrorMessage(dataEntity, MessageFormat.format(RetrievalRuleKDString.itemNameExist(), name));
        }
    }

    private void checkAssignTypeAndApplyOrgChange(ExtendedDataEntity[] dataEntities) {
        List pkIds = Arrays.stream(dataEntities).filter(param -> param.getDataEntity().getLong("id") != 0L).map(param -> param.getDataEntity().getLong("id")).collect(Collectors.toList());
        if (WTCCollections.isEmpty(pkIds)) {
            return;
        }
        Map referenceMap = BaseDataUtils.existReferences((String)"wtbd_scenefieldcfg", (Object[])pkIds.toArray());
        QFilter qFilter = new QFilter("id", "in", pkIds);
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        Map<Long, DynamicObject> idDyMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(key -> key.getLong("id"), value -> value, (oldValue, newValue) -> newValue));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            BaseDataCheckRefrenceResult refResult;
            boolean isChange;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long id = dynamicObject.getLong("id");
            if (!idDyMap.containsKey(id)) continue;
            DynamicObject dbDy = idDyMap.get(id);
            boolean bl = isChange = !HRStringUtils.equals((String)this.getDyChangedKey(dbDy), (String)this.getDyChangedKey(dynamicObject));
            if (!isChange || null == referenceMap || !referenceMap.containsKey(id) || (refResult = (BaseDataCheckRefrenceResult)referenceMap.get(id)) == null || !refResult.isRefence()) continue;
            this.addFatalErrorMessage(dataEntity, RetrievalRuleKDString.canNotChangeAssignTypeAndApplyOrg());
        }
    }

    private String getDyChangedKey(DynamicObject dy) {
        String value;
        StringBuilder builder = new StringBuilder();
        for (String strField : STR_FIELDS) {
            value = dy.getString(strField);
            builder.append(HRStringUtils.isEmpty((String)value) ? "" : value);
            builder.append("-");
        }
        for (String dyField : DY_FIELDS) {
            value = dy.getString(dyField + ".id");
            builder.append(HRStringUtils.isEmpty((String)value) ? "" : value);
            builder.append("-");
        }
        return builder.toString();
    }
}

