/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.web.round.validator;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class RoundSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity dataEntity = this.getDataEntities()[0];
        this.checkSave(dataEntity);
    }

    private void checkSave(ExtendedDataEntity dataEntity) {
        String settingmode = dataEntity.getDataEntity().getString("settingmode");
        if (HRStringUtils.equals((String)settingmode, (String)"0")) {
            DynamicObjectCollection roundDynamicObjectCollection = this.checkLowerAndUpper(dataEntity);
            RoundSaveValidator.sortRound(roundDynamicObjectCollection);
            this.verifyRound(roundDynamicObjectCollection, dataEntity);
        } else if (HRStringUtils.equals((String)settingmode, (String)"1")) {
            this.checkFunctionMi(dataEntity);
        }
    }

    private void checkFunctionMi(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        if (HRStringUtils.isEmpty((String)dynamicObject.getString("function"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u820d\u5165\u51fd\u6570\u201d\u3002", (String)"RoundSaveValidator_7", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)dynamicObject.getString("accuracy"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7cbe\u5ea6\u201d\u3002", (String)"RoundSaveValidator_8", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObjectCollection checkLowerAndUpper(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection entryDys = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        if (entryDys.size() == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u81f3\u5c11\u4e00\u884c\u820d\u5165\u89c4\u5219\u3002", (String)"RoundSaveValidator_0", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
        }
        int size = entryDys.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryDys.get(i);
            if (dynamicObject.getBoolean("containlower") && dynamicObject.getBoolean("containupper") && dynamicObject.getBoolean("circulate")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u89c4\u5219\u9879\u4e2d\uff0c\u4e0d\u80fd\u540c\u65f6\u52fe\u9009\u201c\u5305\u542b\u4e0a\u9650\u503c\u201d\u3001\u201c\u5305\u542b\u4e0b\u9650\u503c\u201d\u548c\u201c\u5faa\u73af\u201d\u9009\u9879\u3002", (String)"RoundSaveValidator_1", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
            }
            if (dynamicObject.getBoolean("isoriginvalue") || dynamicObject.getBigDecimal("targetvalue") != null) continue;
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u820d\u5165\u89c4\u5219\u7b2c %s\u884c\u76ee\u6807\u503c\u3002", (String)"RoundSaveValidator_2", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]), i + 1));
        }
        return entryDys;
    }

    private void verifyRound(DynamicObjectCollection dys, ExtendedDataEntity dataEntity) {
        for (int i = 0; i < dys.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dys.get(i);
            BigDecimal lowerlimitvalue = dynamicObject.getBigDecimal("lowerlimitvalue");
            BigDecimal upperlimitvalue = dynamicObject.getBigDecimal("upperlimitvalue");
            if (lowerlimitvalue == null || upperlimitvalue == null) continue;
            if (lowerlimitvalue.compareTo(upperlimitvalue) == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u89c4\u5219\u9879\u4e2d\u4e0a\u9650\u503c\u4e0e\u4e0b\u9650\u503c\u4e0d\u80fd\u76f8\u540c\u3002", (String)"RoundSaveValidator_3", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
                return;
            }
            if (lowerlimitvalue.compareTo(upperlimitvalue) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0a\u9650\u503c\u4e0d\u5f97\u5c0f\u4e8e\u4e0b\u9650\u503c\u3002", (String)"RoundSaveValidator_4", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
                return;
            }
            if (i == 0) continue;
            DynamicObject lastDynamicObject = (DynamicObject)dys.get(i - 1);
            BigDecimal lastuupervalue = lastDynamicObject.getBigDecimal("upperlimitvalue");
            if (lowerlimitvalue.compareTo(lastuupervalue) < 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u89c4\u5219\u9879\u95f4\u4e0b\u9650\u503c\u4e0e\u4e0a\u9650\u503c\u7684\u6570\u503c\u533a\u95f4\u4e0d\u80fd\u5b58\u5728\u91cd\u5408\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RoundSaveValidator_5", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
                return;
            }
            if (lowerlimitvalue.compareTo(lastuupervalue) != 0 || !dynamicObject.getBoolean("containlower") || !lastDynamicObject.getBoolean("containupper")) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u540c\u89c4\u5219\u9879\u4e0b\u9650\u503c\u6216\u4e0a\u9650\u503c\u76f8\u540c\u65f6\uff0c\u4e0d\u80fd\u540c\u65f6\u5f00\u542f\u5305\u542b\u3002\u8bf7\u68c0\u67e5", (String)"RoundSaveValidator_6", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private static void sortRound(DynamicObjectCollection roundDynamicObjectCollection) {
        roundDynamicObjectCollection.sort(Comparator.comparingInt(dynamicObject -> dynamicObject.getInt("lowerlimitvalue")));
    }
}

