/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.opplugin.web.util.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class ConfCountryValidator
extends HRDataBaseValidator {
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_confcombin");

    public void validate() {
        ArrayList<String> dataStatus = new ArrayList<String>();
        dataStatus.add("-1");
        dataStatus.add("-2");
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Stream.of(dataEntities).forEach(dataEntity -> {
            DynamicObjectCollection countryid = dataEntity.getDataEntity().getDynamicObjectCollection("countryid");
            List countryIds = countryid.stream().filter(Objects::nonNull).map(arg -> arg.getLong("fbasedataid_id")).collect(Collectors.toList());
            QFilter[] qFilters = new QFilter[]{new QFilter("countryid.fbasedataid_id", "in", countryIds), new QFilter("id", "!=", dataEntity.getDataEntity().getPkValue()), new QFilter("boid", "!=", (Object)dataEntity.getDataEntity().getLong("boid")), new QFilter("datastatus", "not in", (Object)dataStatus)};
            DynamicObject[] otherData = serviceHelper.loadDynamicObjectArray(qFilters);
            if (otherData != null && otherData.length != 0) {
                DynamicObjectCollection multdyn = otherData[0].getDynamicObjectCollection("countryid");
                DynamicObject dynamicObject = (DynamicObject)multdyn.stream().filter(item -> countryIds.contains(item.get("fbasedataid_id"))).collect(Collectors.toList()).get(0);
                String name = dynamicObject.getLocaleString("fbasedataid.name").getLocaleValue();
                String number = otherData[0].getString("number");
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u56fd\u5bb6\u201c%1$s\u201d\u7684\u6570\u636e\u201c%2$s\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u56fd\u5bb6\u5730\u533a\u3002", (String)"ConfCountryValidator_0", (String)"wtc-wtbd-opplugin", (Object[])new Object[0]), name, number));
            }
        });
    }
}

