/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.common.constants.retrieval;

public enum RetrievalItemTypeEnum {
    STRING("string"),
    DYNAMICOBJECT("dynamicObject"),
    ENUM("enum"),
    DATE("date"),
    NUMBER("number"),
    BOOLEAN("boolean"),
    ARRAY("array");

    private final String dbValue;

    private RetrievalItemTypeEnum(String dbValue) {
        this.dbValue = dbValue;
    }

    public String getDbValue() {
        return this.dbValue;
    }

    public static RetrievalItemTypeEnum of(String value) {
        for (RetrievalItemTypeEnum typeEnum : RetrievalItemTypeEnum.values()) {
            if (!typeEnum.dbValue.equals(value)) continue;
            return typeEnum;
        }
        return null;
    }

    public static RetrievalItemTypeEnum formCalElementType(String dataType) {
        switch (dataType) {
            case "TEXT": {
                return STRING;
            }
            case "NUM": 
            case "MONEY": 
            case "INT": {
                return NUMBER;
            }
            case "DATE": {
                return DATE;
            }
            case "BOOLEAN": {
                return BOOLEAN;
            }
        }
        return STRING;
    }
}

