/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.common.constants.retrieval;

import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;

public enum WTCDataTypeEnum {
    OBJECT(DataTypeEnum.OBJECT),
    NUM(DataTypeEnum.NUM),
    TEXT(DataTypeEnum.TEXT),
    BOOLEAN(DataTypeEnum.BOOLEAN),
    INT(DataTypeEnum.INT),
    DATE(DataTypeEnum.DATE),
    MONEY(DataTypeEnum.MONEY),
    ARRAY_NUM(DataTypeEnum.ARRAY_NUM),
    ARRAY_STRING(DataTypeEnum.ARRAY_STRING),
    ARRAY_BOOLEAN(DataTypeEnum.ARRAY_BOOLEAN),
    ARRAY_INT(DataTypeEnum.ARRAY_INT),
    ARRAY_DATE(DataTypeEnum.ARRAY_DATE),
    ARRAY_OBJECT(DataTypeEnum.ARRAY_OBJECT),
    BASE(DataTypeEnum.BASE),
    NULL(DataTypeEnum.NULL);

    private final DataTypeEnum type;

    private WTCDataTypeEnum(DataTypeEnum type) {
        this.type = type;
    }

    public String getCode() {
        return this.type.getCode();
    }

    public String getAlias() {
        return this.type.getAlias();
    }

    public DataTypeEnum getType() {
        return this.type;
    }

    public static WTCDataTypeEnum ofItemType(String itemType) {
        switch (itemType) {
            case "string": {
                return TEXT;
            }
            case "dynamicObject": {
                throw new IllegalArgumentException("id is ambiguous type, long or string.");
            }
            case "enum": {
                return TEXT;
            }
            case "date": {
                return DATE;
            }
            case "number": {
                return NUM;
            }
            case "boolean": {
                return BOOLEAN;
            }
            case "array": {
                return ARRAY_OBJECT;
            }
        }
        return null;
    }

    public static WTCDataTypeEnum of(DataTypeEnum type) {
        switch (type) {
            case OBJECT: {
                return OBJECT;
            }
            case NUM: {
                return NUM;
            }
            case TEXT: {
                return TEXT;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case INT: {
                return INT;
            }
            case DATE: {
                return DATE;
            }
            case MONEY: {
                return MONEY;
            }
            case ARRAY_NUM: {
                return ARRAY_NUM;
            }
            case ARRAY_STRING: {
                return ARRAY_STRING;
            }
            case ARRAY_BOOLEAN: {
                return ARRAY_BOOLEAN;
            }
            case ARRAY_INT: {
                return ARRAY_INT;
            }
            case ARRAY_DATE: {
                return ARRAY_DATE;
            }
            case ARRAY_OBJECT: {
                return ARRAY_OBJECT;
            }
            case BASE: {
                return BASE;
            }
            case NULL: {
                return NULL;
            }
        }
        return null;
    }
}

