/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.common.entity.workschedule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleNewEntryVo;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class WorkScheduleVo
implements Serializable {
    private static final long serialVersionUID = 8177052777504010242L;
    private final int rows;
    private static final int cols = 7;
    private static final String mode = "w";
    private String yearMonth;
    List<WorkScheduleNewEntryVo> cells;

    public WorkScheduleVo() {
        this.rows = 6;
        this.yearMonth = "";
        this.cells = new ArrayList<WorkScheduleNewEntryVo>();
    }

    public WorkScheduleVo(String yearMonth, List<WorkScheduleNewEntryVo> list) {
        this.yearMonth = yearMonth;
        this.cells = this.fillVoList4Show(yearMonth, list);
        this.rows = this.cells.size() > 35 ? 6 : 5;
    }

    private List<WorkScheduleNewEntryVo> fillVoList4Show(String yearMonth, List<WorkScheduleNewEntryVo> voList) {
        if (voList.isEmpty()) {
            return voList;
        }
        ArrayList<WorkScheduleNewEntryVo> result = new ArrayList<WorkScheduleNewEntryVo>(voList.size());
        Date curMonthFirstDate = WorkScheduleVo.getMonthFirstDay(yearMonth);
        Date curMonthLastDay = WorkScheduleVo.getMonthLastDay(yearMonth);
        result.addAll(this.getPreMonthVo(curMonthFirstDate));
        Date existFirstDate = voList.get(0).getWorkDate();
        result.addAll(this.getCurMonthPreVo(curMonthFirstDate, existFirstDate));
        result.addAll(voList);
        Date existLastDate = voList.get(voList.size() - 1).getWorkDate();
        result.addAll(this.getCurMonthPostVo(existLastDate, curMonthLastDay));
        int size = result.size();
        if (size <= 35) {
            result.addAll(this.getPostMonthVo(curMonthLastDay, 35 - size));
        } else {
            result.addAll(this.getPostMonthVo(curMonthLastDay, 42 - size));
        }
        return result;
    }

    private List<WorkScheduleNewEntryVo> getPostMonthVo(Date curMonthLastDay, int days) {
        if (days == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WorkScheduleNewEntryVo> result = new ArrayList<WorkScheduleNewEntryVo>(16);
        Date curDate = WorkScheduleVo.getNextDay(WTCDateUtils.getZeroDate((Date)curMonthLastDay), 1);
        while (days-- > 0) {
            WorkScheduleNewEntryVo vo = new WorkScheduleNewEntryVo(0, curDate);
            curDate = WorkScheduleVo.getNextDay(curDate, 1);
            result.add(vo);
        }
        return result;
    }

    private List<WorkScheduleNewEntryVo> getCurMonthPostVo(Date existLastDate, Date curMonthLastDay) {
        existLastDate = WTCDateUtils.getZeroDate((Date)existLastDate);
        curMonthLastDay = WTCDateUtils.getZeroDate((Date)curMonthLastDay);
        ArrayList<WorkScheduleNewEntryVo> result = new ArrayList<WorkScheduleNewEntryVo>(16);
        Date curDate = WorkScheduleVo.getNextDay(existLastDate, 1);
        while (curDate.getTime() < curMonthLastDay.getTime()) {
            WorkScheduleNewEntryVo vo = new WorkScheduleNewEntryVo(0, curDate);
            curDate = WorkScheduleVo.getNextDay(curDate, 1);
            result.add(vo);
        }
        return result;
    }

    private List<WorkScheduleNewEntryVo> getCurMonthPreVo(Date curMonthFirstDate, Date existFirstDate) {
        curMonthFirstDate = WTCDateUtils.getZeroDate((Date)curMonthFirstDate);
        existFirstDate = WTCDateUtils.getZeroDate((Date)existFirstDate);
        ArrayList<WorkScheduleNewEntryVo> result = new ArrayList<WorkScheduleNewEntryVo>(16);
        Date curDate = curMonthFirstDate;
        while (curDate.getTime() < existFirstDate.getTime()) {
            WorkScheduleNewEntryVo vo = new WorkScheduleNewEntryVo(0, curDate);
            curDate = WorkScheduleVo.getNextDay(curDate, 1);
            result.add(vo);
        }
        return result;
    }

    private List<WorkScheduleNewEntryVo> getPreMonthVo(Date curMonthFirstDate) {
        curMonthFirstDate = WTCDateUtils.getZeroDate((Date)curMonthFirstDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(curMonthFirstDate);
        int dayOfWeekEnum = cal.get(7);
        int needAppendDay = 0;
        switch (dayOfWeekEnum) {
            case 2: {
                needAppendDay = 0;
                break;
            }
            case 3: {
                needAppendDay = 1;
                break;
            }
            case 4: {
                needAppendDay = 2;
                break;
            }
            case 5: {
                needAppendDay = 3;
                break;
            }
            case 6: {
                needAppendDay = 4;
                break;
            }
            case 7: {
                needAppendDay = 5;
                break;
            }
            case 1: {
                needAppendDay = 6;
                break;
            }
        }
        ArrayList<WorkScheduleNewEntryVo> result = new ArrayList<WorkScheduleNewEntryVo>(needAppendDay);
        for (int i = 1; i <= needAppendDay; ++i) {
            Date nextDay = WorkScheduleVo.getNextDay(curMonthFirstDate, -i);
            WorkScheduleNewEntryVo vo = new WorkScheduleNewEntryVo(0, nextDay);
            result.add(0, vo);
        }
        return result;
    }

    public static Date getNextDay(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, day);
        return calendar.getTime();
    }

    private static Date getMonthFirstDay(String yearMonth) {
        Date date = WTCDateUtils.str2Date((String)yearMonth, (String)"yyyy-MM");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }

    private static Date getMonthLastDay(String yearMonth) {
        Date date = WTCDateUtils.str2Date((String)yearMonth, (String)"yyyy-MM");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return 7;
    }

    public String getMode() {
        return mode;
    }

    public String getYearMonth() {
        return this.yearMonth;
    }

    public List<WorkScheduleNewEntryVo> getCells() {
        return this.cells;
    }
}

