/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.common.enums.retrieval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.wtc.wtbd.common.enums.retrieval.ConditionValueTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.RuleOperatorEnum;
import kd.wtc.wtbs.common.MultiLangEnumBridge;

public enum ConditionFieldTypeEnum {
    TYPE_ID("Id", new MultiLangEnumBridge("id", "ConditionFieldTypeEnum_0", "wtc-wtbd-common")),
    TYPE_ENUM("Enum", new MultiLangEnumBridge("\u679a\u4e3e", "ConditionFieldTypeEnum_1", "wtc-wtbd-common")),
    TYPE_NUM("BigDecimal", new MultiLangEnumBridge("\u6570\u503c", "ConditionFieldTypeEnum_2", "wtc-wtbd-common")),
    TYPE_DATE("Date", new MultiLangEnumBridge("\u65f6\u95f4", "ConditionFieldTypeEnum_3", "wtc-wtbd-common")),
    TYPE_TEXT("String", new MultiLangEnumBridge("\u6587\u672c", "ConditionFieldTypeEnum_4", "wtc-wtbd-common")),
    TYPE_BOOLEAN("Boolean", new MultiLangEnumBridge("\u590d\u9009\u6846", "ConditionFieldTypeEnum_5", "wtc-wtbd-common"));

    private String code;
    private MultiLangEnumBridge name;

    private ConditionFieldTypeEnum(String code, MultiLangEnumBridge name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public MultiLangEnumBridge getName() {
        return this.name;
    }

    public static String getDesc(String code) {
        ConditionFieldTypeEnum[] valueArr;
        if (code == null) {
            return null;
        }
        for (ConditionFieldTypeEnum fieldTypeEnum : valueArr = ConditionFieldTypeEnum.values()) {
            if (!fieldTypeEnum.getCode().equals(code)) continue;
            return fieldTypeEnum.getDesc();
        }
        return null;
    }

    public String getDesc() {
        return this.name.loadKDString();
    }

    public static String getCompareTypeByValue(String valueCode) {
        return RuleOperatorEnum.getEnum(valueCode).getName();
    }

    public static List<RuleOperatorEnum> getJudgeConditionByType(String type) {
        List<RuleOperatorEnum> list;
        switch (type) {
            case "Id": 
            case "Enum": {
                list = Arrays.asList(RuleOperatorEnum.IN, RuleOperatorEnum.NOT_IN, RuleOperatorEnum.EQUAL, RuleOperatorEnum.NOT_EQUAL, RuleOperatorEnum.IS_NULL, RuleOperatorEnum.IS_NOT_NULL);
                break;
            }
            case "BigDecimal": {
                list = Arrays.asList(RuleOperatorEnum.EQUAL, RuleOperatorEnum.NOT_EQUAL, RuleOperatorEnum.GREATER_THAN, RuleOperatorEnum.LESS_THAN, RuleOperatorEnum.GREATER_OR_EQUAL, RuleOperatorEnum.LESS_OR_EQUAL);
                break;
            }
            case "Date": {
                list = Arrays.asList(RuleOperatorEnum.EQUAL, RuleOperatorEnum.NOT_EQUAL, RuleOperatorEnum.GREATER_THAN, RuleOperatorEnum.LESS_THAN, RuleOperatorEnum.GREATER_OR_EQUAL, RuleOperatorEnum.LESS_OR_EQUAL);
                break;
            }
            case "String": {
                list = Arrays.asList(RuleOperatorEnum.EQUAL, RuleOperatorEnum.NOT_EQUAL, RuleOperatorEnum.CONTAINS, RuleOperatorEnum.NOT_CONTAINS, RuleOperatorEnum.IS_NULL, RuleOperatorEnum.IS_NOT_NULL);
                break;
            }
            default: {
                list = new ArrayList<RuleOperatorEnum>(0);
            }
        }
        return list;
    }

    public static List<ConditionValueTypeEnum> getValueTypeByCondition(String type) {
        List<ConditionValueTypeEnum> list;
        switch (type) {
            case "==": 
            case "!=": {
                list = new ArrayList<ConditionValueTypeEnum>(Arrays.asList(ConditionValueTypeEnum.TYPE_FIXED, ConditionValueTypeEnum.TYPE_FTITEM, ConditionValueTypeEnum.TYPE_PERSON, ConditionValueTypeEnum.TYPE_AFFILIATION));
                break;
            }
            case ">": 
            case "<": 
            case ">=": 
            case "<=": 
            case "startsWith": 
            case "endsWith": 
            case "contains": 
            case "not_contains": {
                list = new ArrayList<ConditionValueTypeEnum>(Arrays.asList(ConditionValueTypeEnum.TYPE_FIXED, ConditionValueTypeEnum.TYPE_FTITEM, ConditionValueTypeEnum.TYPE_AFFILIATION));
                break;
            }
            case "in": 
            case "not_in": {
                list = Collections.singletonList(ConditionValueTypeEnum.TYPE_FIXED);
                break;
            }
            default: {
                list = new ArrayList<ConditionValueTypeEnum>(0);
            }
        }
        return list;
    }

    public static boolean getMultiSelectByCompareType(String compareType) {
        List<String> multiSelectTypeList = Arrays.asList("in", "not_in");
        return multiSelectTypeList.contains(compareType);
    }

    public static List<ConditionValueTypeEnum> getValueTypeByFieldType(String fieldType) {
        List<ConditionValueTypeEnum> list;
        switch (fieldType) {
            case "Id": {
                list = new ArrayList<ConditionValueTypeEnum>(Arrays.asList(ConditionValueTypeEnum.TYPE_PERSON, ConditionValueTypeEnum.TYPE_FIXED, ConditionValueTypeEnum.TYPE_FTITEM));
                break;
            }
            case "Enum": {
                list = Collections.singletonList(ConditionValueTypeEnum.TYPE_FIXED);
                break;
            }
            case "BigDecimal": {
                list = new ArrayList<ConditionValueTypeEnum>(Arrays.asList(ConditionValueTypeEnum.TYPE_FIXED, ConditionValueTypeEnum.TYPE_FTITEM));
                break;
            }
            case "Date": {
                list = new ArrayList<ConditionValueTypeEnum>(Arrays.asList(ConditionValueTypeEnum.TYPE_FIXED, ConditionValueTypeEnum.TYPE_FTITEM, ConditionValueTypeEnum.TYPE_AFFILIATION));
                break;
            }
            case "String": {
                list = new ArrayList<ConditionValueTypeEnum>(Arrays.asList(ConditionValueTypeEnum.TYPE_FIXED, ConditionValueTypeEnum.TYPE_FTITEM));
                break;
            }
            default: {
                list = new ArrayList<ConditionValueTypeEnum>(0);
            }
        }
        return list;
    }

    public static ConditionFieldTypeEnum getByCode(String code) {
        ConditionFieldTypeEnum[] values;
        for (ConditionFieldTypeEnum value : values = ConditionFieldTypeEnum.values()) {
            if (!value.getCode().equals(code)) continue;
            return value;
        }
        return null;
    }
}

