/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.common.shift;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbd.common.shift.ShiftTypeEnum;
import kd.wtc.wtbs.common.model.shift.RefDateType;

public class ShiftEntry
implements Serializable,
Cloneable {
    private static final Log LOGGER = LogFactory.getLog(ShiftEntry.class);
    private static final long serialVersionUID = -1042894360938617876L;
    private int index;
    private long shiftPeriod;
    private boolean isLockShiftPeriod;
    private RefDateType referenceStartDay;
    private int shiftStart;
    private RefDateType referenceEndDay;
    private int shiftEnd;
    private ShiftTypeEnum type;
    private boolean workCard;
    private boolean startCheck;
    private boolean offWorkCard;
    private boolean endCheck;
    private long punchCardPairId;

    public ShiftEntry() {
    }

    public ShiftEntry(IDataModel model, DynamicObject object, ShiftTypeEnum typeEnum) {
        switch (typeEnum) {
            case WORK: {
                if (object == null) break;
                this.referenceStartDay = RefDateType.from((String)object.getString("workstartday"));
                this.shiftStart = object.getInt("workstarttime");
                this.referenceEndDay = RefDateType.from((String)object.getString("workendday"));
                this.shiftEnd = object.getInt("workendtime");
                this.type = ShiftTypeEnum.WORK;
                break;
            }
            case REST: {
                if (object == null) break;
                this.referenceStartDay = RefDateType.from((String)object.getString("refstartday"));
                this.shiftStart = object.getInt("brestartdate");
                this.referenceEndDay = RefDateType.from((String)object.getString("refendday"));
                this.shiftEnd = object.getInt("breenddate");
                this.type = ShiftTypeEnum.REST;
                break;
            }
            case SHIFT: {
                if (object == null) break;
                this.referenceStartDay = RefDateType.from((String)object.getString("refstartday"));
                this.shiftStart = object.getInt("shiftstartdate");
                this.workCard = object.getBoolean("isworktimestart");
                this.referenceEndDay = RefDateType.from((String)object.getString("refendday"));
                this.offWorkCard = object.getBoolean("isworktimeend");
                this.shiftEnd = object.getInt("shiftenddate");
                DynamicObject shiftPeriod = object.getDynamicObject("shiftperiod");
                if (Objects.nonNull(shiftPeriod)) {
                    this.shiftPeriod = shiftPeriod.getLong("id");
                }
                this.type = ShiftTypeEnum.getByType(object.getString("outworktype"));
                this.index = object.getInt("seq") - 1;
                break;
            }
            case INTERVAL: {
                this.referenceStartDay = RefDateType.from((String)model.getDataEntity().getString("referencestartday"));
                this.shiftStart = model.getDataEntity().getInt("shiftstart");
                this.referenceEndDay = RefDateType.from((String)model.getDataEntity().getString("referenceendday"));
                this.shiftEnd = model.getDataEntity().getInt("shiftend");
                this.type = ShiftTypeEnum.INTERVAL;
                break;
            }
            default: {
                throw new KDException(ErrorCode.of((String)"500", (String)"shiftEntry", (String)"wtc-wtbd-formplugin", (String)ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u679a\u4e3e\u7684\u5904\u7406\u65b9\u5f0f", (String)"ShiftEntry_0", (String)"wtc-wtbd-common", (Object[])new Object[0])), new Object[0]);
            }
        }
    }

    public static boolean hasRepeat(List<ShiftEntry> shifts) {
        if (shifts.size() > 1) {
            shifts.sort(Comparator.comparingInt(ShiftEntry::getRefShiftStart));
            ShiftEntry pre = null;
            for (ShiftEntry currentShift : shifts) {
                if (pre == null) {
                    pre = currentShift;
                    continue;
                }
                if (pre.getRefShiftEnd() > currentShift.getRefShiftStart()) {
                    return true;
                }
                pre = currentShift;
            }
        }
        return false;
    }

    public List<ShiftEntry> getSplitShift(ShiftEntry shift) {
        ShiftEntry split;
        if (this.getRefShiftStart() >= shift.getRefShiftEnd() || this.getRefShiftEnd() <= shift.getRefShiftStart()) {
            return Collections.emptyList();
        }
        ArrayList<ShiftEntry> result = new ArrayList<ShiftEntry>();
        if (shift.getRefShiftStart() < this.getRefShiftStart() && shift.getRefShiftEnd() < this.getRefShiftEnd()) {
            split = new ShiftEntry();
            split.type = this.type;
            split.shiftStart = shift.shiftEnd;
            split.referenceStartDay = shift.referenceEndDay;
            split.shiftEnd = this.shiftEnd;
            split.referenceEndDay = this.referenceEndDay;
            result.add(split);
        }
        if (shift.getRefShiftEnd() > this.getRefShiftEnd() && shift.getRefShiftStart() > this.getRefShiftStart()) {
            split = new ShiftEntry();
            split.type = this.type;
            split.shiftStart = this.shiftStart;
            split.referenceStartDay = this.referenceStartDay;
            split.shiftEnd = shift.shiftStart;
            split.referenceEndDay = shift.referenceStartDay;
            result.add(split);
        }
        if (this.contain(shift)) {
            split = new ShiftEntry();
            split.type = this.type;
            split.shiftStart = this.shiftStart;
            split.referenceStartDay = this.referenceStartDay;
            split.shiftEnd = shift.shiftStart;
            split.referenceEndDay = shift.referenceStartDay;
            if (split.validate().length() == 0) {
                result.add(split);
            }
            ShiftEntry split1 = new ShiftEntry();
            split1.type = this.type;
            split1.shiftStart = shift.shiftEnd;
            split1.referenceStartDay = shift.referenceEndDay;
            split1.shiftEnd = this.shiftEnd;
            split1.referenceEndDay = this.referenceEndDay;
            if (split1.validate().length() == 0) {
                result.add(split1);
            }
        }
        return result;
    }

    public boolean contain(ShiftEntry shift) {
        return this.getRefShiftStart() <= shift.getRefShiftStart() && this.getRefShiftEnd() >= shift.getRefShiftEnd();
    }

    public String validate() {
        if (!this.isEmpty()) {
            if (this.checkTimeDuration()) {
                return ResManager.loadKDString((String)"\u73ed\u6b21\u6700\u665a\u4e0b\u73ed\u65f6\u70b9\u5e94\u665a\u4e8e\u6700\u65e9\u4e0a\u73ed\u65f6\u70b9\u3002", (String)"ShiftEntry_1", (String)"wtc-wtbd-common", (Object[])new Object[0]);
            }
        } else {
            return ResManager.loadKDString((String)"\u4e0a\u73ed\u65f6\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ShiftEntry_2", (String)"wtc-wtbd-common", (Object[])new Object[0]);
        }
        return "";
    }

    public boolean isEmpty() {
        return this.referenceStartDay == null || this.shiftStart == -1 || this.referenceEndDay == null || this.shiftEnd == -1;
    }

    public boolean checkTimeDuration() {
        return this.getRefShiftEnd() <= this.getRefShiftStart();
    }

    public int getTime() {
        return this.getRefShiftEnd() - this.getRefShiftStart();
    }

    public BigDecimal getWorkTimeHour() {
        return new BigDecimal(this.getTime()).divide(new BigDecimal(3600), 2, 4);
    }

    public RefDateType getReferenceStartDay() {
        return this.referenceStartDay;
    }

    public ShiftEntry setReferenceStartDay(RefDateType referenceStartDay) {
        this.referenceStartDay = referenceStartDay;
        return this;
    }

    public RefDateType getReferenceEndDay() {
        return this.referenceEndDay;
    }

    public ShiftEntry setReferenceEndDay(RefDateType referenceEndDay) {
        this.referenceEndDay = referenceEndDay;
        return this;
    }

    public int getShiftStart() {
        return this.shiftStart;
    }

    public ShiftEntry setShiftStartAndCheck(int shiftStart) {
        this.shiftStart = shiftStart >= 86400 ? shiftStart - 86400 : shiftStart;
        return this;
    }

    public int getShiftEnd() {
        return this.shiftEnd;
    }

    public ShiftEntry setShiftEndAndCheck(int shiftEnd) {
        this.shiftEnd = shiftEnd >= 86400 ? shiftEnd - 86400 : shiftEnd;
        return this;
    }

    public int getRefShiftStart() {
        int result = this.shiftStart;
        if (this.referenceStartDay == RefDateType.NEXTDAY) {
            result += 86400;
        }
        return result;
    }

    public int getRefShiftEnd() {
        int result = this.shiftEnd;
        if (this.referenceEndDay == RefDateType.NEXTDAY) {
            result += 86400;
        }
        return result;
    }

    public String getType() {
        return this.type.getType();
    }

    public ShiftEntry setType(ShiftTypeEnum type) {
        this.type = type;
        return this;
    }

    public ShiftTypeEnum getTypeEnum() {
        return this.type;
    }

    public boolean isStartCheck() {
        return this.startCheck;
    }

    public ShiftEntry setStartCheck(boolean startCheck) {
        this.startCheck = startCheck;
        return this;
    }

    public boolean isEndCheck() {
        return this.endCheck;
    }

    public ShiftEntry setEndCheck(boolean endCheck) {
        this.endCheck = endCheck;
        return this;
    }

    public long getShiftPeriod() {
        return this.shiftPeriod;
    }

    public ShiftEntry setShiftPeriod(long shiftPeriod) {
        this.shiftPeriod = shiftPeriod;
        return this;
    }

    public boolean isLockShiftPeriod() {
        return this.isLockShiftPeriod;
    }

    public ShiftEntry setLockShiftPeriod(boolean lockShiftPeriod) {
        this.isLockShiftPeriod = lockShiftPeriod;
        return this;
    }

    public boolean isWorkCard() {
        return this.workCard;
    }

    public ShiftEntry setWorkCard(boolean workCard) {
        this.workCard = workCard;
        return this;
    }

    public boolean isOffWorkCard() {
        return this.offWorkCard;
    }

    public ShiftEntry setOffWorkCard(boolean offWorkCard) {
        this.offWorkCard = offWorkCard;
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public ShiftEntry setIndex(int index) {
        this.index = index;
        return this;
    }

    public boolean isEqual(ShiftEntry shift) {
        return this.getRefShiftStart() == shift.getRefShiftStart() && this.getRefShiftEnd() == shift.getRefShiftEnd();
    }

    public long getPunchCardPairId() {
        return this.punchCardPairId;
    }

    public ShiftEntry setPunchCardPairId(long punchCardPairId) {
        this.punchCardPairId = punchCardPairId;
        return this;
    }

    public ShiftEntry clone() {
        ShiftEntry clone = null;
        try {
            clone = (ShiftEntry)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            LOGGER.error("shiftEntry clone error ", (Throwable)exception);
            throw new KDException(ErrorCode.of((String)"500", (String)"Wtbd", (String)"wtc-wtbd-formplugin", (String)ResManager.loadKDString((String)"\u73ed\u6b21\u5206\u5f55\u514b\u9686\u51fa\u9519\u3002", (String)"ShiftEntry_3", (String)"wtc-wtbd-common", (Object[])new Object[0])), new Object[]{exception});
        }
        return clone;
    }
}

