/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.common.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.wtc.wtbd.common.utils.WTCDateTimeUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class WTCObjectUtils {
    private static final Log logger = LogFactory.getLog(WTCObjectUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String objectToString(Object obj) {
        if (obj == null || !(obj instanceof Serializable)) {
            return null;
        }
        String result = null;
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bs);
            oos.writeObject(obj);
            result = Base64.getEncoder().encodeToString(bs.toByteArray());
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                bs.close();
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException exception) {
                logger.error((Throwable)exception);
            }
        }
        return result;
    }

    public static Object cloneObject(Object source) {
        Object result = null;
        if (source != null) {
            Class<?> sourceClass = source.getClass();
            try {
                Method mtd = sourceClass.getMethod("clone", new Class[0]);
                try {
                    result = mtd.invoke(source, new Object[0]);
                }
                catch (IllegalArgumentException e1) {
                    result = null;
                }
                catch (IllegalAccessException e1) {
                    result = null;
                }
                catch (InvocationTargetException e1) {
                    result = null;
                }
            }
            catch (SecurityException e) {
                result = null;
            }
            catch (NoSuchMethodException e) {
                result = null;
            }
        }
        return result;
    }

    public static HashMap<?, ?> cloneHashMap(HashMap<?, ?> map) {
        return map != null ? (HashMap)map.clone() : null;
    }

    public static Object safeCloneObject(Serializable src) {
        try {
            return WTCObjectUtils.cloneObject(src);
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException(ex.toString(), ex);
        }
    }

    public static Integer stringToInteger(String val, Integer defaultVal) {
        if (val != null) {
            try {
                return Integer.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public static Boolean stringToBoolean(String val, Boolean defaultVal) {
        if (val == null || val.length() == 0) {
            return defaultVal;
        }
        try {
            val = val.trim();
            int bInt = Integer.parseInt(val);
            if (bInt <= 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (NumberFormatException bInt) {
            try {
                return Boolean.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                return defaultVal;
            }
        }
    }

    public static Object createObject(Class<?> cls, Class[] paramTypes, Object[] params) {
        Object obj;
        Constructor<?> constructor;
        try {
            constructor = cls.getConstructor(paramTypes);
        }
        catch (SecurityException e) {
            logger.error((Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            logger.error((Throwable)e);
            return null;
        }
        try {
            obj = constructor.newInstance(params);
        }
        catch (IllegalArgumentException e1) {
            logger.error((Throwable)e1);
            return null;
        }
        catch (InstantiationException e1) {
            logger.error((Throwable)e1);
            return null;
        }
        catch (IllegalAccessException e1) {
            logger.error((Throwable)e1);
            return null;
        }
        catch (InvocationTargetException e1) {
            logger.error((Throwable)e1);
            return null;
        }
        return obj;
    }

    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof String && obj2 instanceof String) {
            return ((String)obj1).trim().equals(((String)obj2).trim());
        }
        if (obj1 instanceof DynamicObject && obj2 instanceof DynamicObject) {
            return ((DynamicObject)obj1).getLong("id") == ((DynamicObject)obj2).getLong("id");
        }
        if (obj1 instanceof OrmLocaleValue && obj2 instanceof OrmLocaleValue) {
            if (obj1.toString() == null || obj2.toString() == null) {
                if (obj1.toString() == null && obj2.toString() == null) {
                    return true;
                }
                return obj1.toString() == null && "".equals(obj2.toString().trim()) || obj2.toString() == null && "".equals(obj1.toString().trim());
            }
            return obj1.toString().trim().equals(obj2.toString().trim());
        }
        return obj1.equals(obj2);
    }

    public static boolean equals(byte[] val1, byte[] val2) {
        if (val1.length != val2.length) {
            return false;
        }
        int len = val1.length;
        for (int i = 0; i < len; ++i) {
            if (val1[i] == val2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] val1, char[] val2) {
        if (val1.length != val2.length) {
            return false;
        }
        int len = val1.length;
        for (int i = 0; i < len; ++i) {
            if (val1[i] == val2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equalValues(Object[] objs1, Object[] objs2) {
        int jIndex;
        if (objs1 == objs2) {
            return true;
        }
        if (objs1 == null || objs2 == null) {
            return false;
        }
        if (objs1.length != objs2.length) {
            return false;
        }
        int len = objs1.length;
        boolean[] notEquals = new boolean[len];
        for (jIndex = 0; jIndex < len; ++jIndex) {
            notEquals[jIndex] = true;
        }
        for (int index = 0; index < len; ++index) {
            Object obj1 = objs1[index];
            for (jIndex = 0; jIndex < len; ++jIndex) {
                if (!notEquals[jIndex] || !obj1.equals(objs2[jIndex])) continue;
                notEquals[jIndex] = false;
                break;
            }
            if (jIndex != len) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToBytes(Object obj) throws IOException {
        byte[] result = null;
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        ObjectOutputStream os = null;
        try {
            os = new ObjectOutputStream(bo);
            os.writeObject(obj);
            result = bo.toByteArray();
        }
        finally {
            bo.close();
            if (os != null) {
                os.close();
            }
        }
        return result;
    }

    public static void transMapBean(Map<String, Object> map, Object obj) throws IntrospectionException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PropertyDescriptor[] propertyDescriptors;
        BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
        for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            String key = property.getName();
            Object value = map.get(key);
            if (value == null) continue;
            Method setter = property.getWriteMethod();
            setter.invoke(obj, value);
        }
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id") == 0L;
        }
        if (obj instanceof String) {
            return WTCStringUtils.isEmpty((String)((String)obj));
        }
        if (obj instanceof OrmLocaleValue) {
            return WTCStringUtils.isEmpty((String)((OrmLocaleValue)obj).getLocaleValue());
        }
        return false;
    }

    public static String getStringValue(Object obj, String field) {
        String result = "";
        Object propObj = null;
        if (obj instanceof IDataModel) {
            propObj = ((IDataModel)obj).getProperty(field);
            result = WTCObjectUtils.convertObjectToString(((IDataModel)obj).getValue(field));
        } else if (obj instanceof DynamicObject) {
            propObj = ((DynamicObject)obj).getDataEntityType().getProperties().get((Object)field);
            result = WTCObjectUtils.convertObjectToString(((DynamicObject)obj).get(field));
        }
        if (propObj instanceof AdminDivisionProp && !WTCStringUtils.isEmpty((String)result)) {
            StringBuilder adminDivisionBuilder = new StringBuilder();
            long adminDivisionId = Long.parseLong(result);
            QFilter filter = new QFilter("id", "=", (Object)adminDivisionId);
            DynamicObject admindivisionDy = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"fullname", (QFilter[])filter.toArray());
            String admindivisionFullName = admindivisionDy != null ? admindivisionDy.getString("fullname") : result;
            String[] admindivisionArray = admindivisionFullName.split("_");
            int length = admindivisionArray.length;
            for (int i = 0; i < length; ++i) {
                adminDivisionBuilder.append(admindivisionArray[i]).append('/');
            }
            String adminDivision = adminDivisionBuilder.toString();
            if (adminDivision.length() > 0) {
                adminDivision = adminDivision.substring(0, adminDivision.length() - 1);
            }
            return adminDivision;
        }
        if (propObj instanceof ComboProp) {
            List comboItems = ((ComboProp)propObj).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                if (!comboItem.getValue().equals(result)) continue;
                result = comboItem.getName().getLocaleValue();
                break;
            }
        }
        return result;
    }

    public static String convertObjectToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return obj.toString().trim();
        }
        if (obj instanceof DynamicObject) {
            DynamicObject dy = (DynamicObject)obj;
            if (dy.getString("name") != null) {
                return dy.getString("name");
            }
            if (dy.getString("number") != null) {
                return dy.getString("number");
            }
            if (dy.getLong("id") != 0L) {
                return String.valueOf(dy.getLong("id"));
            }
        }
        if (obj instanceof Boolean) {
            if (((Boolean)obj).booleanValue()) {
                return ResManager.loadKDString((String)"\u662f", (String)"WTCObjectUtils_0", (String)"wtc-wtbd-common", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u5426", (String)"WTCObjectUtils_1", (String)"wtc-wtbd-common", (Object[])new Object[0]);
        }
        if (obj instanceof Date) {
            return WTCDateTimeUtils.format((Date)obj, "yyyy-MM-dd");
        }
        return String.valueOf(obj);
    }
}

