/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.common.vo.retrieval;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalFieldInfo;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalFilterInfo;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalSortedInfo;

public class RetrievalConfigInfo
implements Serializable {
    private static final long serialVersionUID = 7745526426169480664L;
    private Long id;
    private String number;
    private String name;
    private String status;
    private String enable;
    private String groupType;
    private String fetchMode;
    private String outputMode;
    private String fetchSourceId;
    private List<RetrievalFieldInfo> fieldInfoList;
    private List<RetrievalFilterInfo> filterInfoList;
    private List<RetrievalSortedInfo> sortedInfoList;

    public RetrievalConfigInfo() {
    }

    public RetrievalConfigInfo(DynamicObject config) {
        this.id = config.getLong("id");
        this.number = config.getString("number");
        this.name = config.getString("name");
        this.status = config.getString("status");
        this.enable = config.getString("enable");
        this.groupType = config.getString("grouptype");
        this.fetchMode = config.getString("fetchmode");
        this.outputMode = config.getString("outputmode");
        this.fetchSourceId = config.getString("fetchsource.id");
        DynamicObjectCollection fetchFieldEntry = config.getDynamicObjectCollection("fetchfieldentry");
        DynamicObjectCollection relationEntry = config.getDynamicObjectCollection("relationentry");
        DynamicObjectCollection fetchSortEntry = config.getDynamicObjectCollection("fetchsortentry");
        ArrayList<RetrievalFieldInfo> fieldInfoList = new ArrayList<RetrievalFieldInfo>(fetchFieldEntry.size());
        ArrayList<RetrievalFilterInfo> filterInfoList = new ArrayList<RetrievalFilterInfo>(relationEntry.size());
        ArrayList<RetrievalSortedInfo> sortedInfoList = new ArrayList<RetrievalSortedInfo>(fetchSortEntry.size());
        fetchFieldEntry.forEach(dynamicObject -> {
            RetrievalFieldInfo retrievalFieldInfo = new RetrievalFieldInfo((DynamicObject)dynamicObject);
            fieldInfoList.add(retrievalFieldInfo);
        });
        relationEntry.forEach(dynamicObject -> {
            RetrievalFilterInfo retrievalFilterInfo = new RetrievalFilterInfo((DynamicObject)dynamicObject);
            filterInfoList.add(retrievalFilterInfo);
        });
        Collections.sort(filterInfoList, Comparator.comparing(RetrievalFilterInfo::getValueType));
        fetchSortEntry.forEach(dynamicObject -> {
            RetrievalSortedInfo retrievalSortedInfo = new RetrievalSortedInfo((DynamicObject)dynamicObject);
            sortedInfoList.add(retrievalSortedInfo);
        });
        this.fieldInfoList = fieldInfoList;
        this.filterInfoList = filterInfoList;
        this.sortedInfoList = sortedInfoList;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getEnable() {
        return this.enable;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }

    public String getGroupType() {
        return this.groupType;
    }

    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    public String getFetchMode() {
        return this.fetchMode;
    }

    public void setFetchMode(String fetchMode) {
        this.fetchMode = fetchMode;
    }

    public String getFetchSourceId() {
        return this.fetchSourceId;
    }

    public void setFetchSourceId(String fetchSourceId) {
        this.fetchSourceId = fetchSourceId;
    }

    public List<RetrievalFieldInfo> getFieldInfoList() {
        return this.fieldInfoList;
    }

    public void setFieldInfoList(List<RetrievalFieldInfo> fieldInfoList) {
        this.fieldInfoList = fieldInfoList;
    }

    public List<RetrievalFilterInfo> getFilterInfoList() {
        return this.filterInfoList;
    }

    public void setFilterInfoList(List<RetrievalFilterInfo> filterInfoList) {
        this.filterInfoList = filterInfoList;
    }

    public List<RetrievalSortedInfo> getSortedInfoList() {
        return this.sortedInfoList;
    }

    public void setSortedInfoList(List<RetrievalSortedInfo> sortedInfoList) {
        this.sortedInfoList = sortedInfoList;
    }

    public String getOutputMode() {
        return this.outputMode;
    }

    public void setOutputMode(String outputMode) {
        this.outputMode = outputMode;
    }
}

