/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.mservice.retrieval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.business.retrieval.DataReaderHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalConfigHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalItemHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalUtil;
import kd.wtc.wtbd.common.constants.scenecfg.SceneCfgKDString;
import kd.wtc.wtbd.common.enums.retrieval.ConditionFieldTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.FetchModeEnum;
import kd.wtc.wtbd.common.enums.retrieval.OutputModeEnum;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalBusinessModelFilterInfo;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalBusinessModelSortedInfo;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalBusinessModelVo;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalConfigInfo;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalFilterInfo;
import kd.wtc.wtbd.mservice.retrieval.IRetrievalBusinessModelService;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class RetrievalBusinessModelService
implements IRetrievalBusinessModelService {
    private static final Log LOGGER = LogFactory.getLog(RetrievalBusinessModelService.class);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[a-zA-Z0-9_]+$");
    private static final String LINK = "_";
    private static final String CONFIG_PRE = "DT_";
    private static final Long PRESET_RETRIEVAL_RULE_AE_1070_S = 1924809696967929856L;
    private static final Long PRESET_RETRIEVAL_RULE_QE_1080_S = 1945650358516723712L;
    private static final Long PRESET_RETRIEVAL_RULE_1090_S = 1991398471189410816L;
    private static final HRBaseServiceHelper RULE_HELPER = new HRBaseServiceHelper("wtbd_scenerulecfg");
    private static final HRBaseServiceHelper ITEM_HELPER = new HRBaseServiceHelper("wtbd_scenefieldcfg");
    private static final HRBaseServiceHelper CONFIG_HELPER = new HRBaseServiceHelper("wtbd_retrievalconfig");
    private static final HRBaseServiceHelper HBP_ENTITY_HELPER = new HRBaseServiceHelper("hbp_entityobject");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> addRetrievalBusinessModel(List<Map<String, Object>> maps) {
        if (!WTCGrayscaleUtils.isRetrievalOpen().booleanValue()) {
            return this.resultErrMap(SceneCfgKDString.grayscaleStatusIsClosed());
        }
        if (WTCCollections.isEmpty(maps)) {
            return this.resultErrMap(ResManager.loadKDString((String)"\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"RetrievalBusinessModelService_1", (String)"wtc-wtbd-mservice", (Object[])new Object[0]));
        }
        String jsonString = WTCSerializationUtils.toJsonString(maps);
        LOGGER.info("RetrievalBusinessModelService.addRetrievalBusinessModel\u5165\u53c2\uff1a{}", (Object)jsonString);
        List retrievalBusinessModelVoList = WTCSerializationUtils.fromJsonStringToList((String)jsonString, RetrievalBusinessModelVo.class);
        List categories = Stream.of("1").collect(Collectors.toList());
        HashSet<String> itemCodes = new HashSet<String>(maps.size());
        HashSet<String> itemNames = new HashSet<String>(maps.size());
        HashSet<String> fetchSources = new HashSet<String>(maps.size());
        HashSet<String> configCodes = new HashSet<String>(maps.size());
        HashSet<String> configNames = new HashSet<String>(maps.size());
        ArrayList<Long> itemParentIds = new ArrayList<Long>(maps.size());
        HashSet<Long> ruleIds = new HashSet<Long>(maps.size());
        MainEntityType mainEntity = RetrievalUtil.getDataEntityType((String)"wtbd_retrievalconfig");
        int numberLen = ((TextProp)mainEntity.getProperty("number")).getMaxLenth();
        int nameLen = ((MuliLangTextProp)mainEntity.getProperty("name")).getMaxLenth();
        for (RetrievalBusinessModelVo retrievalBusinessModelVo : retrievalBusinessModelVoList) {
            itemCodes.add(retrievalBusinessModelVo.getItemCode());
            LocaleString itemName = retrievalBusinessModelVo.getItemName();
            itemNames.add(itemName.getLocaleValue());
            fetchSources.add(retrievalBusinessModelVo.getFetchSource());
            retrievalBusinessModelVo.setConfigCode(CONFIG_PRE + retrievalBusinessModelVo.getItemCode());
            configCodes.add(CONFIG_PRE + retrievalBusinessModelVo.getItemCode());
            ruleIds.add(retrievalBusinessModelVo.getSceneRuleId());
            if (!itemParentIds.contains(retrievalBusinessModelVo.getItemParentId())) {
                itemParentIds.add(retrievalBusinessModelVo.getItemParentId());
            }
            if (this.validateParamCode(retrievalBusinessModelVo.getItemCode())) continue;
            return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u7f16\u7801{0}\u4e0d\u7b26\u5408\u89c4\u8303\u3002\u8bf7\u4ec5\u8f93\u5165\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3002", (String)"RetrievalBusinessModelService_2", (String)"wtc-wtbd-mservice", (Object[])new Object[]{retrievalBusinessModelVo.getItemCode()}));
        }
        if (itemCodes.size() != retrievalBusinessModelVoList.size()) {
            return this.resultErrMap(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e2d\u5b58\u5728\u53d6\u6570\u9879\u76ee\u7f16\u7801\u91cd\u590d\u3002", (String)"RetrievalBusinessModelService_3", (String)"wtc-wtbd-mservice", (Object[])new Object[0]));
        }
        if (itemNames.size() != retrievalBusinessModelVoList.size()) {
            return this.resultErrMap(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e2d\u5b58\u5728\u53d6\u6570\u9879\u76ee\u540d\u79f0\u91cd\u590d\u3002", (String)"RetrievalBusinessModelService_4", (String)"wtc-wtbd-mservice", (Object[])new Object[0]));
        }
        Map itemCodeMap = RetrievalItemHelper.checkCodeUnique(itemCodes);
        if (itemCodeMap.size() > 0) {
            Set codeKeys = itemCodeMap.keySet();
            return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u7f16\u7801{0}\u5728\u9879\u76ee\u5206\u7ec4\u6216\u53d6\u6570\u9879\u76ee\u4e2d\u5df2\u5b58\u5728\u3002", (String)"RetrievalBusinessModelService_5", (String)"wtc-wtbd-mservice", (Object[])new Object[]{codeKeys.toString()}));
        }
        Map itemNameMap = RetrievalItemHelper.checkNameUnique((List)Lists.newArrayList(itemNames), categories);
        if (itemNameMap.size() > 0) {
            Set nameKeys = itemNameMap.keySet();
            return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u540d\u79f0{0}\u5728\u53d6\u6570\u9879\u76ee\u4e2d\u5df2\u5b58\u5728\u3002", (String)"RetrievalBusinessModelService_6", (String)"wtc-wtbd-mservice", (Object[])new Object[]{nameKeys.toString()}));
        }
        DynamicObject[] fetchSourceCollection = HBP_ENTITY_HELPER.query("number,name", new QFilter[]{new QFilter("number", "in", fetchSources)});
        List fetchSourceList = Arrays.stream(fetchSourceCollection).collect(Collectors.toList());
        Map<String, ILocaleString> fetchSourceNumberNameMap = fetchSourceList.stream().collect(Collectors.toMap(key -> key.getString("number"), value -> value.getLocaleString("name"), (oldValue, newValue) -> newValue));
        HashSet cloneFetchSources = new HashSet(fetchSources);
        Set<String> existFetchSources = fetchSourceNumberNameMap.keySet();
        cloneFetchSources.removeAll(existFetchSources);
        if (WTCCollections.isNotEmpty(cloneFetchSources)) {
            return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u5b9e\u4f53{0}\u4e0d\u5b58\u5728\u3002", (String)"RetrievalBusinessModelService_7", (String)"wtc-wtbd-mservice", (Object[])new Object[]{((Object)cloneFetchSources).toString()}));
        }
        HashMap<String, ILocaleString> configCodeNameMap = new HashMap<String, ILocaleString>(fetchSources.size());
        this.setConfigName(retrievalBusinessModelVoList, fetchSourceNumberNameMap, configNames, configCodeNameMap);
        DynamicObjectCollection configCodeCollection = CONFIG_HELPER.queryOriginalCollection("id,number,name", new QFilter[]{new QFilter("number", "in", configCodes)});
        Map<String, DynamicObject> configCodeDyMap = configCodeCollection.stream().collect(Collectors.toMap(key -> key.getString("number"), value -> value, (oldValue, newValue) -> newValue));
        DynamicObjectCollection configNameCollection = CONFIG_HELPER.queryOriginalCollection("id,number,name", new QFilter[]{new QFilter("name", "in", configNames)});
        Map<String, DynamicObject> configNameDyMap = configNameCollection.stream().collect(Collectors.toMap(key -> key.getString("name"), value -> value, (oldValue, newValue) -> newValue));
        DynamicObject[] fetchSourceExistObjects = CONFIG_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("fetchsource.id", "in", fetchSources).and(new QFilter("issyspreset", "=", (Object)Boolean.FALSE))});
        Map<String, List<DynamicObject>> configUniqueKeyMap = this.configUniqueKeyMap(fetchSourceExistObjects);
        DynamicObject[] itemParentObjects = RetrievalConfigHelper.selectRetrievalItemList(itemParentIds);
        List itemParentObjectList = Arrays.stream(itemParentObjects).collect(Collectors.toList());
        Map<Long, DynamicObject> itemParentIdDyMap = itemParentObjectList.stream().collect(Collectors.toMap(key -> key.getLong("id"), value -> value, (oldValue, newValue) -> newValue));
        DynamicObject[] ruleObjects = RULE_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", ruleIds)});
        List ruleObjectList = Arrays.stream(ruleObjects).collect(Collectors.toList());
        Map<Long, DynamicObject> ruleIdDyMap = ruleObjectList.stream().collect(Collectors.toMap(key -> key.getLong("id"), value -> value, (oldValue, newValue) -> newValue));
        DynamicObjectCollection itemCollection = new DynamicObjectCollection();
        DynamicObjectCollection itemParentCollection = new DynamicObjectCollection();
        DynamicObjectCollection configCollection = new DynamicObjectCollection();
        HashMap<String, Map> fetchSourceMap = new HashMap<String, Map>(retrievalBusinessModelVoList.size());
        long[] itemIds = ORM.create().genLongIds("wtbd_scenefieldcfg", retrievalBusinessModelVoList.size());
        long[] configIds = ORM.create().genLongIds("wtbd_retrievalconfig", retrievalBusinessModelVoList.size());
        for (int i = 0; i < retrievalBusinessModelVoList.size(); ++i) {
            Map propertyMap;
            RetrievalBusinessModelVo retrievalBusinessModelVo = (RetrievalBusinessModelVo)retrievalBusinessModelVoList.get(i);
            String itemName = retrievalBusinessModelVo.getItemName().getLocaleValue();
            long itemId = itemIds[i];
            long configId = configIds[i];
            retrievalBusinessModelVo.setItemId(itemId);
            retrievalBusinessModelVo.setConfigId(configId);
            DynamicObject ruleObject = ruleIdDyMap.get(retrievalBusinessModelVo.getSceneRuleId());
            if (ruleObject == null) {
                return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee[{0}]\uff1a\u53d6\u6570\u5e94\u7528\u573a\u666f[{1}]\u4e0d\u5b58\u5728\u3002", (String)"RetrievalBusinessModelService_8", (String)"wtc-wtbd-mservice", (Object[])new Object[]{itemName, retrievalBusinessModelVo.getSceneRuleId()}));
            }
            DynamicObjectCollection ruleEntries = ruleObject.getDynamicObjectCollection("entryentity");
            Set<String> existItemNameList = this.getExistItemNameList(ruleEntries);
            if (WTCCollections.isNotEmpty(existItemNameList) && existItemNameList.contains(retrievalBusinessModelVo.getItemName().getLocaleValue())) {
                return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee[{0}]\uff1a\u53d6\u6570\u5e94\u7528\u573a\u666f[{1}]\u4e0b\u7684\u53d6\u6570\u9879\u76ee\u540d\u79f0\u91cd\u590d\u3002", (String)"RetrievalBusinessModelService_10", (String)"wtc-wtbd-mservice", (Object[])new Object[]{itemName, ruleObject.getString("name")}));
            }
            DynamicObject existGroup = ruleEntries.stream().filter(item -> this.filterGroup((DynamicObject)item, retrievalBusinessModelVo.getItemParentId())).findFirst().orElse(null);
            DynamicObject itemParentDy = itemParentIdDyMap.get(retrievalBusinessModelVo.getItemParentId());
            if (itemParentDy == null) {
                return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee[{0}]\uff1a\u9879\u76ee\u5206\u7ec4[{1}]\u4e0d\u5b58\u5728\u3002", (String)"RetrievalBusinessModelService_9", (String)"wtc-wtbd-mservice", (Object[])new Object[]{itemName, retrievalBusinessModelVo.getItemParentId()}));
            }
            String groupType = itemParentDy.getString("grouptype");
            if (!WTCStringUtils.equals((String)groupType, (String)ruleObject.getString("grouptype"))) {
                return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee[{0}]\uff1a\u9879\u76ee\u5206\u7ec4[{1}]\u7684\u7c7b\u522b\u548c\u53d6\u6570\u5e94\u7528\u573a\u666f[{2}]\u7684\u53d6\u6570\u7c7b\u522b\u4e0d\u4e00\u81f4\u3002", (String)"RetrievalBusinessModelService_19", (String)"wtc-wtbd-mservice", (Object[])new Object[]{itemName, itemParentDy.getString("name"), ruleObject.getString("name")}));
            }
            if (existGroup == null) {
                DynamicObject entryDynamicObject = ruleEntries.addNew();
                entryDynamicObject.set("inputnumber", (Object)itemParentDy.getString("numberx"));
                entryDynamicObject.set("inputname", itemParentDy.get("name"));
                entryDynamicObject.set("inputobject", (Object)retrievalBusinessModelVo.getItemParentId());
                entryDynamicObject.set("inputparamstype", (Object)"dynamicObject");
                DynamicObjectCollection ruleSubEntries = entryDynamicObject.getDynamicObjectCollection("subentryentity");
                DynamicObject subEntryDynamicObject = ruleSubEntries.addNew();
                subEntryDynamicObject.set("fieldid", (Object)itemId);
            } else {
                DynamicObjectCollection ruleSubEntries = existGroup.getDynamicObjectCollection("subentryentity");
                DynamicObject subEntryDynamicObject = ruleSubEntries.addNew();
                subEntryDynamicObject.set("fieldid", (Object)itemId);
            }
            if (!fetchSourceMap.containsKey(retrievalBusinessModelVo.getFetchSource())) {
                try {
                    propertyMap = this.getPropertyMap(retrievalBusinessModelVo.getFetchSource());
                    Map propertyClassMap = (Map)propertyMap.get("codeMap");
                    if (propertyClassMap == null) {
                        return this.resultErrMap(ResManager.loadKDString((String)"\u5143\u6570\u636e[{0}]\u6ca1\u6709\u53ef\u9009\u5b57\u6bb5\u3002", (String)"RetrievalBusinessModelService_11", (String)"wtc-wtbd-mservice", (Object[])new Object[]{retrievalBusinessModelVo.getFetchSource()}));
                    }
                    fetchSourceMap.put(retrievalBusinessModelVo.getFetchSource(), propertyMap);
                }
                catch (KDBizException kdBizException) {
                    return this.resultErrMap(kdBizException.getMessage());
                }
            }
            propertyMap = (Map)fetchSourceMap.get(retrievalBusinessModelVo.getFetchSource());
            this.validateBaseDataProp(propertyMap, retrievalBusinessModelVo);
            if (this.validateField(propertyMap, retrievalBusinessModelVo.getFieldId())) {
                return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee[{0}]\uff1a\u5143\u6570\u636e[{1}]\u5b57\u6bb5[{2}]\u4e0d\u5b58\u5728\u3002", (String)"RetrievalBusinessModelService_12", (String)"wtc-wtbd-mservice", (Object[])new Object[]{itemName, retrievalBusinessModelVo.getFetchSource(), retrievalBusinessModelVo.getFieldId()}));
            }
            String dataType = this.getFieldType(propertyMap, retrievalBusinessModelVo.getFieldId(), "fetchfieldentry");
            retrievalBusinessModelVo.setDataType(dataType);
            retrievalBusinessModelVo.setType(this.getType(propertyMap, retrievalBusinessModelVo.getFieldId()));
            for (RetrievalBusinessModelFilterInfo filterInfo : retrievalBusinessModelVo.getRetrievalBusinessModelFilterInfoList()) {
                if (this.validateField(propertyMap, filterInfo.getFieldId())) {
                    return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee[{0}]\uff1a\u5143\u6570\u636e[{1}]\u5b57\u6bb5[{2}]\u4e0d\u5b58\u5728\u3002", (String)"RetrievalBusinessModelService_12", (String)"wtc-wtbd-mservice", (Object[])new Object[]{itemName, retrievalBusinessModelVo.getFetchSource(), filterInfo.getFieldId()}));
                }
                filterInfo.setDataType(this.getFieldType(propertyMap, filterInfo.getFieldId(), "relationentry"));
            }
            for (RetrievalBusinessModelSortedInfo sortedInfo : retrievalBusinessModelVo.getRetrievalBusinessModelSortedInfoList()) {
                if (!this.validateField(propertyMap, sortedInfo.getFieldId())) continue;
                return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee[{0}]\uff1a\u5143\u6570\u636e[{1}]\u5b57\u6bb5[{2}]\u4e0d\u5b58\u5728\u3002", (String)"RetrievalBusinessModelService_12", (String)"wtc-wtbd-mservice", (Object[])new Object[]{itemName, retrievalBusinessModelVo.getFetchSource(), sortedInfo.getFieldId()}));
            }
            DynamicObject itemDynamicObject = this.genItemDynamicObject(retrievalBusinessModelVo, itemParentDy, itemParentCollection);
            String retrievalBusinessModelVoKey = this.genRetrievalBusinessModelVoKey(retrievalBusinessModelVo, groupType);
            DynamicObject existDynamicObject = this.validateConfigExist(configUniqueKeyMap, retrievalBusinessModelVoKey, retrievalBusinessModelVo);
            if (existDynamicObject != null) {
                DynamicObject config = existDynamicObject;
                DynamicObjectCollection fieldCollection = config.getDynamicObjectCollection("fetchfieldentry");
                itemDynamicObject.set("config", (Object)config.getLong("id"));
                DynamicObject fieldDynamicObject = fieldCollection.addNew();
                fieldDynamicObject.set("field", (Object)retrievalBusinessModelVo.getFieldId());
                fieldDynamicObject.set("datatype", (Object)retrievalBusinessModelVo.getDataType());
                fieldDynamicObject.set("fetchitem", (Object)retrievalBusinessModelVo.getItemId());
                if (!configCollection.contains((Object)config)) {
                    configCollection.add((Object)config);
                }
            } else {
                if (configCodeDyMap.containsKey(retrievalBusinessModelVo.getConfigCode())) {
                    return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee[{0}]\uff1a\u751f\u6210\u7684\u53d6\u6570\u914d\u7f6e\u7f16\u7801[{1}]\u5df2\u5b58\u5728\u3002", (String)"RetrievalBusinessModelService_14", (String)"wtc-wtbd-mservice", (Object[])new Object[]{itemName, retrievalBusinessModelVo.getConfigCode()}));
                }
                if (configNameDyMap.containsKey(((ILocaleString)configCodeNameMap.get(retrievalBusinessModelVo.getConfigCode())).getLocaleValue())) {
                    return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee[{0}]\uff1a\u751f\u6210\u7684\u53d6\u6570\u914d\u7f6e\u540d\u79f0[{1}]\u5df2\u5b58\u5728\u3002", (String)"RetrievalBusinessModelService_15", (String)"wtc-wtbd-mservice", (Object[])new Object[]{itemName, ((ILocaleString)configCodeNameMap.get(retrievalBusinessModelVo.getConfigCode())).getLocaleValue()}));
                }
                if (retrievalBusinessModelVo.getConfigCode().length() > numberLen) {
                    return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee[{0}]\uff1a\u751f\u6210\u7684\u53d6\u6570\u914d\u7f6e\u7f16\u7801[{1}]\u957f\u5ea6\u8d85\u8fc7{2}\u3002", (String)"RetrievalBusinessModelService_16", (String)"wtc-wtbd-mservice", (Object[])new Object[]{itemName, retrievalBusinessModelVo.getConfigCode(), numberLen}));
                }
                if (configCodeNameMap.get(retrievalBusinessModelVo.getConfigCode()) != null) {
                    ILocaleString iLocaleString = (ILocaleString)configCodeNameMap.get(retrievalBusinessModelVo.getConfigCode());
                    for (String key2 : iLocaleString.keySet()) {
                        if (((String)iLocaleString.get((Object)key2)).length() <= nameLen) continue;
                        return this.resultErrMap(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee[{0}]\uff1a\u751f\u6210\u7684\u53d6\u6570\u914d\u7f6e\u540d\u79f0[{1}]\u957f\u5ea6\u8d85\u8fc7{2}\u3002", (String)"RetrievalBusinessModelService_17", (String)"wtc-wtbd-mservice", (Object[])new Object[]{itemName, ((ILocaleString)configCodeNameMap.get(retrievalBusinessModelVo.getConfigCode())).get((Object)key2), nameLen}));
                    }
                }
                DynamicObject configDynamicObject = this.genConfigDynamicObject(retrievalBusinessModelVo, configCodeNameMap, groupType);
                this.putUniqueKeyMap(configUniqueKeyMap, retrievalBusinessModelVoKey, configDynamicObject);
                configCollection.add((Object)configDynamicObject);
            }
            itemCollection.add((Object)itemDynamicObject);
        }
        try (TXHandle txHandle = TX.required();){
            ITEM_HELPER.save(itemCollection);
            RULE_HELPER.save(ruleObjects);
            CONFIG_HELPER.save(configCollection);
            if (!itemParentCollection.isEmpty()) {
                ITEM_HELPER.save(itemParentCollection);
            }
        }
        return this.resultSuccessMap();
    }

    private void validateBaseDataProp(Map<String, Map<String, String>> propertyMap, RetrievalBusinessModelVo retrievalBusinessModelVo) {
        String fieldId = retrievalBusinessModelVo.getFieldId();
        if (this.validateField(propertyMap, fieldId) && fieldId.endsWith(".id") && !this.validateField(propertyMap, fieldId = fieldId.substring(0, fieldId.length() - 3))) {
            retrievalBusinessModelVo.setFieldId(fieldId);
        }
    }

    private DynamicObject validateConfigExist(Map<String, List<DynamicObject>> configUniqueKeyMap, String retrievalBusinessModelVoKey, RetrievalBusinessModelVo retrievalBusinessModelVo) {
        if (configUniqueKeyMap.containsKey(retrievalBusinessModelVoKey)) {
            List<DynamicObject> configs = configUniqueKeyMap.get(retrievalBusinessModelVoKey);
            for (DynamicObject config : configs) {
                DynamicObjectCollection fieldCollection = config.getDynamicObjectCollection("fetchfieldentry");
                boolean present = fieldCollection.stream().anyMatch(res -> WTCStringUtils.equals((String)retrievalBusinessModelVo.getFieldId(), (String)res.getString("field")));
                if (present) continue;
                return config;
            }
        }
        return null;
    }

    private Set<String> getExistItemNameList(DynamicObjectCollection ruleEntries) {
        HashSet<String> existItemNameList = new HashSet<String>();
        for (DynamicObject group : ruleEntries) {
            DynamicObjectCollection ruleSubEntries = group.getDynamicObjectCollection("subentryentity");
            Set existItemNameListOne = ruleSubEntries.stream().map(item -> {
                if (WTCStringUtils.isNotEmpty((String)item.getString("fielddisplayname"))) {
                    return item.getString("fielddisplayname");
                }
                return item.getString("fieldid.name");
            }).collect(Collectors.toSet());
            existItemNameList.addAll(existItemNameListOne);
        }
        return existItemNameList;
    }

    private boolean filterGroup(DynamicObject item, long itemParentId) {
        if (item.get("inputobject") instanceof DynamicObject) {
            return item.getLong("inputobject.id") == itemParentId;
        }
        return item.getLong("inputobject") == itemParentId;
    }

    void setConfigName(List<RetrievalBusinessModelVo> retrievalBusinessModelVoList, Map<String, ILocaleString> fetchSourceNumberNameMap, Set<String> configNames, Map<String, ILocaleString> configCodeNameMap) {
        for (RetrievalBusinessModelVo retrievalBusinessModelVo : retrievalBusinessModelVoList) {
            ILocaleString fetchSourceName = fetchSourceNumberNameMap.get(retrievalBusinessModelVo.getFetchSource());
            if (fetchSourceName == null) continue;
            LocaleString itemName = retrievalBusinessModelVo.getItemName();
            LocaleString configName = new LocaleString();
            itemName.keySet().forEach(arg_0 -> RetrievalBusinessModelService.lambda$setConfigName$18((ILocaleString)configName, (ILocaleString)itemName, fetchSourceName, arg_0));
            configNames.add(configName.getLocaleValue());
            configCodeNameMap.put(retrievalBusinessModelVo.getConfigCode(), (ILocaleString)configName);
        }
    }

    private String genRetrievalBusinessModelVoKey(RetrievalBusinessModelVo retrievalBusinessModelVo, String groupType) {
        retrievalBusinessModelVo.getRetrievalBusinessModelFilterInfoList().sort(Comparator.comparing(RetrievalBusinessModelFilterInfo::getFieldId).thenComparing(RetrievalBusinessModelFilterInfo::getCondition).thenComparing(RetrievalBusinessModelFilterInfo::getValue));
        String filedKey = retrievalBusinessModelVo.getRetrievalBusinessModelFilterInfoList().stream().map(item -> item.getFieldId() + LINK + item.getDataType() + LINK + item.getCondition() + LINK + item.getValueType() + LINK + item.getValue()).collect(Collectors.joining(LINK));
        String sortKey = retrievalBusinessModelVo.getRetrievalBusinessModelSortedInfoList().stream().map(item -> item.getFieldId() + LINK + item.getSortType()).collect(Collectors.joining(LINK));
        return groupType + LINK + retrievalBusinessModelVo.getFetchSource() + LINK + filedKey + LINK + sortKey;
    }

    Map<String, List<DynamicObject>> configUniqueKeyMap(DynamicObject[] fetchSourceExistObjects) {
        HashMap<String, List<DynamicObject>> uniqueKeyMap = new HashMap<String, List<DynamicObject>>(fetchSourceExistObjects.length);
        for (DynamicObject fetchSourceExistObject : fetchSourceExistObjects) {
            RetrievalConfigInfo config = new RetrievalConfigInfo(fetchSourceExistObject);
            config.getFilterInfoList().sort(Comparator.comparing(RetrievalFilterInfo::getFieldId).thenComparing(RetrievalFilterInfo::getCondition).thenComparing(RetrievalFilterInfo::getValue));
            String filedKey = config.getFilterInfoList().stream().map(item -> item.getFieldId() + LINK + item.getDataType() + LINK + item.getCondition() + LINK + item.getValueType() + LINK + item.getValue()).collect(Collectors.joining(LINK));
            String sortKey = config.getSortedInfoList().stream().map(item -> item.getFieldId() + LINK + item.getSortType()).collect(Collectors.joining(LINK));
            String key = config.getGroupType() + LINK + config.getFetchSourceId() + LINK + filedKey + LINK + sortKey;
            this.putUniqueKeyMap(uniqueKeyMap, key, fetchSourceExistObject);
        }
        return uniqueKeyMap;
    }

    private void putUniqueKeyMap(Map<String, List<DynamicObject>> uniqueKeyMap, String key, DynamicObject fetchSourceExistObject) {
        if (uniqueKeyMap == null) {
            return;
        }
        if (uniqueKeyMap.containsKey(key)) {
            List<DynamicObject> dynamicObjects = uniqueKeyMap.get(key);
            dynamicObjects.add(fetchSourceExistObject);
        } else {
            ArrayList dynamicObjects = Lists.newArrayList((Object[])new DynamicObject[]{fetchSourceExistObject});
            uniqueKeyMap.put(key, dynamicObjects);
        }
    }

    private DynamicObject genConfigDynamicObject(RetrievalBusinessModelVo retrievalBusinessModelVo, Map<String, ILocaleString> configCodeNameMap, String groupType) {
        DynamicObject config = BusinessDataServiceHelper.newDynamicObject((String)"wtbd_retrievalconfig");
        config.set("id", (Object)retrievalBusinessModelVo.getConfigId());
        config.set("number", (Object)retrievalBusinessModelVo.getConfigCode());
        config.set("name", (Object)configCodeNameMap.get(retrievalBusinessModelVo.getConfigCode()));
        config.set("status", (Object)"C");
        config.set("enable", (Object)"1");
        config.set("fetchsource", (Object)retrievalBusinessModelVo.getFetchSource());
        config.set("grouptype", (Object)groupType);
        config.set("outputmode", (Object)OutputModeEnum.ONE.getCode());
        config.set("fetchmode", (Object)FetchModeEnum.DATABASE.getCode());
        DynamicObjectCollection fieldEntries = config.getDynamicObjectCollection("fetchfieldentry");
        DynamicObject fieldEntry = fieldEntries.addNew();
        fieldEntry.set("field", (Object)retrievalBusinessModelVo.getFieldId());
        fieldEntry.set("datatype", (Object)retrievalBusinessModelVo.getDataType());
        fieldEntry.set("fetchitem", (Object)retrievalBusinessModelVo.getItemId());
        if (WTCCollections.isNotEmpty((Collection)retrievalBusinessModelVo.getRetrievalBusinessModelFilterInfoList())) {
            DynamicObjectCollection filterEntries = config.getDynamicObjectCollection("relationentry");
            for (RetrievalBusinessModelFilterInfo filterInfo : retrievalBusinessModelVo.getRetrievalBusinessModelFilterInfoList()) {
                DynamicObject filterEntry = filterEntries.addNew();
                filterEntry.set("filterfield", (Object)filterInfo.getFieldId());
                filterEntry.set("filterdatatype", (Object)filterInfo.getDataType());
                filterEntry.set("condition", (Object)filterInfo.getCondition());
                filterEntry.set("valuetype", (Object)filterInfo.getValueType());
                filterEntry.set("comparevalue", (Object)filterInfo.getValue());
            }
        }
        if (WTCCollections.isNotEmpty((Collection)retrievalBusinessModelVo.getRetrievalBusinessModelSortedInfoList())) {
            DynamicObjectCollection sortEntries = config.getDynamicObjectCollection("fetchsortentry");
            for (RetrievalBusinessModelSortedInfo sortInfo : retrievalBusinessModelVo.getRetrievalBusinessModelSortedInfoList()) {
                DynamicObject sortEntry = sortEntries.addNew();
                sortEntry.set("sortfield", (Object)sortInfo.getFieldId());
                sortEntry.set("sorttype", (Object)sortInfo.getSortType());
            }
        }
        return config;
    }

    private String getFieldType(Map<String, Map<String, String>> propertyMap, String fieldId, String entryType) {
        String fieldType = this.getFieldType(propertyMap, fieldId);
        fieldType = RetrievalConfigHelper.getSwitchDataType((String)fieldType, (String)entryType);
        return fieldType;
    }

    private String getFieldType(Map<String, Map<String, String>> propertyMap, String fieldId) {
        Map<String, String> propertyClassMap = propertyMap.get("codeMap");
        if (fieldId.endsWith(".id")) {
            fieldId = fieldId.substring(0, fieldId.length() - 3);
        }
        String fieldType = propertyClassMap.get(fieldId);
        return fieldType;
    }

    private String getType(Map<String, Map<String, String>> propertyMap, String fieldId) {
        String fieldType = this.getFieldType(propertyMap, fieldId);
        if (WTCStringUtils.equals((String)fieldType, (String)ConditionFieldTypeEnum.TYPE_ENUM.getCode())) {
            return "enum";
        }
        if (WTCStringUtils.equals((String)fieldType, (String)ConditionFieldTypeEnum.TYPE_BOOLEAN.getCode())) {
            return "boolean";
        }
        if (WTCStringUtils.equals((String)fieldType, (String)ConditionFieldTypeEnum.TYPE_DATE.getCode())) {
            return "date";
        }
        if (WTCStringUtils.equals((String)fieldType, (String)ConditionFieldTypeEnum.TYPE_NUM.getCode())) {
            return "number";
        }
        if (WTCStringUtils.equals((String)fieldType, (String)ConditionFieldTypeEnum.TYPE_ID.getCode())) {
            return "dynamicObject";
        }
        return "string";
    }

    private boolean validateField(Map<String, Map<String, String>> propertyMap, String fieldId) {
        Map<String, String> propertyClassMap = propertyMap.get("codeMap");
        return !propertyClassMap.containsKey(fieldId);
    }

    Map<String, Map<String, String>> getPropertyMap(String fetchSourceId) {
        MainEntityType mainEntity = RetrievalUtil.getDataEntityType((String)fetchSourceId);
        if (mainEntity instanceof QueryEntityType) {
            mainEntity = RetrievalUtil.getDataEntityType((String)((QueryEntityType)mainEntity).getEntityName());
        }
        return DataReaderHelper.getPropertyClassMap((Map)mainEntity.getAllEntities());
    }

    DynamicObject genItemDynamicObject(RetrievalBusinessModelVo retrievalBusinessModelVo, DynamicObject itemParentDy, DynamicObjectCollection itemParentCollection) {
        String uniqueCode;
        DynamicObject itemDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"wtbd_scenefieldcfg");
        long itemId = retrievalBusinessModelVo.getItemId();
        String itemCode = retrievalBusinessModelVo.getItemCode();
        itemDynamicObject.set("id", (Object)itemId);
        itemDynamicObject.set("masterid", (Object)itemId);
        itemDynamicObject.set("numberx", (Object)itemCode);
        itemDynamicObject.set("number", (Object)itemCode);
        itemDynamicObject.set("name", (Object)retrievalBusinessModelVo.getItemName());
        itemDynamicObject.set("parent", (Object)retrievalBusinessModelVo.getItemParentId());
        itemDynamicObject.set("way", (Object)"1");
        itemDynamicObject.set("assigntype", (Object)"1");
        itemDynamicObject.set("type", (Object)retrievalBusinessModelVo.getType());
        if (WTCStringUtils.equals((String)retrievalBusinessModelVo.getType(), (String)"number")) {
            itemDynamicObject.set("scale", (Object)(WTCStringUtils.isEmpty((String)retrievalBusinessModelVo.getScale()) ? "2" : retrievalBusinessModelVo.getScale()));
            itemDynamicObject.set("tailprocessing", (Object)(WTCStringUtils.isEmpty((String)retrievalBusinessModelVo.getTailProcessing()) ? "1" : retrievalBusinessModelVo.getTailProcessing()));
        }
        itemDynamicObject.set("config", (Object)retrievalBusinessModelVo.getConfigId());
        String groupType = itemParentDy.getString("grouptype");
        if (WTCStringUtils.equals((String)groupType, (String)"1")) {
            uniqueCode = String.join((CharSequence)"$", "CT$A$A", itemParentDy.getString("numberx"), itemCode);
            String fieldId = retrievalBusinessModelVo.getFieldId();
            if (fieldId.endsWith(".id")) {
                fieldId = fieldId.substring(0, fieldId.length() - 3);
            }
            itemDynamicObject.set("number", (Object)fieldId);
            itemDynamicObject.set("belongobj", (Object)retrievalBusinessModelVo.getFetchSource());
        } else {
            uniqueCode = HRStringUtils.equals((String)groupType, (String)"2") ? String.join((CharSequence)"$", "FM$A$A", itemParentDy.getString("numberx"), itemCode) : String.join((CharSequence)"$", itemParentDy.getString("numberx"), itemCode);
        }
        itemDynamicObject.set("uniquecode", (Object)uniqueCode);
        itemDynamicObject.set("isleaf", (Object)true);
        if (itemParentDy.getBoolean("isleaf")) {
            itemParentDy.set("isleaf", (Object)false);
            itemParentCollection.add((Object)itemParentDy);
        }
        itemDynamicObject.set("category", (Object)"1");
        itemDynamicObject.set("status", (Object)"C");
        itemDynamicObject.set("enable", (Object)"1");
        itemDynamicObject.set("level", (Object)(itemParentDy.getLong("level") + 1L));
        itemDynamicObject.set("longnumber", (Object)(itemParentDy.getString("longnumber") + '.' + itemCode));
        itemDynamicObject.set("fullname", (Object)(itemParentDy.getString("fullname") + '.' + itemCode));
        return itemDynamicObject;
    }

    Map<String, Object> resultErrMap(String msg) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("status", 0);
        map.put("msg", msg);
        return map;
    }

    Map<String, Object> resultSuccessMap() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("status", 1);
        return map;
    }

    private boolean validateParamCode(String number) {
        Matcher matcher = NUMBER_PATTERN.matcher(number);
        return matcher.matches();
    }

    public List<Map<String, Object>> queryRetrievalGroup() {
        ArrayList<Map<String, Object>> retrievalGroups = new ArrayList<Map<String, Object>>(16);
        QFilter qFilter = new QFilter("category", "in", Stream.of("2", "3").collect(Collectors.toList()));
        qFilter.and(new QFilter("issyspreset", "=", (Object)Boolean.FALSE));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection dynamicObjects = ITEM_HELPER.queryOriginalCollection("id,name,numberx", qFilter.toArray());
        for (DynamicObject item : dynamicObjects) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("id", item.getLong("id"));
            map.put("number", item.getString("numberx"));
            map.put("name", item.getString("name"));
            retrievalGroups.add(map);
        }
        return retrievalGroups;
    }

    public boolean validateItemExist(String numberx) {
        if (WTCStringUtils.isEmpty((String)numberx)) {
            return false;
        }
        HashSet<String> itemCodes = new HashSet<String>(1);
        itemCodes.add(numberx);
        Map itemCodeMap = RetrievalItemHelper.checkCodeUnique(itemCodes);
        return itemCodeMap.size() > 0;
    }

    public List<Map<String, Object>> queryRetrievalRule() {
        ArrayList<Map<String, Object>> retrievalRules = new ArrayList<Map<String, Object>>(16);
        QFilter qFilter = new QFilter("id", "in", Stream.of(PRESET_RETRIEVAL_RULE_AE_1070_S, PRESET_RETRIEVAL_RULE_QE_1080_S, PRESET_RETRIEVAL_RULE_1090_S).collect(Collectors.toList()));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection dynamicObjects = RULE_HELPER.queryOriginalCollection("id,name,number", qFilter.toArray());
        for (DynamicObject item : dynamicObjects) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("id", item.getLong("id"));
            map.put("number", item.getString("number"));
            map.put("name", item.getString("name"));
            retrievalRules.add(map);
        }
        return retrievalRules;
    }

    public Map<String, Object> queryRetrievalGrayscaleStatus() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("grayscaleStatus", WTCGrayscaleUtils.isRetrievalOpen());
        return map;
    }

    private static /* synthetic */ void lambda$setConfigName$18(ILocaleString configName, ILocaleString itemName, ILocaleString fetchSourceName, String key) {
        if (WTCStringUtils.equals((String)key, (String)"GLang")) {
            configName.setItem(key, (Object)((String)itemName.get((Object)key) + LINK + fetchSourceName.getLocaleValue()));
        } else {
            configName.setItem(key, (Object)((String)itemName.get((Object)key) + LINK + (String)fetchSourceName.get((Object)key)));
        }
    }
}

