/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.mservice.upgrade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.upgrade.WTCUpgradeService;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class SceneRuleDynPropMulLangUpgrade
extends WTCUpgradeService {
    private ArrayList<Long> longIds = new ArrayList(16);
    private ArrayList<String> strIds = new ArrayList(16);
    private static final String FLOCALEID_ZH_CN = "zh_CN";
    private static final String QUERY_SCENERULEPARAM_SQL = "select fid,fentryid ,fdynprop from t_wtbd_sceneruleparam;";
    private static final String QUERY_SECENERULEPARAMFIELD_SQL = "select fentryid,fdetailid from t_wtbd_scenerulefield;";
    private static final String INSERT_SENCERULEPARAMFIELD_SQL = "INSERT INTO t_wtbd_scenerulefield(fentryid, fdetailid, fseq, ffieldnumber, fdisplayname, ffieldtype, ffieldname) VALUES (?, ?, ?, ?, ?, ?, ?);";
    private static final String INSERT_SCENERULEPARAMFIELD_SQL_L = "INSERT INTO t_wtbd_scenerulefield_l(fpkid, fdetailid, flocaleid, fdisplayname) VALUES (?, ?, ?, ?);";

    public void upgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        Map<String, String> sceneRuleParamMap = this.getSceneRuleParamMap(dbRoute);
        List<String> sceneParamIds = this.getProcessedSceneRuleParamIds(dbRoute);
        ArrayList<Object[]> insertFieldParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insertFieldParamsL = new ArrayList<Object[]>(16);
        this.initInsertFieldParams(sceneRuleParamMap, sceneParamIds, insertFieldParams, insertFieldParamsL);
        if (WTCCollections.isNotEmpty(insertFieldParams)) {
            HRDBUtil.executeBatch((DBRoute)dbRoute, (String)INSERT_SENCERULEPARAMFIELD_SQL, insertFieldParams);
        }
        if (WTCCollections.isNotEmpty(insertFieldParamsL)) {
            HRDBUtil.executeBatch((DBRoute)dbRoute, (String)INSERT_SCENERULEPARAMFIELD_SQL_L, insertFieldParamsL);
        }
    }

    private void initInsertFieldParams(Map<String, String> sceneRuleParamMap, List<String> sceneParamIds, List<Object[]> insertFieldParams, List<Object[]> insertFieldParamsL) {
        int fieldCount = 0;
        int fieldCountL = 0;
        for (Map.Entry<String, String> entry : sceneRuleParamMap.entrySet()) {
            String dynPropStr;
            String entryIdStr = entry.getKey();
            if (sceneParamIds.contains(entryIdStr) || !HRStringUtils.isNotEmpty((String)(dynPropStr = entry.getValue()))) continue;
            JSONArray dynPropArr = JSON.parseArray((String)dynPropStr);
            for (int index = 0; index < dynPropArr.size(); ++index) {
                JSONObject dynProp = dynPropArr.getJSONObject(index);
                long entryId = Long.parseLong(entryIdStr);
                long detailId = this.getLongId(fieldCount);
                String fieldNumber = this.getOrDefault(dynProp, "Name", "");
                String displayName = this.getOrDefault(dynProp, "fDName", "");
                String fieldType = this.getOrDefault(dynProp, "type", "");
                String fieldName = this.getOrDefault(dynProp, "fName", "");
                insertFieldParams.add(new Object[]{entryId, detailId, index, fieldNumber, displayName, fieldType, fieldName});
                ++fieldCount;
                if (!HRStringUtils.isNotEmpty((String)displayName)) continue;
                String fpkid = this.getStrId(fieldCountL);
                insertFieldParamsL.add(new Object[]{fpkid, detailId, FLOCALEID_ZH_CN, displayName});
                ++fieldCountL;
            }
        }
    }

    private long getLongId(int index) {
        if (WTCCollections.isEmpty(this.longIds) || index >= this.longIds.size()) {
            long[] longs = ID.genLongIds((int)30);
            ArrayList ids = Lists.newArrayList((Iterator)Arrays.stream(longs).iterator());
            this.longIds.addAll(ids);
        }
        return this.longIds.get(index);
    }

    private String getStrId(int index) {
        if (WTCCollections.isEmpty(this.strIds) || index >= this.strIds.size()) {
            String[] strings = ID.genStringIds((int)30);
            ArrayList ids = Lists.newArrayList(Arrays.stream(strings).iterator());
            this.strIds.addAll(ids);
        }
        return this.strIds.get(index);
    }

    private String getOrDefault(JSONObject dynProp, String key, String defaultValue) {
        return (String)dynProp.getOrDefault((Object)key, (Object)defaultValue);
    }

    private Map<String, String> getSceneRuleParamMap(DBRoute dbRoute) {
        return (Map)HRDBUtil.query((DBRoute)dbRoute, (String)QUERY_SCENERULEPARAM_SQL, (Object[])new Object[0], resultSet -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            while (resultSet.next()) {
                String fentryid = resultSet.getString("fentryid");
                String fdynprop = resultSet.getString("fdynprop");
                map.put(fentryid, fdynprop);
            }
            return map;
        });
    }

    private List<String> getProcessedSceneRuleParamIds(DBRoute dbRoute) {
        return (List)HRDBUtil.query((DBRoute)dbRoute, (String)QUERY_SECENERULEPARAMFIELD_SQL, (Object[])new Object[0], resultSet -> {
            ArrayList<String> list = new ArrayList<String>(16);
            while (resultSet.next()) {
                list.add(resultSet.getString("fentryid"));
            }
            return list;
        });
    }
}

