/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.mservice.upgrade;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.wtte.common.enums.OutWorkType;

public class ShiftInOverTimeDataUpgrade
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(ShiftInOverTimeDataUpgrade.class);

    protected String getJobId() {
        return "3TV9OWM0TTUP";
    }

    protected String getScheduleId() {
        return "3TVA2NTQBV1Z";
    }

    protected boolean process() {
        this.upgradeShiftInOtData();
        return true;
    }

    private void upgradeShiftInOtData() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_shift");
        QFilter[] qFilters = new QFilter[]{new QFilter("isinot", "=", (Object)Boolean.FALSE), new QFilter("entryentity.outworktype", "=", (Object)OutWorkType.OT.code)};
        DynamicObject[] shiftDys = helper.loadDynamicObjectArray(qFilters);
        if (LOG.isInfoEnabled()) {
            LOG.info("upgradeShiftInOtData.shiftids:{}", Arrays.stream(shiftDys).map(dy -> dy.getLong("id")).toArray());
        }
        block0: for (DynamicObject shiftDy : shiftDys) {
            DynamicObjectCollection shiftPeriodColl = shiftDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject shiftPeriodDy : shiftPeriodColl) {
                if (!OutWorkType.OT.code.equals(shiftPeriodDy.getString("outworktype"))) continue;
                shiftDy.set("isinot", (Object)Boolean.TRUE);
                shiftDy.set("refinotstartday", (Object)shiftPeriodDy.getString("refstartday"));
                shiftDy.set("refinotendday", (Object)shiftPeriodDy.getString("refendday"));
                shiftDy.set("inotstart", (Object)shiftPeriodDy.getInt("shiftstartdate"));
                shiftDy.set("inotend", (Object)shiftPeriodDy.getInt("shiftenddate"));
                continue block0;
            }
        }
        helper.save(shiftDys);
    }
}

