/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.mob.shift;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbd.business.shift.ShiftServiceHelper;
import kd.wtc.wtbs.business.shift.ShiftService;

public class ShiftMobList
extends AbstractMobListPlugin {
    private static final Log LOG = LogFactory.getLog(ShiftMobList.class);

    public void beforePackageData(BeforePackageDataEvent evt) {
        super.beforePackageData(evt);
        if (evt.getPageData() == null || evt.getPageData().isEmpty()) {
            return;
        }
        DynamicObject[] shiftDys = ShiftServiceHelper.queryShiftByIdIn(evt.getPageData().stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        Map shiftDyMap = Arrays.stream(shiftDys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (o1, o2) -> o2));
        for (DynamicObject pageDatumDy : evt.getPageData()) {
            long shiftId = pageDatumDy.getLong("id");
            DynamicObject shiftDy = (DynamicObject)shiftDyMap.get(shiftId);
            if (shiftDy != null) {
                pageDatumDy.set("simplename", (Object)ShiftService.getInstance().getShiftEntryTip(shiftDy, System.lineSeparator()));
                continue;
            }
            pageDatumDy.set("simplename", (Object)"");
        }
    }
}

