/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.business.dateattr.DateAttributeServices;
import kd.wtc.wtbd.business.datetype.DateTypeServices;
import kd.wtc.wtbd.business.holiday.HolidayServices;
import kd.wtc.wtbd.business.workschedule.shiftmode.ShiftModeService;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleNewEntry;
import kd.wtc.wtbd.common.entity.workschedule.WorkScheduleNewEntryVo;
import kd.wtc.wtbs.business.shift.ShiftService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.model.customcontrol.shiftmode.ShiftModeCell;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;

public class WorkScheduleFormHelper {
    public static List<WorkScheduleNewEntryVo> batchConvert2VoList(List<WorkScheduleNewEntry> list) {
        HashSet<Long> holidayIdSet = new HashSet<Long>(16);
        HashSet<Long> datePropertyIdSet = new HashSet<Long>(16);
        HashSet<Long> dateTypeIdSet = new HashSet<Long>(16);
        HashSet<Long> shiftIdSet = new HashSet<Long>(16);
        for (WorkScheduleNewEntry entry : list) {
            String holidayIdStr = entry.getHolidayId();
            if (HRStringUtils.isNotEmpty((String)holidayIdStr)) {
                String[] split;
                for (String str : split = holidayIdStr.split(",")) {
                    long id = Long.parseLong(str);
                    holidayIdSet.add(id);
                }
            }
            datePropertyIdSet.add(entry.getDatePropertyId());
            long dateTypeId = entry.getDateTypeId();
            if (dateTypeId != 0L) {
                dateTypeIdSet.add(entry.getDateTypeId());
            }
            shiftIdSet.add(entry.getShiftId());
        }
        return WorkScheduleFormHelper.getWorkScheduleNewEntryVos(list, holidayIdSet, datePropertyIdSet, dateTypeIdSet, shiftIdSet);
    }

    private static List<WorkScheduleNewEntryVo> getWorkScheduleNewEntryVos(List<WorkScheduleNewEntry> list, Set<Long> holidayIdSet, Set<Long> datePropertyIdSet, Set<Long> dateTypeIdSet, Set<Long> shiftIdSet) {
        Map holidayNameMap = HolidayServices.queryHolidayNameMap(holidayIdSet);
        Map dateAttributeNameMap = DateAttributeServices.queryDateAttributeName(datePropertyIdSet);
        Map dateTypeNameMap = DateTypeServices.queryDateAttributeName(dateTypeIdSet);
        ShiftService shiftService = ShiftService.getInstance();
        Map shiftMap = shiftService.getShiftEvalVoHisMapByBoIds(shiftIdSet);
        ArrayList<WorkScheduleNewEntryVo> voList = new ArrayList<WorkScheduleNewEntryVo>(list.size());
        List sysUserIds = list.stream().map(WorkScheduleNewEntry::getEmodifierid).filter(id -> id != 0L).collect(Collectors.toList());
        Map userNameMap = WTCDynamicObjectUtils.queryIdNameMap((String)"bos_user", sysUserIds);
        Shift[] hisShifts = new Shift[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            WorkScheduleNewEntry entry = list.get(i);
            WorkScheduleNewEntryVo entryVo = new WorkScheduleNewEntryVo();
            String holidayIdStr = entry.getHolidayId();
            ArrayList holidayTagList = Lists.newArrayList();
            if (HRStringUtils.isNotEmpty((String)holidayIdStr)) {
                String[] split;
                for (String str : split = holidayIdStr.split(",")) {
                    long id2 = Long.parseLong(str);
                    holidayTagList.add(holidayNameMap.get(id2));
                }
            }
            entryVo.setHolidayTagList((List)holidayTagList);
            entryVo.setEnable(1);
            String emodifytimestr = "";
            if (entry.getEmodifytime() != null) {
                emodifytimestr = WTCDateUtils.date2Str((Date)entry.getEmodifytime(), (String)"yyyy-MM-dd");
            }
            entryVo.setEmodifytimestr(emodifytimestr);
            String emodifierName = (String)userNameMap.get(entry.getEmodifierid());
            if (HRStringUtils.isEmpty((String)emodifierName)) {
                emodifierName = "";
            }
            entryVo.setEmodifierName(emodifierName);
            WorkScheduleFormHelper.validateVo(shiftMap, hisShifts, entry, entryVo, i, voList);
            entryVo.setWorkDate(entry.getWorkDate());
            entryVo.setWorkDateStr(entry.getWorkDateStr());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(entry.getWorkDate());
            entryVo.setDay(calendar.get(5));
            entryVo.setDateType((String)dateTypeNameMap.get(entry.getDateTypeId()));
            entryVo.setDateAttribute((String)dateAttributeNameMap.get(entry.getDatePropertyId()));
            voList.add(entryVo);
        }
        return voList;
    }

    private static void validateVo(Map<Long, Map<Long, Shift>> shiftMap, Shift[] hisShifts, WorkScheduleNewEntry entry, WorkScheduleNewEntryVo entryVo, int index, List<WorkScheduleNewEntryVo> voList) {
        long shiftId = entry.getShiftId();
        Map<Long, Shift> hisShiftMap = shiftMap.get(shiftId);
        Shift shift = hisShiftMap.values().stream().filter(val -> !entry.getWorkDate().before(val.getBsed()) && !entry.getWorkDate().after(val.getBsled())).findFirst().orElse(null);
        if (shift == null) {
            entryVo.setShiftEffective(Boolean.FALSE);
            shift = hisShiftMap.get(shiftId);
        } else {
            entryVo.setShiftEffective(Boolean.TRUE);
            hisShifts[index] = shift;
        }
        if (index > 0 && Boolean.TRUE.equals(voList.get(index - 1).getShiftEffective()) && Boolean.TRUE.equals(entryVo.getShiftEffective())) {
            ShiftModeCell shiftModeCell1 = ShiftModeService.getInstance().getShiftModeCell(new ShiftModeCell(), hisShifts[index - 1]);
            ShiftModeCell shiftModeCell2 = ShiftModeService.getInstance().getShiftModeCell(new ShiftModeCell(), hisShifts[index]);
            boolean isOverlap = ShiftModeService.getInstance().isOverLap(shiftModeCell1, shiftModeCell2);
            WorkScheduleNewEntryVo prevVo = voList.get(index - 1);
            if (!Boolean.TRUE.equals(prevVo.getShiftTimeOverLap())) {
                prevVo.setShiftTimeOverLap(Boolean.valueOf(isOverlap));
            }
            entryVo.setShiftTimeOverLap(Boolean.valueOf(isOverlap));
            entryVo.setShiftTimeOverLapLeft(Boolean.valueOf(isOverlap));
            prevVo.setShiftTimeOverLapRight(Boolean.valueOf(isOverlap));
        }
        if (shift != null) {
            entryVo.setShiftName(shift.getName());
            entryVo.setShiftNumber(shift.getNumber());
            String shiftStartEndTimeStr = ShiftService.getInstance().genShiftPeriodDesc(shift, "-");
            entryVo.setStartEndTime(shiftStartEndTimeStr);
            entryVo.setOff(shift.isOff());
            entryVo.setShiftEntryList(shift.getShiftDetailList());
        }
    }

    public static List<String> validateShiftDates(List<WorkScheduleNewEntryVo> voList) {
        return voList.stream().filter(vo -> !Boolean.TRUE.equals(vo.getShiftEffective())).map(vo -> ResManager.loadKDString((String)"{0}\u7684\u73ed\u6b21\u201c{1}\u201d\u672a\u751f\u6548\uff0c\u4e0d\u53ef\u6392\u73ed\uff0c\u8bf7\u5148\u8c03\u6574\u540e\u518d\u64cd\u4f5c\u3002", (String)"WorkScheduleEdit_16", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)vo.getWorkDate()), vo.getShiftName()})).collect(Collectors.toList());
    }

    public static List<String> validateShiftOverlap(List<WorkScheduleNewEntryVo> voList) {
        List overlapVos = voList.stream().filter(vo -> Boolean.TRUE.equals(vo.getShiftTimeOverLap())).collect(Collectors.toList());
        ArrayList<String> messages = new ArrayList<String>();
        for (int i = 0; i < overlapVos.size() - 1; ++i) {
            String message;
            WorkScheduleNewEntryVo vo2 = (WorkScheduleNewEntryVo)overlapVos.get(i);
            WorkScheduleNewEntryVo nextVo = (WorkScheduleNewEntryVo)overlapVos.get(i + 1);
            if (i < overlapVos.size() - 2 && Boolean.TRUE.equals(nextVo.getShiftTimeOverLapLeft()) && Boolean.TRUE.equals(nextVo.getShiftTimeOverLapRight())) {
                message = ResManager.loadKDString((String)"{0}\u4e0e{1}\uff0c{2}\u73ed\u6b21\u5b58\u5728\u65f6\u6bb5\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u64cd\u4f5c\u3002", (String)"WorkScheduleEdit_18", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)nextVo.getWorkDate()), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)vo2.getWorkDate()), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((WorkScheduleNewEntryVo)overlapVos.get(i + 2)).getWorkDate())});
                i += 2;
            } else {
                message = ResManager.loadKDString((String)"{0}\u4e0e{1}\u73ed\u6b21\u5b58\u5728\u65f6\u6bb5\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u64cd\u4f5c\u3002", (String)"WorkScheduleEdit_19", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)vo2.getWorkDate()), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)nextVo.getWorkDate())});
                ++i;
            }
            if (message == null) continue;
            messages.add(message);
        }
        return messages;
    }

    public static void showConfirm(IFormView view, String title, List<String> messages) {
        if (CollectionUtils.isEmpty(messages)) {
            return;
        }
        if (messages.size() == 1) {
            view.showTipNotification(messages.get(0));
        } else if (messages.size() > 1) {
            view.showConfirm(title, String.join((CharSequence)"\n", messages), MessageBoxOptions.OK, ConfirmTypes.Default, null);
        }
    }
}

