/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.attitem;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.model.ex.ExAtteItemVo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtbd.common.attitem.AttItemItemType;

class AttItemywListProvider
extends ListDataProvider {
    public static final Log log = LogFactory.getLog(AttItemywListProvider.class);
    private List<ExAtteItemVo> exParamList;
    private String besd;

    public AttItemywListProvider(List<ExAtteItemVo> exParamList, String besd) {
        this.exParamList = exParamList;
        this.besd = besd;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        int databaseNum;
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtbd_attitem_ex");
        Date date = null;
        try {
            date = WTCDateUtils.parseDate((String)this.besd, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            log.error("\u65f6\u95f4\u8f6c\u5316\u62a5\u9519:{}", (Object)e.getMessage());
        }
        QFilter itemQFilter = this.getItemQFilter(date);
        int num = hrBaseServiceHelper.count("wtbd_attitem_ex", new QFilter[]{itemQFilter});
        DynamicObjectCollection rows = super.getData(0, num);
        if (rows.isEmpty()) {
            return rows;
        }
        HashMap configMap = Maps.newHashMapWithExpectedSize((int)this.exParamList.size());
        HashMap exTypeMap = Maps.newHashMapWithExpectedSize((int)this.exParamList.size());
        for (ExAtteItemVo itemVo : this.exParamList) {
            Long id = itemVo.getId();
            Set configList = (Set)configMap.get(id);
            Set exTypeList = (Set)exTypeMap.get(id);
            if (configList == null) {
                configList = Sets.newHashSetWithExpectedSize((int)16);
            }
            if (exTypeList == null) {
                exTypeList = Sets.newHashSetWithExpectedSize((int)16);
            }
            configList.add(itemVo.getPropertyName());
            exTypeList.add(itemVo.getAttributeName());
            configMap.put(id, configList);
            exTypeMap.put(id, exTypeList);
        }
        for (DynamicObject dy2 : rows) {
            long id = dy2.getLong("id");
            Set configList = (Set)configMap.get(id);
            Set exTypeList = (Set)exTypeMap.get(id);
            if (configList != null) {
                dy2.set("ownconfig", (Object)StringUtils.join((Iterable)configList, (String)"\uff0c"));
            }
            if (exTypeList == null) continue;
            dy2.set("exprop", (Object)StringUtils.join((Iterable)exTypeList, (String)"\uff0c"));
        }
        rows.sort((o1, o2) -> {
            String o1ownconfig = o1.getString("ownconfig");
            String o2ownconfig = o2.getString("ownconfig");
            if (o1ownconfig.length() > o2ownconfig.length()) {
                return -1;
            }
            if (o1ownconfig.length() == o2ownconfig.length()) {
                return 0;
            }
            return 1;
        });
        int toIndex = start + limit;
        if (num - 1 <= toIndex) {
            toIndex = num;
        }
        if (toIndex >= (databaseNum = rows.size())) {
            toIndex = databaseNum;
        }
        List resultList = WTCCollections.subList((List)rows, (int)start, (int)toIndex);
        Set idSet = resultList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        Iterator iterator = rows.iterator();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            long id = next.getLong("id");
            if (idSet.contains(id)) continue;
            iterator.remove();
        }
        return rows;
    }

    private QFilter getItemQFilter(Date bsed) {
        ArrayList itemTypeList = Lists.newArrayListWithExpectedSize((int)2);
        itemTypeList.add("1");
        itemTypeList.add("2");
        QFilter qFilter = new QFilter("itemtype", "in", (Object)itemTypeList);
        qFilter.and(new QFilter("datatype", "=", (Object)"1"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("unit", "not in", (Object)"time"));
        qFilter.and(new QFilter("issave", "=", (Object)Boolean.TRUE).and("itemtype", "in", (Object)new String[]{AttItemItemType.DETAIL_ITEM.type, AttItemItemType.DETAIL_SUM_ITEM.type}).and("isorginattitem", "=", (Object)Boolean.FALSE));
        qFilter.and(new QFilter("firstbsed", "<=", (Object)bsed));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        return qFilter;
    }
}

