/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.constparam;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.wtbd.common.constparam.ConstParamConstants;
import kd.wtc.wtbs.wtbd.common.enums.constparam.ConstParamTypeEnum;

public class ConstParamEdit
extends HRDataBaseEdit
implements ConstParamConstants {
    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (WTCStringUtils.equals((String)"type", (String)name)) {
            this.setTypeChange("type");
            this.getView().getPageCache().put("value", "1");
        }
    }

    private void setTypeChange(String name) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String typeValue = dynamicObject.getString(name);
        for (ConstParamTypeEnum constSetTypeEnum : ConstParamTypeEnum.values()) {
            String value = constSetTypeEnum.getValue();
            if (WTCStringUtils.equals((String)constSetTypeEnum.getCode(), (String)typeValue)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{value});
                ((FieldEdit)this.getControl(value)).setMustInput(Boolean.TRUE.booleanValue());
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{value});
            ((FieldEdit)this.getControl(value)).setMustInput(Boolean.FALSE.booleanValue());
            this.getModel().setValue(value, null);
        }
    }

    private void setTypeValue(String name) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String typeValue = dynamicObject.getString(name);
        ConstParamTypeEnum constSetTypeEnum = ConstParamTypeEnum.getByCode((String)typeValue);
        switch (constSetTypeEnum) {
            case STRING: {
                String value = dynamicObject.getString(constSetTypeEnum.getValue());
                if (WTCStringUtils.isEmpty((String)value)) {
                    return;
                }
                this.getModel().setValue("value", (Object)dynamicObject.getString(constSetTypeEnum.getValue()));
                break;
            }
            case NUMBER: {
                BigDecimal valueBigDecimal = dynamicObject.getBigDecimal(constSetTypeEnum.getValue());
                this.getModel().setValue("value", valueBigDecimal == null ? BigDecimal.ZERO : String.valueOf(valueBigDecimal));
                this.getView().updateView(constSetTypeEnum.getValue());
                break;
            }
            case BOOLEAN: {
                String valueBoolean = dynamicObject.getString(constSetTypeEnum.getValue());
                this.getModel().setValue("value", (Object)valueBoolean);
                break;
            }
            case DATE: {
                Date valueDate = dynamicObject.getDate(constSetTypeEnum.getValue());
                this.getModel().setValue("value", valueDate == null ? null : String.valueOf(valueDate.getTime()));
                break;
            }
        }
        for (ConstParamTypeEnum typeEnum : ConstParamTypeEnum.values()) {
            if (constSetTypeEnum == typeEnum) continue;
            this.getModel().setValue(typeEnum.getValue(), null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "save": 
            case "submit": 
            case "submitandaudit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                this.setTypeValue("type");
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        Long bid = dynamicObject.getLong("boid");
        if (bid == null || HRStringUtils.equals((String)"0", (String)String.valueOf(bid))) {
            this.setTypeChange("type");
            return;
        }
        HRBaseServiceHelper constParamServiceHelper = new HRBaseServiceHelper("wtbd_constparam");
        DynamicObject queryObject = constParamServiceHelper.queryOne("type", (Object)bid);
        if (queryObject != null && WTCStringUtils.isEmpty((String)dynamicObject.getString("type"))) {
            String type = queryObject.getString("type");
            this.getModel().setValue("type", (Object)type);
        }
        this.setTypeChange("type");
    }

    public void afterBindData(EventObject e) {
        boolean isEnable;
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fromPage = String.valueOf(customParams.get("fromPage"));
        boolean bl = isEnable = "fromHisAction".equals(fromPage) || "revise".equals(fromPage);
        if (isEnable) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"type"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"type"});
        }
    }
}

