/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.countmsg;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.common.utils.WtbdCacheHelper;

public class CountMsgTreeListPlugin
extends StandardTreeListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("new".equals(operateKey)) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            String focusNodeId = treeView.getTreeState().getFocusNodeId();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String pageId = this.getView().getPageId();
            WtbdCacheHelper.cache((String)pageId, (String)focusNodeId);
            formShowParameter.setParentPageId(pageId);
        }
    }

    public void refreshNode(RefreshNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        if (HRStringUtils.equals((String)nodeId, (String)"-1")) {
            List<TreeNode> childNodes = this.getCloudNodes();
            evt.setChildNodes(childNodes);
        } else {
            super.refreshNode(evt);
        }
    }

    public void initializeTree(EventObject eventObject) {
        super.initializeTree(eventObject);
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"CountMsgTreeListPlugin_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getCloudNodes();
        root.addChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent buildTreeListFilterEvent) {
        super.buildTreeListFilter(buildTreeListFilterEvent);
        String focusNodeId = buildTreeListFilterEvent.getNodeId().toString();
        if ("-1".equals(focusNodeId)) {
            QFilter modelFilter = new QFilter("msgtype", "!=", (Object)Long.valueOf(focusNodeId));
            buildTreeListFilterEvent.addQFilter(modelFilter);
        } else {
            QFilter modelFilter = new QFilter("msgtype", "=", (Object)Long.valueOf(focusNodeId));
            buildTreeListFilterEvent.addQFilter(modelFilter);
        }
    }

    private List<TreeNode> getCloudNodes() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_countmsgtype");
        QFilter[] qFilters = new QFilter[]{new QFilter("status", "=", (Object)"C")};
        DynamicObject[] msgDyList = serviceHelper.loadDynamicObjectArray(qFilters);
        if (msgDyList == null || msgDyList.length == 0) {
            return new ArrayList<TreeNode>(10);
        }
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>(msgDyList.length);
        for (int i = 0; i < msgDyList.length; ++i) {
            DynamicObject dynamicObject = msgDyList[i];
            TreeNode node = new TreeNode("-1", dynamicObject.getPkValue().toString(), dynamicObject.getString("name"));
            cloudNode.add(node);
        }
        return cloudNode;
    }

    public void treeNodeClick(TreeNodeEvent event) {
        super.treeNodeClick(event);
        WtbdCacheHelper.cache((String)this.getView().getPageId(), (String)((String)event.getNodeId()));
    }
}

