/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.duringcycle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.cycset.CycCulService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.util.attfilef7.AttFileF7Utils;
import kd.wtc.wtbs.common.model.attfileauth.AttFileAuth;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;

public class CycSetEdit
extends HRDataBaseEdit
implements AfterF7SelectListener {
    private static final String REGEX_NUMBERANDLOG = "[0-9,]+";
    private static final String REGEX_NUMBER = "[0-9]+";

    public void registerListener(EventObject event) {
        BasedataEdit attFile = (BasedataEdit)this.getControl("attfile");
        attFile.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void beforeBindData(EventObject object) {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String cycType = this.getModel().getDataEntity().getString("cyctype");
        if (OperationStatus.ADDNEW != operationStatus || cycType != null) {
            String cycUnit = this.getModel().getDataEntity().getString("cycunit");
            boolean isCycToData = this.getModel().getDataEntity().getBoolean("iscyctodata");
            boolean isCycAttach = this.getModel().getDataEntity().getBoolean("ischeckcycass");
            if (isCycAttach) {
                this.setFieldsMustInput(true, "attachtype");
                this.setFieldsMustInput(true, "attachunit");
            }
            this.setMustInputForCycDate();
            this.showCycSetPageBySelect(cycType, cycUnit, isCycToData);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject eve) {
        super.afterBindData(eve);
        this.getView().setVisible(Boolean.FALSE, new String[]{"attfile"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "unaudit": {
                if (!this.checkHasHave()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u671f\u95f4\u5faa\u73af\u914d\u7f6e\u5df2\u7ecf\u88ab\u5b9a\u989d\u751f\u6210\u914d\u7f6e\u5f15\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"CycSetEdit_21", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "save": 
            case "submit": 
            case "submitandaudit": {
                if (!this.checkValues("cycvalues") || !this.checkValues("gapint")) {
                    args.setCancel(true);
                    return;
                }
                String proStartDate = this.getModel().getDataEntity().getString("prostartdate");
                Date date = this.getModel().getDataEntity().getDate("proenddate");
                if (date != null && !"A".equals(proStartDate) && this.getModel().getDataEntity().getDate("selfdate").after(date)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u81ea\u5b9a\u4e49\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CycSetEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (this.checkHasHave()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u671f\u95f4\u5faa\u73af\u914d\u7f6e\u5df2\u7ecf\u88ab\u5b9a\u989d\u751f\u6210\u914d\u7f6e\u5f15\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"CycSetEdit_21", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getModel().beginInit();
                String cycType = this.getModel().getDataEntity().getString("cyctype");
                String cycUnit = this.getModel().getDataEntity().getString("cycunit");
                boolean isCycToData = this.getModel().getDataEntity().getBoolean("iscyctodata");
                this.setFieldsSetNullByCycType(isCycToData, cycType, cycUnit);
                this.getView().updateView();
                this.getModel().endInit();
                break;
            }
        }
    }

    private void setFieldsSetNullByCycType(boolean isCycToData, String cycType, String cycUnit) {
        block6 : switch (cycType) {
            case "B": {
                switch (cycUnit) {
                    case "A": 
                    case "E": {
                        this.setFieldsSetNull("cycdate", "cycselec", "unit");
                        break block6;
                    }
                    case "B": 
                    case "C": {
                        if (isCycToData) {
                            this.setFieldsSetNull("cycdate", "unit");
                            break block6;
                        }
                        this.setFieldsSetNull("cycdate", "cycselec", "unit");
                        break block6;
                    }
                    case "D": {
                        if (isCycToData) {
                            this.setFieldsSetNull("cycselec", "unit");
                            break block6;
                        }
                        this.setFieldsSetNull("cycdate", "cycselec", "unit");
                        break block6;
                    }
                }
                break;
            }
            case "A": 
            case "C": {
                switch (cycUnit) {
                    case "A": 
                    case "E": {
                        this.setFieldsSetNull("cycdate", "cycselec", "unit", "gapint");
                        break block6;
                    }
                    case "B": 
                    case "C": {
                        if (isCycToData) {
                            this.setFieldsSetNull("cycdate", "unit", "gapint");
                            break block6;
                        }
                        this.setFieldsSetNull("cycdate", "cycselec", "unit", "gapint");
                        break block6;
                    }
                    case "D": {
                        if (isCycToData) {
                            this.setFieldsSetNull("cycselec", "unit", "gapint");
                            break block6;
                        }
                        this.setFieldsSetNull("cycdate", "cycselec", "unit", "gapint");
                        break block6;
                    }
                }
                break;
            }
            case "D": {
                switch (cycUnit) {
                    case "A": {
                        this.setFieldsSetNull("cycdate", "cycselec");
                        break block6;
                    }
                    case "B": 
                    case "C": {
                        if (isCycToData) {
                            this.setFieldsSetNull("cycdate");
                            break block6;
                        }
                        this.setFieldsSetNull("cycdate", "cycselec");
                        break block6;
                    }
                    case "D": {
                        if (isCycToData) {
                            this.setFieldsSetNull("cycselec");
                            break block6;
                        }
                        this.setFieldsSetNull("cycdate", "cycselec");
                        break block6;
                    }
                }
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("cul".equals(afterDoOperationEventArgs.getOperateKey())) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String proStartDate = dataEntity.getString("prostartdate");
            if ("A".equals(proStartDate)) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("wtbd_pcycleconfigtrial");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                Date endDate = dataEntity.getDate("proenddate") == null ? WTCHisServiceHelper.getMaxEndDate() : dataEntity.getDate("proenddate");
                showParameter.setCustomParam("proenddate", (Object)endDate);
                showParameter.setCustomParam("id", dataEntity.getPkValue());
                showParameter.setCustomParam("cycunit", (Object)dataEntity.getString("cycunit"));
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "selectRefDate");
                showParameter.setCloseCallBack(callBack);
                this.getView().showForm(showParameter);
            } else {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("executejob", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5faa\u73af\u914d\u7f6e\u4e2d\u65e0\u53c2\u7167\u65e5\u671f\u914d\u7f6e\uff0c\u53ef\u901a\u8fc7\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f\u76f4\u63a5\u751f\u6210\u671f\u95f4\u4fe1\u606f\u3002\u662f\u5426\u751f\u6210\uff1f", (String)"CycSetEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long pkValue = (Long)dataEntity.getPkValue();
            if ("E".equals(dataEntity.getString("cycunit"))) {
                this.getCache().put("prostartdate", (Object)dataEntity.getDate("selfdate"));
                this.getCache().put("id", (Object)pkValue);
                this.getCache().put("cycunit", (Object)dataEntity.getString("cycunit"));
                BasedataEdit attFile = (BasedataEdit)this.getView().getControl("attfile");
                attFile.click();
            } else {
                CycCulService.toCircleResult((Long)pkValue, (Date)dataEntity.getDate("selfdate"), (IFormView)this.getView(), null);
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        BasedataEdit basedataEdit = (BasedataEdit)event.getSource();
        String fieldKey = basedataEdit.getFieldKey();
        if ("attfile".equals(fieldKey)) {
            ListSelectedRowCollection selectedRows = event.getListSelectedRowCollection();
            Object[] attFileIds = selectedRows.getPrimaryKeyValues();
            List attFileIdList = Arrays.stream(attFileIds).map(info -> (Long)info).collect(Collectors.toList());
            List attFileAuthList = AttFileF7Utils.getAttFileAuthList(attFileIdList);
            Long attPersonId = ((AttFileAuth)attFileAuthList.get(0)).getAttPerson().getBoid();
            Long id = (Long)this.getCache().get("id", Long.class);
            Date selectRefDate = (Date)this.getCache().get("prostartdate", Date.class);
            CycCulService.toCircleResult((Long)id, (Date)selectRefDate, (IFormView)this.getView(), (Long)attPersonId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"selectRefDate")) {
            CycCulService.closedCallBack((ClosedCallBackEvent)closedCallBackEvent, (IFormView)this.getView(), (HRPageCache)this.getCache());
        }
    }

    private boolean checkValues(String log) {
        String number = this.getModel().getDataEntity().getString(log);
        String type = this.getModel().getDataEntity().getString("cyctype");
        String logName = "cycvalues".equals(log) ? ResManager.loadKDString((String)"\u5faa\u73af\u6570\u503c", (String)"CycSetEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u95f4\u9694\u6570\u503c", (String)"CycSetEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        switch (type) {
            case "C": 
            case "D": {
                String[] nums;
                if (!"cycvalues".equals(log) && "C".equals(type)) break;
                if (!HRStringUtils.isEmpty((String)number) && !this.isMatche(REGEX_NUMBERANDLOG, number)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c%s\u201d\u53ef\u8f93\u5165\u6700\u591a10\u4e2a1-9999\u6b63\u6574\u6570\u503c\uff0c\u7528\u82f1\u6587\u201c,\u201d\u9694\u5f00\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CycSetEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{logName}));
                    return false;
                }
                for (String num : nums = number.split(",", -1)) {
                    if (!StringUtils.isBlank((CharSequence)num) && !this.numberValueCheck(num)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c%s\u201d\u8bf7\u8f93\u51651-9999\u4e4b\u95f4\u7684\u6b63\u6574\u6570\u503c\u3002", (String)"CycSetEdit_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{logName}));
                    return false;
                }
                if (nums.length <= 10) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c%s\u201d\uff0c\u6700\u591a\u53ef\u8f93\u516510\u4e2a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CycSetEdit_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{logName}));
                return false;
            }
            default: {
                if (!HRStringUtils.isEmpty((String)number) && !this.isMatche(REGEX_NUMBER, number)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9a\u671f\u5faa\u73af\uff0c\u201c%s\u201d\u53ea\u80fd\u8f93\u5165\u4e00\u4e2a\u6b63\u6574\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CycSetEdit_7", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{logName}));
                    return false;
                }
                if (!this.numberRangerCheck(number)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c%s\u201d\u8bf7\u8f93\u51651-9999\u4e4b\u95f4\u7684\u6b63\u6574\u6570\u503c\u3002", (String)"CycSetEdit_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{logName}));
                return false;
            }
        }
        return true;
    }

    private boolean numberValueCheck(String number) {
        return number.length() > 4 || Integer.parseInt(number) < 1 || Integer.parseInt(number) > 9999;
    }

    private boolean numberRangerCheck(String number) {
        return HRStringUtils.isNotEmpty((String)number) && this.numberValueCheck(number);
    }

    private boolean isMatche(String regex, String matcheString) {
        if (HRStringUtils.isEmpty((String)regex) || HRStringUtils.isEmpty((String)matcheString)) {
            return false;
        }
        return Pattern.matches(regex, matcheString);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "cyctype": {
                this.setCycUnitOptions(this.getCycUnitItems(this.getModel().getDataEntity().getString("cyctype")));
            }
            case "cycunit": 
            case "iscyctodata": {
                String cycType = this.getModel().getDataEntity().getString("cyctype");
                String cycUnit = this.getModel().getDataEntity().getString("cycunit");
                boolean isCycToData = this.getModel().getDataEntity().getBoolean("iscyctodata");
                if ("A".equals(cycUnit) || "E".equals(cycUnit)) {
                    this.getModel().setValue("iscyctodata", (Object)Boolean.FALSE);
                }
                if (("B".equals(cycType) || "D".equals(cycType)) && "cyctype".equals(name)) {
                    this.setFieldsMustInput(true, "gapint");
                    this.setFieldsMustInput(true, "unit");
                }
                if (cycType == null || cycUnit == null) break;
                this.showCycSetPageBySelect(cycType, cycUnit, isCycToData);
                break;
            }
            case "prostartdate": {
                this.setMustInputForCycDate();
                break;
            }
            case "ischeckcycass": {
                boolean isCycAttach = this.getModel().getDataEntity().getBoolean("ischeckcycass");
                if (isCycAttach) {
                    this.setFieldsMustInput(true, "attachtype");
                    this.setFieldsMustInput(true, "attachunit");
                    break;
                }
                this.setFieldsMustInput(false, "attachtype");
                this.setFieldsMustInput(false, "attachunit");
                break;
            }
            case "cycvalues": {
                this.checkValues("cycvalues");
                break;
            }
            case "gapint": {
                this.checkValues("gapint");
                break;
            }
        }
        this.setTips();
    }

    private void setMustInputForCycDate() {
        String proStartDate = this.getModel().getDataEntity().getString("prostartdate");
        if ("A".equals(proStartDate)) {
            this.setFieldsMustInput(true, "cycrefdate");
            this.setFieldsMustInput(false, "selfdate");
        }
        if ("B".equals(proStartDate)) {
            this.setFieldsMustInput(false, "cycrefdate");
            this.setFieldsMustInput(true, "selfdate");
        }
    }

    private void showCycSetPageBySelect(String cycType, String cycUnit, boolean isCycToData) {
        if ("B".equals(cycUnit)) {
            this.setLoopDayOptions(this.getWeekLoopDayItems());
        } else if ("C".equals(cycUnit)) {
            this.setLoopDayOptions(this.getMonthLoopDayItems());
        }
        switch (cycType) {
            case "A": {
                this.showCycSetPageBySelectByCycTypeA(cycUnit, isCycToData);
                break;
            }
            case "B": {
                this.showCycSetPageBySelectByCycTypeB(cycUnit, isCycToData);
                break;
            }
            case "C": {
                this.showCycSetPageBySelectByCycTypeC(cycUnit, isCycToData);
                break;
            }
            case "D": {
                this.showCycSetPageBySelectByCycTypeD(cycUnit, isCycToData);
                break;
            }
        }
    }

    private void showCycSetPageBySelectByCycTypeB(String cycUnit, boolean isCycToData) {
        switch (cycUnit) {
            case "A": {
                this.setFieldsMustInput(true, "gapint");
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit");
                break;
            }
            case "B": {
                if (isCycToData) {
                    this.setFieldsMustInput(true, "cycselec", "gapint");
                    this.setFieldsMustInput(false, "cycdate", "unit");
                    break;
                }
                this.setFieldsMustInput(true, "gapint");
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit");
                break;
            }
            case "C": {
                if (isCycToData) {
                    this.setFieldsMustInput(true, "cycselec", "gapint");
                    this.setFieldsMustInput(false, "cycdate", "unit");
                    break;
                }
                this.setFieldsMustInput(true, "gapint");
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit");
                break;
            }
            case "D": {
                if (isCycToData) {
                    this.setFieldsMustInput(true, "cycdate", "gapint");
                    this.setFieldsMustInput(false, "cycselec", "unit");
                    break;
                }
                this.setFieldsMustInput(true, "gapint");
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit");
                break;
            }
            case "E": {
                this.setFieldsMustInput(true, "gapint");
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit");
                break;
            }
        }
    }

    private void showCycSetPageBySelectByCycTypeC(String cycUnit, boolean isCycToData) {
        switch (cycUnit) {
            case "A": {
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit", "gapint");
                break;
            }
            case "B": {
                if (isCycToData) {
                    this.setFieldsMustInput(true, "cycselec");
                    this.setFieldsMustInput(false, "cycdate", "unit", "gapint");
                    break;
                }
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit", "gapint");
                break;
            }
            case "C": {
                if (isCycToData) {
                    this.setFieldsMustInput(true, "cycselec");
                    this.setFieldsMustInput(false, "cycdate", "unit", "gapint");
                    break;
                }
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit", "gapint");
                break;
            }
            case "D": {
                if (isCycToData) {
                    this.setFieldsMustInput(true, "cycdate");
                    this.setFieldsMustInput(false, "cycselec", "unit", "gapint");
                    break;
                }
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit", "gapint");
                break;
            }
            case "E": {
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit", "gapint");
                break;
            }
        }
    }

    private void showCycSetPageBySelectByCycTypeD(String cycUnit, boolean isCycToData) {
        switch (cycUnit) {
            case "A": {
                this.setFieldsMustInput(true, "gapint", "unit");
                this.setFieldsMustInput(false, "cycdate", "cycselec");
                break;
            }
            case "B": {
                if (isCycToData) {
                    this.setFieldsMustInput(true, "gapint", "unit", "cycselec");
                    this.setFieldsMustInput(false, "cycdate");
                    break;
                }
                this.setFieldsMustInput(true, "gapint", "unit");
                this.setFieldsMustInput(false, "cycdate", "cycselec");
                break;
            }
            case "C": {
                if (isCycToData) {
                    this.setFieldsMustInput(true, "gapint", "unit", "cycselec");
                    this.setFieldsMustInput(false, "cycdate");
                    break;
                }
                this.setFieldsMustInput(true, "gapint", "unit");
                this.setFieldsMustInput(false, "cycdate", "cycselec");
                break;
            }
            case "D": {
                if (isCycToData) {
                    this.setFieldsMustInput(true, "gapint", "unit", "cycdate");
                    this.setFieldsMustInput(false, "cycselec");
                    break;
                }
                this.setFieldsMustInput(true, "gapint", "unit");
                this.setFieldsMustInput(false, "cycdate", "cycselec");
                break;
            }
        }
    }

    private void showCycSetPageBySelectByCycTypeA(String cycUnit, boolean isCycToData) {
        switch (cycUnit) {
            case "A": {
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit", "gapint");
                break;
            }
            case "B": {
                if (isCycToData) {
                    this.setFieldsMustInput(true, "cycselec");
                    this.setFieldsMustInput(false, "cycdate", "unit", "gapint");
                    break;
                }
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit", "gapint");
                break;
            }
            case "C": {
                if (isCycToData) {
                    this.setFieldsMustInput(true, "cycselec");
                    this.setFieldsMustInput(false, "cycdate", "unit", "gapint");
                    break;
                }
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit", "gapint");
                break;
            }
            case "D": {
                if (isCycToData) {
                    this.setFieldsMustInput(true, "cycdate");
                    this.setFieldsMustInput(false, "cycselec", "unit", "gapint");
                    break;
                }
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit", "gapint");
                break;
            }
            case "E": {
                this.setFieldsMustInput(false, "cycdate", "cycselec", "unit", "gapint");
                break;
            }
        }
    }

    private void setFieldsMustInput(boolean flag, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            ((FieldEdit)this.getControl(fieldName)).setMustInput(flag);
        }
    }

    private void setFieldsSetNull(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.getModel().setValue(fieldName, null);
        }
    }

    private void setLoopDayOptions(List<ComboItem> ComboItems) {
        ComboEdit loopday = (ComboEdit)this.getControl("cycselec");
        loopday.setComboItems(ComboItems);
    }

    private void setCycUnitOptions(List<ComboItem> ComboItems) {
        String cycTypeValue = this.getModel().getDataEntity().getString("cyctype");
        String cycUnitValue = this.getModel().getDataEntity().getString("cycunit");
        if ("D".equals(cycTypeValue) && "E".equals(cycUnitValue)) {
            this.getModel().setValue("cycunit", null);
        }
        ComboEdit cycUnit = (ComboEdit)this.getControl("cycunit");
        cycUnit.setComboItems(ComboItems);
    }

    private List<ComboItem> getWeekLoopDayItems() {
        ArrayList weekLoopDayItems = Lists.newArrayListWithExpectedSize((int)8);
        weekLoopDayItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5468\u4e00", (String)"CycSetEdit_8", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])), "1"));
        weekLoopDayItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5468\u4e8c", (String)"CycSetEdit_9", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])), "2"));
        weekLoopDayItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5468\u4e09", (String)"CycSetEdit_10", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])), "3"));
        weekLoopDayItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5468\u56db", (String)"CycSetEdit_11", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])), "4"));
        weekLoopDayItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5468\u4e94", (String)"CycSetEdit_12", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])), "5"));
        weekLoopDayItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5468\u516d", (String)"CycSetEdit_13", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])), "6"));
        weekLoopDayItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5468\u65e5", (String)"CycSetEdit_14", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])), "7"));
        return weekLoopDayItems;
    }

    private List<ComboItem> getMonthLoopDayItems() {
        ArrayList monthLoopDayItems = Lists.newArrayListWithExpectedSize((int)30);
        for (int i = 1; i <= 28; ++i) {
            String sign = String.valueOf(i);
            monthLoopDayItems.add(new ComboItem(new LocaleString(sign), sign));
        }
        monthLoopDayItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u65e5", (String)"CycSetEdit_15", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])), "-1"));
        return monthLoopDayItems;
    }

    private List<ComboItem> getCycUnitItems(String cycType) {
        ArrayList cycUnitItems = Lists.newArrayListWithExpectedSize((int)8);
        cycUnitItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u65e5", (String)"CycSetEdit_16", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])), "A"));
        cycUnitItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5468", (String)"CycSetEdit_17", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])), "B"));
        cycUnitItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6708", (String)"CycSetEdit_18", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])), "C"));
        if (!"D".equals(cycType)) {
            cycUnitItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8003\u52e4\u671f\u95f4", (String)"CycSetEdit_19", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])), "E"));
        }
        cycUnitItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e74", (String)"CycSetEdit_20", (String)"wtc-wtbd-formplugin", (Object[])new Object[0])), "D"));
        return cycUnitItems;
    }

    private HRPageCache getCache() {
        return new HRPageCache(this.getPageCache());
    }

    private void setTips() {
        Map promptMap = WTCFormUtils.getPromptMap((IFormView)this.getView(), null, null, null, null, (Boolean)Boolean.TRUE);
        WTCFormUtils.setTips((IFormView)this.getView(), (Map)promptMap);
    }

    private boolean checkHasHave() {
        long id = this.getModel().getDataEntity().getLong("id");
        if (0L != id) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_qtgenconfig");
            DynamicObject genConfig = serviceHelper.queryOne(new QFilter[]{new QFilter("cycset", "=", (Object)id), WTCHisServiceHelper.dataStatusValidQFilter()});
            if (null != genConfig) {
                return true;
            }
        }
        return false;
    }
}

