/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.holiday;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.common.utils.SetMustInputLogUtil;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.ObjectUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class HolidayEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Set<String> NOCHECKCHANGEDFIELDS = Sets.newHashSetWithExpectedSize((int)4);

    public void registerListener(EventObject object) {
        super.registerListener(object);
        BasedataEdit parentEdit = (BasedataEdit)this.getView().getControl("datetype");
        parentEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (HRStringUtils.equals((String)beforeF7SelectEvent.getProperty().getName(), (String)"datetype")) {
            QFilter qFilter = new QFilter("dateproperty.number", "not in", Arrays.asList(DateAttribute.WORKDAY.getCode(), DateAttribute.OFFDAY.getCode()));
            formShowParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String holidayType;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equalsIgnoreCase(operateKey) && StringUtils.equalsIgnoreCase((CharSequence)(holidayType = this.getModel().getDataEntity().getString("holidaytype")), (CharSequence)"B")) {
            DynamicObject dynamicObject;
            Date date;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("unfixentry");
            Iterator iterator = entryEntity.iterator();
            while (iterator.hasNext() && (date = (dynamicObject = (DynamicObject)iterator.next()).getDate("ufstartdate")) != null) {
                Integer startTime = dynamicObject.getInt("ufstarttime");
                Integer endTime = dynamicObject.getInt("ufendtime");
                if (!ObjectUtils.isNotEmpty((Object)startTime) || !ObjectUtils.isNotEmpty((Object)endTime) || startTime <= endTime) continue;
                args.setCancel(true);
                String errMsg = ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"HolidayEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errMsg);
                break;
            }
        }
    }

    public void afterBindData(EventObject object) {
        this.dysetMustInputLog();
        this.getModel().setDataChanged(false);
        boolean isSysPreset = this.getModel().getDataEntity().getBoolean("issyspreset");
        this.getView().setVisible(Boolean.valueOf(!isSysPreset), new String[]{"btncancel", "btnsave"});
        this.getView().setVisible(Boolean.valueOf(isSysPreset), new String[]{"btnclose"});
        this.getView().setEnable(Boolean.valueOf(!isSysPreset), new String[]{"conentpanel"});
        this.getView().setVisible(Boolean.valueOf(!isSysPreset), new String[]{"advcontoolbarap"});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        this.putUfendateValue(args, propertyName);
        this.cleanUfix(propertyName);
        this.putUfendateStatus(args, propertyName);
        switch (propertyName) {
            case "holidaytype": {
                this.addRowForEntryEntity(propertyName);
            }
            case "fixedtype": {
                this.dysetMustInputLog();
                break;
            }
            case "ufstartdate": 
            case "ufstarttime": 
            case "ufendtime": {
                this.validNonFixedStartEndTime(args);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        for (String noCheckChangedField : NOCHECKCHANGEDFIELDS) {
            IDataEntityProperty noCheckChangedFieldProp = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)noCheckChangedField);
            dataEntity.getDataEntityState().setBizChanged(noCheckChangedFieldProp.getOrdinal(), false);
        }
    }

    private void addRowForEntryEntity(String propertyName) {
        String holidayType = this.getModel().getDataEntity().getString(propertyName);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("unfixentry");
        if ("A".equalsIgnoreCase(holidayType)) {
            this.getModel().deleteEntryData("unfixentry");
        } else if ("B".equalsIgnoreCase(holidayType) && entryEntity.size() == 0) {
            this.getModel().createNewEntryRow("unfixentry");
        }
    }

    private void validNonFixedStartEndTime(PropertyChangedArgs propertyChangedArgs) {
        ChangeData[] changeSet = propertyChangedArgs.getChangeSet();
        if (ObjectUtils.isEmpty((Object)changeSet) || changeSet[0].getRowIndex() < 0) {
            return;
        }
        for (ChangeData changeData : changeSet) {
            int rowIndex = changeData.getRowIndex();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("unfixentry");
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
            Date date = dynamicObject.getDate("ufstartdate");
            if (date == null) {
                return;
            }
            Integer startTime = dynamicObject.getInt("ufstarttime");
            Integer endTime = dynamicObject.getInt("ufendtime");
            if (!ObjectUtils.isNotEmpty((Object)startTime) || !ObjectUtils.isNotEmpty((Object)endTime) || startTime <= endTime) continue;
            String errMsg = ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"HolidayEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
        }
    }

    private void dysetMustInputLog() {
        String holidayType = this.getModel().getDataEntity().getString("holidaytype");
        String fixType = this.getModel().getDataEntity().getString("fixedtype");
        if ("A".equals(holidayType)) {
            SetMustInputLogUtil.setMustInputByTime((String)"fixedtype", (IFormView)this.getView());
            if ("A".equals(fixType)) {
                SetMustInputLogUtil.setMustInputByTime((String)"month", (IFormView)this.getView());
                SetMustInputLogUtil.setMustInputByTime((String)"day", (IFormView)this.getView());
                SetMustInputLogUtil.setMustInputByTime((String)"starttime", (IFormView)this.getView());
                SetMustInputLogUtil.setMustInputByTime((String)"endtime", (IFormView)this.getView());
                this.cleanFixDyData();
            } else if ("B".equals(fixType)) {
                SetMustInputLogUtil.setMustInputByTime((String)"dymonth", (IFormView)this.getView());
                SetMustInputLogUtil.setMustInputByTime((String)"dyday", (IFormView)this.getView());
                SetMustInputLogUtil.setMustInputByTime((String)"week", (IFormView)this.getView());
                SetMustInputLogUtil.setMustInputByTime((String)"dystarttime", (IFormView)this.getView());
                SetMustInputLogUtil.setMustInputByTime((String)"dyendtime", (IFormView)this.getView());
                this.cleanFixStaticData();
            } else {
                this.cleanFixDyData();
                this.cleanFixStaticData();
            }
        }
    }

    private void cleanUfix(String propertyName) {
        if (StringUtils.equals((CharSequence)"holidaytype", (CharSequence)propertyName)) {
            String holidayType = this.getModel().getDataEntity().getString("holidaytype");
            if ("A".equals(holidayType)) {
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.deleteEntryData("unfixentry");
                String fix = this.getModel().getDataEntity().getString("fixedtype");
                if (!"A".equals(fix)) {
                    this.cleanFixStaticData();
                } else {
                    this.cleanFixDyData();
                }
            } else {
                this.getModel().setValue("fixedtype", null);
                this.cleanFixStaticData();
                this.cleanFixDyData();
            }
        }
    }

    private void cleanFixDyData() {
        this.getModel().setValue("dymonth", null);
        this.getModel().setValue("dyday", null);
        this.getModel().setValue("week", null);
        this.getModel().setValue("dystarttime", (Object)0);
        this.getModel().setValue("dyendtime", (Object)0);
    }

    private void cleanFixStaticData() {
        this.getModel().setValue("month", null);
        this.getModel().setValue("day", null);
        this.getModel().setValue("starttime", (Object)0);
        this.getModel().setValue("endtime", (Object)0);
    }

    private void putUfendateStatus(PropertyChangedArgs ec, String propertyName) {
        if (StringUtils.equals((CharSequence)"ufenddate", (CharSequence)propertyName)) {
            ChangeData[] changeSet;
            for (ChangeData changeData : changeSet = ec.getChangeSet()) {
                int rowIndex = changeData.getRowIndex();
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("unfixentry");
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(rowIndex);
                Date date = dynamicObject.getDate("ufenddate");
                Date nowDate = new Date();
                if (date != null && date.before(nowDate)) {
                    this.getModel().setValue("usestatus", (Object)1, rowIndex);
                    continue;
                }
                this.getModel().setValue("usestatus", (Object)0, rowIndex);
            }
        }
    }

    private void putUfendateValue(PropertyChangedArgs ec, String propertyName) {
        if (StringUtils.equals((CharSequence)"ufstartdate", (CharSequence)propertyName)) {
            ChangeData[] changeSet;
            for (ChangeData changeData : changeSet = ec.getChangeSet()) {
                int rowIndex = changeData.getRowIndex();
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("unfixentry");
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(rowIndex);
                Date date = dynamicObject.getDate("ufstartdate");
                if (date == null) {
                    return;
                }
                this.getModel().setValue("ufenddate", (Object)date, rowIndex);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("bar_edit".equals(key)) {
            long id = this.getModel().getDataEntity(false).getLong("id");
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("wtbd_holiday");
            String caption = String.format(ResManager.loadKDString((String)"\u4fee\u6539\u5047\u671f", (String)"HolidayEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), new Object[0]);
            billShowParameter.setCaption(caption);
            billShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            if (this.getView().getParentView() != null) {
                billShowParameter.setParentPageId(this.getView().getParentView().getPageId());
            }
            billShowParameter.setStatus(OperationStatus.EDIT);
            billShowParameter.setPkId((Object)id);
            billShowParameter.setShowTitle(true);
            billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bar_edit"));
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        this.getView().updateView("billlistap");
    }

    static {
        NOCHECKCHANGEDFIELDS.add("starttime");
        NOCHECKCHANGEDFIELDS.add("endtime");
        NOCHECKCHANGEDFIELDS.add("dystarttime");
        NOCHECKCHANGEDFIELDS.add("dyendtime");
    }
}

