/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.hp;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class HpEdit
extends HRDataBaseEdit
implements HyperLinkClickListener {
    private static final Log LOG = LogFactory.getLog(HpEdit.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        EntryGrid entryGrid = (EntryGrid)this.getControl("holidayentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        LOG.info(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u4ee3\u7801={}", (String)"HpEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), (Object)operateKey);
        if (StringUtils.equals((CharSequence)"addholiday", (CharSequence)operateKey)) {
            args.setCancel(true);
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"wtbd_holiday", (boolean)true);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("holidayentity");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            if (!entryEntity.isEmpty()) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (DynamicObject dynamicObject : entryEntity) {
                    long holiday = dynamicObject.getLong("holiday.id");
                    ids.add(holiday);
                }
                qFilters.add(new QFilter("id", "not in", ids));
            }
            listFilterParameter.setQFilters(qFilters);
            listShowParameter.setListFilterParameter(listFilterParameter);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addholiday"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if ("confirmchangenoaudit".equals(operateKey) || "confirmchange".equals(operateKey)) {
            LOG.info(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4={}", (String)"HpEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), (Object)operateKey);
            args.setCancel(!this.checkTime());
        }
    }

    private boolean checkTime() {
        LOG.info(ResManager.loadKDString((String)"\u65f6\u95f4\u6821\u9a8c", (String)"HpEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date startDate = dataEntity.getDate("bsed");
        if (startDate == null) {
            return false;
        }
        int year = HRDateTimeUtils.getYear((Date)startDate);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("holidayentity");
        for (DynamicObject entry : entryEntity) {
            int eyear;
            Date startYear = entry.getDate("startyear");
            Date endYear = entry.getDate("endyear");
            if (startYear == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6709\u6548\u5f00\u59cb\u5e74\u4efd\u201d\u3002", (String)"HpEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (endYear == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6709\u6548\u7ed3\u675f\u5e74\u4efd\u201d\u3002", (String)"HpEdit_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                return false;
            }
            int syear = HRDateTimeUtils.getYear((Date)startYear);
            if (syear > (eyear = HRDateTimeUtils.getYear((Date)endYear))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u7ed3\u675f\u5e74\u4efd\u9700\u5927\u4e8e\u7b49\u4e8e\u6709\u6548\u5f00\u59cb\u5e74\u4efd\u3002", (String)"HpEdit_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (eyear >= year) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u7ed3\u675f\u5e74\u4efd\u9700\u5927\u4e8e\u7b49\u4e8e\u751f\u6548\u5e74\u4efd\u3002", (String)"HpEdit_7", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if ("addholiday".equals(actionId)) {
            if (event.getReturnData() == null) {
                return;
            }
            ListSelectedRowCollection row = (ListSelectedRowCollection)event.getReturnData();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("holidayentity");
            int size = entryEntity.size();
            for (int i = 0; i < row.size(); ++i) {
                Long id = (Long)row.get(i).getPrimaryKeyValue();
                this.getModel().createNewEntryRow("holidayentity");
                this.getModel().setValue("holiday", (Object)id, size);
                ++size;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)1);
        paramMap.put("rowKey", hyperLinkClickEvent.getRowIndex());
        BasedataEdit holiday = (BasedataEdit)this.getControl("holiday");
        holiday.viewDetail((Map)paramMap);
    }
}

