/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.origintime;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class AttendanceStatusConfigEdit
extends HRDataBaseEdit {
    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        super.propertyChanged(args);
        switch (name = args.getProperty().getName()) {
            case "marktype": {
                this.enableControl(args.getChangeSet());
                break;
            }
            case "attbilltag": {
                this.forbiddenRepeat("attbilltag");
                break;
            }
            case "pctag": {
                this.forbiddenRepeat("pctag");
                break;
            }
        }
    }

    private void forbiddenRepeat(String controlKey) {
        QFilter filter;
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList list = Lists.newArrayList();
        ArrayList currentList = Lists.newArrayList();
        for (int i = 0; i < entryEntity.size(); ++i) {
            String value = ((DynamicObject)entryEntity.get(i)).getString(controlKey);
            if (StringUtils.isBlank((CharSequence)value)) continue;
            if (i == currentRowIndex) {
                currentList.addAll(Arrays.stream(value.split(",")).filter(org.apache.commons.lang3.StringUtils::isNotBlank).collect(Collectors.toList()));
                continue;
            }
            list.addAll(Arrays.stream(value.split(",")).filter(org.apache.commons.lang3.StringUtils::isNotBlank).collect(Collectors.toList()));
        }
        if (list.isEmpty() || currentList.isEmpty()) {
            return;
        }
        List containList = currentList.stream().filter(list::contains).collect(Collectors.toList());
        if (containList.isEmpty()) {
            return;
        }
        boolean result = StringUtils.equals((CharSequence)controlKey, (CharSequence)"attbilltag");
        HRBaseServiceHelper helper = new HRBaseServiceHelper(result ? "wtbd_attbilltag" : "wtbd_pctag");
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection(null, new QFilter[]{filter = new QFilter("number", "in", containList)});
        List nameList = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getString("name")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(nameList)) {
            String names = StringUtils.join((Object[])new List[]{nameList});
            this.getView().showErrorNotification(result ? ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6: ", (String)"AttendanceStatusConfigEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u6253\u5361\u6807\u8bc6: %s \u5df2\u88ab\u9009\u62e9", (String)"AttendanceStatusConfigEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), names));
        }
        entryRowEntity.set(controlKey, null);
    }

    private void enableControl(ChangeData[] changeSet) {
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (!Objects.equals(changeData.getNewValue(), changeData.getOldValue())) {
            this.getModel().getEntryRowEntity("entryentity", currentRowIndex).set("pctag", null);
            this.getModel().getEntryRowEntity("entryentity", currentRowIndex).set("attbilltag", null);
        }
        IFormView view = this.getView();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        this.setEnableStatus(entryEntity);
        view.updateView("entryentity");
    }

    public void initialize() {
        IPageCache pageCache = this.getPageCache();
        if (StringUtils.isNotBlank((CharSequence)pageCache.get("shifttbprop"))) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_pctag");
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection(null, null, null);
        ArrayList freePointMarkList = Lists.newArrayList();
        HashMap pcTagMap = Maps.newHashMapWithExpectedSize((int)16);
        dynamicObjects.stream().forEach(dynamicObject -> {
            freePointMarkList.add(new ComboItem(new LocaleString(dynamicObject.getString("name")), dynamicObject.getString("number")));
            pcTagMap.put(dynamicObject.getString("number"), dynamicObject.getLong("id"));
        });
        pageCache.put("pctagidstr", JSON.toJSONString((Object)pcTagMap));
        MulComboEdit mulComboEdit = (MulComboEdit)this.getControl("pctag");
        mulComboEdit.setComboItems((List)freePointMarkList);
        helper = new HRBaseServiceHelper("wtbd_attbilltag");
        dynamicObjects = helper.queryOriginalCollection(null, null, null);
        ArrayList documentIdentityList = Lists.newArrayList();
        HashMap attBillTagMap = Maps.newHashMapWithExpectedSize((int)16);
        dynamicObjects.stream().forEach(dynamicObject -> {
            documentIdentityList.add(new ComboItem(new LocaleString(dynamicObject.getString("name")), dynamicObject.getString("number")));
            attBillTagMap.put(dynamicObject.getString("number"), dynamicObject.getLong("id"));
        });
        pageCache.put("attbilltagidstr", JSON.toJSONString((Object)attBillTagMap));
        MulComboEdit mulComboEdit1 = (MulComboEdit)this.getControl("attbilltag");
        mulComboEdit1.setComboItems((List)documentIdentityList);
        pageCache.put("shifttbprop", "value");
    }

    public void afterBindData(EventObject object) {
        super.afterBindData(object);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        this.setEnableStatus(entryEntity);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    private void setEnableStatus(DynamicObjectCollection entryEntity) {
        IFormView view = this.getView();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            String markType = dynamicObject.getString("marktype");
            boolean result = StringUtils.equals((CharSequence)markType, (CharSequence)"1");
            view.setEnable(Boolean.valueOf(result), i, new String[]{"pctag"});
            view.setEnable(Boolean.valueOf(!result), i, new String[]{"attbilltag"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "save": 
            case "submit": 
            case "audit": 
            case "confirmchange": {
                this.setTagIdStr("pctag", "pctagidstr");
                this.setTagIdStr("attbilltag", "attbilltagidstr");
                break;
            }
        }
    }

    private void setTagIdStr(String numTag, String tag) {
        IPageCache pageCache = this.getPageCache();
        String json = pageCache.get(tag);
        if (HRStringUtils.isEmpty((String)json)) {
            return;
        }
        Map jsonMap = (Map)JSON.parseObject((String)json, Map.class);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Map)jsonMap) || CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        int num = 0;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String[] numArr;
            String propNum = dynamicObject.getString(numTag);
            if (HRStringUtils.isEmpty((String)propNum)) {
                ++num;
                continue;
            }
            for (String number : numArr = propNum.split(",")) {
                Object id;
                if (HRStringUtils.isEmpty((String)number) || (id = jsonMap.get(number)) == null) continue;
                propNum = propNum.replaceAll(number, String.valueOf(id));
            }
            this.getModel().setValue(tag, (Object)propNum, num);
            ++num;
        }
    }
}

