/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.origintime;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.predata.wtbd.PreDataTbpcrel;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class CardPointRelationConfigEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject object) {
        super.registerListener(object);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("tbpcrelid");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData[] changeSet;
        ChangeData changeData;
        super.propertyChanged(args);
        String controlKey = args.getProperty().getName();
        if (StringUtils.equals((CharSequence)controlKey, (CharSequence)"tbpcrelid") || StringUtils.equals((CharSequence)controlKey, (CharSequence)"shifttbprop")) {
            this.forbiddenRepeat();
        } else if (StringUtils.equals((CharSequence)controlKey, (CharSequence)"exceptiontype") && !Objects.equals((changeData = (changeSet = args.getChangeSet())[0]).getNewValue(), changeData.getOldValue())) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("tbpcrelid", null, currentRowIndex);
        }
    }

    private void forbiddenRepeat() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null || entryEntity.size() == 0 || entryEntity.size() == 1) {
            return;
        }
        DynamicObject currentRowEntity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        String currentTimePropertyId = currentRowEntity.getString("shifttbprop");
        String currentTimeCardPointId = currentRowEntity.getString("tbpcrelid.number");
        String exceptionType = currentRowEntity.getString("exceptiontype");
        if (StringUtils.isBlank((CharSequence)currentTimePropertyId) || StringUtils.isBlank((CharSequence)currentTimeCardPointId)) {
            return;
        }
        entryEntity.remove(currentRowIndex);
        HashSet set = Sets.newHashSet();
        for (DynamicObject dynamicObject : entryEntity) {
            String timePropertyId = dynamicObject.getString("shifttbprop");
            String timeCardPointId = dynamicObject.getString("tbpcrelid.number");
            String exceptionType1 = dynamicObject.getString("exceptiontype");
            set.add(timePropertyId + ":" + exceptionType1 + ":" + timeCardPointId);
        }
        if (set.contains(currentTimePropertyId + ":" + exceptionType + ":" + currentTimeCardPointId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u65f6\u6bb5\u5c5e\u6027\u201d\u3001\u201c\u6253\u5361\u5f02\u5e38\u7c7b\u578b\u201d\u3001\u201c\u65f6\u6bb5\u5361\u70b9\u5173\u7cfb\u201d\u7684\u7ec4\u5408\u4e0d\u80fd\u91cd\u590d\u5b9a\u4e49\u3002", (String)"CardPointRelationConfigEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "save": 
            case "submit": 
            case "audit": 
            case "confirmchange": {
                this.setTimeBucketIdStr();
                break;
            }
        }
    }

    private void setTimeBucketIdStr() {
        IPageCache pageCache = this.getPageCache();
        String json = pageCache.get("timebucketidstr");
        if (HRStringUtils.isEmpty((String)json)) {
            return;
        }
        Map timeBucketMap = (Map)JSON.parseObject((String)json, Map.class);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Map)timeBucketMap) || CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        int num = 0;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String[] numArr;
            String propNum = dynamicObject.getString("shifttbprop");
            if (HRStringUtils.isEmpty((String)propNum)) {
                ++num;
                continue;
            }
            for (String number : numArr = propNum.split(",")) {
                Object id;
                if (HRStringUtils.isEmpty((String)number) || (id = timeBucketMap.get(number)) == null) continue;
                propNum = propNum.replaceAll(number, String.valueOf(id));
            }
            this.getModel().setValue("timebucketidstr", (Object)propNum, num);
            ++num;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"newentry")) {
            this.setValueForCombo();
        }
    }

    public void initialize() {
        super.initialize();
        IPageCache pageCache = this.getPageCache();
        if (StringUtils.isNotBlank((CharSequence)pageCache.get("shifttbprop"))) {
            return;
        }
        this.setValueForCombo();
        pageCache.put("shifttbprop", "value");
    }

    private void setValueForCombo() {
        HashMap timeBucketMap = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_shiftperiod");
        QFilter[] qFilters = new QFilter[]{new QFilter("level", "=", (Object)2)};
        DynamicObjectCollection collection = helper.queryOriginalCollection(null, qFilters, null);
        ComboEdit comboEdit = (ComboEdit)this.getControl("shifttbprop");
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            ArrayList<ComboItem> list = new ArrayList<ComboItem>();
            for (DynamicObject dynamicObject : collection) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(dynamicObject.getString("name")));
                comboItem.setValue(dynamicObject.getString("number"));
                timeBucketMap.put(dynamicObject.getString("number"), dynamicObject.getLong("id"));
                list.add(comboItem);
            }
            comboEdit.setComboItems(list);
        }
        IPageCache pageCache = this.getPageCache();
        pageCache.put("timebucketidstr", JSON.toJSONString((Object)timeBucketMap));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter filter;
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        String exceptionType = dynamicObject.getString("exceptiontype");
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (StringUtils.isBlank((CharSequence)exceptionType)) {
            QFilter filter2 = new QFilter("id", "not in", Arrays.asList(PreDataTbpcrel.PD_1010_S, PreDataTbpcrel.PD_1020_S, PreDataTbpcrel.PD_1030_S, PreDataTbpcrel.PD_1040_S, PreDataTbpcrel.PD_1050_S, PreDataTbpcrel.PD_1060_S, PreDataTbpcrel.PD_1070_S, PreDataTbpcrel.PD_1080_S));
            showParameter.getListFilterParameter().setFilter(filter2);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6253\u5361\u5f02\u5e38\u7c7b\u578b\u201d\u3002", (String)"CardPointRelationConfigEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().setEnable(Boolean.TRUE, currentRowIndex, new String[]{"tbpcrelid"});
        switch (exceptionType) {
            case "1": {
                filter = new QFilter("id", "in", Arrays.asList(PreDataTbpcrel.PD_1010_S, PreDataTbpcrel.PD_1020_S, PreDataTbpcrel.PD_1030_S, PreDataTbpcrel.PD_1040_S, PreDataTbpcrel.PD_1080_S));
                break;
            }
            case "2": {
                filter = new QFilter("id", "in", Arrays.asList(PreDataTbpcrel.PD_1020_S, PreDataTbpcrel.PD_1060_S, PreDataTbpcrel.PD_1080_S));
                break;
            }
            case "3": {
                filter = new QFilter("id", "in", Arrays.asList(PreDataTbpcrel.PD_1010_S, PreDataTbpcrel.PD_1050_S, PreDataTbpcrel.PD_1080_S));
                break;
            }
            case "4": {
                filter = new QFilter("id", "in", Arrays.asList(PreDataTbpcrel.PD_1070_S, PreDataTbpcrel.PD_1080_S));
                break;
            }
            default: {
                filter = new QFilter("id", "not in", Arrays.asList(PreDataTbpcrel.PD_1010_S, PreDataTbpcrel.PD_1020_S, PreDataTbpcrel.PD_1030_S, PreDataTbpcrel.PD_1040_S, PreDataTbpcrel.PD_1050_S, PreDataTbpcrel.PD_1060_S, PreDataTbpcrel.PD_1070_S, PreDataTbpcrel.PD_1080_S));
            }
        }
        showParameter.getListFilterParameter().setFilter(filter);
    }
}

