/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.origintime;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;

public class DataSourceConfEdit
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(DataSourceConfEdit.class);
    private static final String APP_ID = AppMetadataCache.getAppInfo((String)"wtp").getId();

    public void beforeBindData(EventObject object) {
        super.beforeBindData(object);
        String conditions = this.getModel().getDataEntity().getString("conditions");
        if (HRStringUtils.isNotEmpty((String)conditions)) {
            this.getTargetCondition().setValueAndUpdateControl(conditions);
        }
        String configway = this.getModel().getDataEntity().getString("configway");
        FieldEdit control = (FieldEdit)this.getControl("customcode");
        if ("1".equals(configway)) {
            control.setMustInput(false);
        } else if ("2".equals(configway)) {
            control.setMustInput(true);
        }
    }

    public void afterBindData(EventObject object) {
        this.provideHisModel();
        this.setFormStatus(this.getFormStatus().getValue());
    }

    private void setFormStatus(int status) {
        TargetCondition targetCondition = this.getTargetCondition();
        if (this.isLock(status, targetCondition.getLock())) {
            targetCondition.setPageState("VIEW");
        } else {
            targetCondition.setPageState("EDIT");
        }
    }

    private boolean isLock(int status, String lock) {
        if (StringUtils.isEmpty((String)lock)) {
            return false;
        }
        return BillOperationStatus.ADDNEW.getValue() == status && lock.contains("new") || BillOperationStatus.EDIT.getValue() == status && lock.contains("edit") || BillOperationStatus.VIEW.getValue() == status && lock.contains("view") || BillOperationStatus.SUBMIT.getValue() == status && lock.contains("submit") || BillOperationStatus.AUDIT.getValue() == status && lock.contains("audit");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (Objects.nonNull(args.getOperationResult()) && args.getOperationResult().isSuccess()) {
            this.setFormStatus(this.getFormStatus().getValue());
        }
    }

    private void provideHisModel() {
        long boid;
        HRBaseServiceHelper serviceHelper;
        DynamicObject dynamicObject;
        String hisAction;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object hasAction = customParams.get("his_action");
        if (hasAction != null && "open_insert_data_page".equals(hisAction = (String)hasAction) && Objects.nonNull(dynamicObject = (serviceHelper = new HRBaseServiceHelper("wtbd_dasoconf")).queryOne("conditions", (Object)(boid = this.getModel().getDataEntity().getLong("boid"))))) {
            this.getTargetCondition().setValueAndUpdateControl(dynamicObject.getString("conditions"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        if (evt.getSource() instanceof AbstractOperate) {
            String operateKey;
            AbstractOperate op = (AbstractOperate)evt.getSource();
            switch (operateKey = op.getOperateKey()) {
                case "save": 
                case "submit": 
                case "submitandaudit": 
                case "confirmchange": 
                case "confirmchangenoaudit": {
                    String configway = this.getModel().getDataEntity().getString("configway");
                    if (!"1".equals(configway)) break;
                    String conditionJson = this.getTargetCondition().getValue();
                    if (Objects.nonNull(conditionJson) && conditionJson.contains("is_or_isSub")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u201c\u7b49\u4e8e/...\u7684\u4e0b\u7ea7\u201d\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u9009\u9879\u3002", (String)"DataSourceConfEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                    boolean isvalidate = DataSourceConfEdit.validCondition(this.getView(), evt, conditionJson);
                    if (!isvalidate) break;
                    this.getModel().setValue("conditions", (Object)conditionJson);
                }
            }
        }
    }

    public static boolean validCondition(IFormView view, BeforeDoOperationEventArgs args, String conditionJson) {
        RuleValidateInfo info = RuleValidateUtil.validCondition((String)conditionJson);
        return DataSourceConfEdit.showErrorNotification(view, args, info);
    }

    private static Boolean getAppParam() {
        AppParam appParam = new AppParam(APP_ID, Long.valueOf(SystemParamQueryUtil.getWTCRootOrg()));
        Map params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        Boolean inShiftOt = (Boolean)params.get("inshiftot");
        return inShiftOt;
    }

    private static boolean showErrorNotification(IFormView view, BeforeDoOperationEventArgs args, RuleValidateInfo info) {
        if (!info.isSuccess()) {
            if (args != null) {
                args.setCancel(true);
                args.setCancelMessage(info.getMsgList().toString());
            }
            view.showErrorNotification(info.getMsgList().toString());
        }
        return info.isSuccess();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"configway")) {
            String configway = this.getModel().getDataEntity().getString("configway");
            FieldEdit control = (FieldEdit)this.getControl("customcode");
            if ("1".equals(configway)) {
                control.setMustInput(false);
            } else if ("2".equals(configway)) {
                control.setMustInput(true);
            }
        }
    }

    private TargetCondition getTargetCondition() {
        return (TargetCondition)this.getControl("targetconditionap");
    }

    private OperationStatus getFormStatus() {
        OperationStatus i;
        String status = this.getModel().getDataEntity().getString("status");
        String fromPage = (String)this.getView().getFormShowParameter().getCustomParams().get("fromPage");
        switch (status) {
            case "A": {
                i = OperationStatus.EDIT;
                break;
            }
            case "B": {
                i = OperationStatus.VIEW;
                break;
            }
            case "C": {
                i = OperationStatus.VIEW;
                break;
            }
            default: {
                i = OperationStatus.ADDNEW;
            }
        }
        if (HRStringUtils.equals((String)fromPage, (String)"revise")) {
            i = OperationStatus.EDIT;
        }
        return i;
    }
}

