/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.origintime;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class ProjectMapEdit
extends HRDataBaseEdit {
    public void initialize() {
        IPageCache pageCache = this.getPageCache();
        String result = pageCache.get("shifttbprop");
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_shiftperiod");
        QFilter[] qFilters = new QFilter[]{new QFilter("level", "=", (Object)2)};
        DynamicObjectCollection collection = helper.queryOriginalCollection(null, qFilters, null);
        ArrayList timeFramePropList = Lists.newArrayList();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        HashMap timeBucketMap = Maps.newHashMapWithExpectedSize((int)16);
        collection.forEach(ele -> {
            timeFramePropList.add(new ComboItem(new LocaleString(ele.getString("name")), ele.getString("number")));
            timeBucketMap.put(ele.getString("number"), ele.getLong("id"));
        });
        MulComboEdit control = (MulComboEdit)this.getControl("shifttbprop");
        control.setComboItems((List)timeFramePropList);
        pageCache.put("timebucketidstr", JSON.toJSONString((Object)timeBucketMap));
        helper = new HRBaseServiceHelper("wtbd_dateproperty");
        collection = helper.queryOriginalCollection(null, null, null);
        ArrayList datePropertyList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        HashMap dateAttrIdMap = Maps.newHashMapWithExpectedSize((int)16);
        collection.forEach(object -> {
            datePropertyList.add(new ComboItem(new LocaleString(String.format(ResManager.loadKDString((String)"%sOFF\u73ed", (String)"ProjectMapEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), object.getString("name"))), object.getString("number") + ":1"));
            datePropertyList.add(new ComboItem(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u975eOFF\u73ed\u3002", (String)"ProjectMapEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), object.getString("name"))), object.getString("number") + ":2"));
            dateAttrIdMap.put(object.getString("number") + ":1", object.getLong("id"));
            dateAttrIdMap.put(object.getString("number") + ":2", object.getLong("id"));
        });
        pageCache.put("dateattridstr", JSON.toJSONString((Object)dateAttrIdMap));
        MulComboEdit dateAttrControl = (MulComboEdit)this.getControl("dateattr");
        dateAttrControl.setComboItems((List)datePropertyList);
        pageCache.put("shifttbprop", "value");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String controlKey = args.getProperty().getName();
        if (StringUtils.equals((CharSequence)controlKey, (CharSequence)"dateattr") || StringUtils.equals((CharSequence)controlKey, (CharSequence)"shifttbprop") || StringUtils.equals((CharSequence)controlKey, (CharSequence)"attstsid")) {
            this.forbiddenRepeat();
        }
    }

    private void forbiddenRepeat() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        if (entryEntity == null || entryEntity.isEmpty() || entryEntity.size() == 1) {
            return;
        }
        String currentDateAttr = entryRowEntity.getString("dateattr");
        String currentTimePropertyId = entryRowEntity.getString("shifttbprop");
        String currentAttendanceStatusId = entryRowEntity.getString("attstsid");
        if (StringUtils.isBlank((CharSequence)currentDateAttr) || StringUtils.isBlank((CharSequence)currentTimePropertyId) || StringUtils.isBlank((CharSequence)currentAttendanceStatusId)) {
            return;
        }
        List<String> currentDateAttrList = this.stringReplaceToList(currentDateAttr);
        List<String> currentTimePropertyIdList = this.stringReplaceToList(currentTimePropertyId);
        Set<String> currentSet = this.calculateAllGroup(currentAttendanceStatusId, currentDateAttrList, currentTimePropertyIdList);
        entryEntity.remove(currentRowIndex);
        HashSet allSet = Sets.newHashSet();
        for (DynamicObject dynamicObject : entryEntity) {
            String dateAttr = dynamicObject.getString("dateattr");
            String timePropertyId = dynamicObject.getString("shifttbprop");
            String attendanceStatusId = dynamicObject.getString("attstsid");
            if (StringUtils.isBlank((CharSequence)dateAttr) || StringUtils.isBlank((CharSequence)timePropertyId) || StringUtils.isBlank((CharSequence)attendanceStatusId)) continue;
            List<String> dateAttrList = this.stringReplaceToList(dateAttr);
            List<String> timePropertyIdList = this.stringReplaceToList(timePropertyId);
            if (dateAttrList == null) continue;
            allSet.addAll(this.calculateAllGroup(attendanceStatusId, dateAttrList, timePropertyIdList));
        }
        allSet.retainAll(currentSet);
        if (allSet.size() > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u5408\u5df2\u5339\u914d\u8003\u52e4\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ProjectMapEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
    }

    private Set<String> calculateAllGroup(String attendanceStatusId, List<String> dateAttrList, List<String> timePropertyIdList) {
        HashSet set = Sets.newHashSet();
        dateAttrList.forEach(dateAttr -> timePropertyIdList.forEach(timePropertyId -> set.add(attendanceStatusId + ":" + dateAttr + ":" + timePropertyId)));
        return set;
    }

    private List<String> stringReplaceToList(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        String[] split = value.split(",");
        return Arrays.stream(split).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "save": 
            case "submit": 
            case "audit": 
            case "confirmchange": {
                this.setTagIdStr("shifttbprop", "timebucketidstr");
                this.setTagIdStr("dateattr", "dateattridstr");
                break;
            }
        }
    }

    private void setTagIdStr(String numTag, String tag) {
        IPageCache pageCache = this.getPageCache();
        String json = pageCache.get(tag);
        if (HRStringUtils.isEmpty((String)json)) {
            return;
        }
        Map jsonMap = (Map)JSON.parseObject((String)json, Map.class);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Map)jsonMap) || CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        int num = 0;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String[] numArr;
            String propNum = dynamicObject.getString(numTag);
            if (HRStringUtils.isEmpty((String)propNum)) {
                ++num;
                continue;
            }
            for (String number : numArr = propNum.split(",")) {
                Object id;
                if (HRStringUtils.isEmpty((String)number) || (id = jsonMap.get(number)) == null) continue;
                propNum = propNum.replaceAll(number.split(":")[0], String.valueOf(id));
            }
            this.getModel().setValue(tag, (Object)propNum, num);
            ++num;
        }
    }
}

