/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.retrieval;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.wtc.wtbd.business.retrieval.RetrievalUtil;
import kd.wtc.wtbd.common.enums.retrieval.AffiliationParamsEnum;
import kd.wtc.wtbd.common.enums.retrieval.ConditionFieldTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.ConditionValueTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.PersonParamsEnum;
import kd.wtc.wtbd.common.enums.retrieval.RuleOperatorEnum;
import kd.wtc.wtbd.common.utils.WTCDateTimeUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class ComboValueInputEdit
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private Map<String, String> comboItemMap = new HashMap<String, String>(0);
    private static final String CACHE_KEY_COMBOITEMMAP = "cache_key_comboitemmap";

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fieldType = (String)formShowParameter.getCustomParam("fieldType");
        String field = (String)formShowParameter.getCustomParam("field");
        String compareType = (String)formShowParameter.getCustomParam("compareType");
        String fetchSource = (String)formShowParameter.getCustomParam("fetchSource");
        String fieldCode = (String)formShowParameter.getCustomParam("fieldCode");
        String compareValue = (String)formShowParameter.getCustomParam("compareValue");
        String compareValueType = (String)formShowParameter.getCustomParam("compareValueType");
        ComboEdit comboEdit = (ComboEdit)this.getControl("combofield");
        MulComboEdit mulComboEdit = (MulComboEdit)this.getControl("mulcombofield");
        List<Object> comboData = new ArrayList(10);
        this.showFieldByFieldType(field, fieldType, compareValue, compareType);
        String value = "";
        if (WTCStringUtils.equals((String)field, (String)"comparetype")) {
            comboData = this.getCompareTypeComboData(fieldType);
            value = compareType;
        } else if (WTCStringUtils.equals((String)field, (String)"comparevaluetype")) {
            comboData = this.getCompareValueTypeComboData(fieldType, compareType);
            value = compareValueType;
        } else if (WTCStringUtils.equals((String)field, (String)"person")) {
            comboData = this.getPersonAffiliationParamsComboData(ConditionValueTypeEnum.TYPE_PERSON.getCode());
            value = compareValue;
        } else if (WTCStringUtils.equals((String)field, (String)"affiliation")) {
            comboData = this.getPersonAffiliationParamsComboData(ConditionValueTypeEnum.TYPE_AFFILIATION.getCode());
            value = compareValue;
        } else if (WTCStringUtils.equals((String)field, (String)"comparevaluetext") && WTCStringUtils.equals((String)fieldType, (String)ConditionFieldTypeEnum.TYPE_ENUM.getCode())) {
            comboData = this.getEnumComboData(fetchSource, fieldCode);
            value = compareValue;
        }
        List<String> multiCompareTypeList = Arrays.asList("in", "not_in");
        if (multiCompareTypeList.contains(compareType) && WTCStringUtils.equals((String)field, (String)"comparevaluetext")) {
            mulComboEdit.setComboItems(comboData);
            value = compareValue.replaceAll(";", ",");
            this.getModel().setValue("mulcombofield", (Object)value);
            this.getView().updateView("mulcombofield");
        } else {
            comboEdit.setComboItems(comboData);
            this.getModel().setValue("combofield", (Object)value);
            this.getView().updateView("combofield");
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String clkKey = control.getKey();
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        if (!BTN_OK.equals(clkKey)) {
            return;
        }
        List<String> multiCompareTypeList = Arrays.asList("in", "not_in");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String from = (String)formShowParameter.getCustomParam("from");
        String fieldType = (String)formShowParameter.getCustomParam("fieldType");
        String field = (String)formShowParameter.getCustomParam("field");
        String compareType = (String)formShowParameter.getCustomParam("compareType");
        Map<String, String> dataMap = this.getCacheComboItemMap();
        String value = this.getValue(field, fieldType, compareType, multiCompareTypeList);
        value = value.replaceAll(",", ";");
        returnData.put("clickStatus", "ok");
        returnData.put("value", value);
        returnData.put("name", ComboValueInputEdit.getDisplayName(dataMap, value, compareType, multiCompareTypeList));
        this.getView().setReturnData(returnData);
        this.getView().close();
    }

    static String getDisplayName(Map<String, String> dataMap, String value, String compareType, List<String> multiCompareTypeList) {
        if (dataMap != null && !WTCStringUtils.isEmpty((String)value)) {
            String displayName;
            if (multiCompareTypeList.contains(compareType)) {
                String[] split = value.split(";");
                StringBuilder sb = new StringBuilder();
                for (String single : split) {
                    if (sb.length() > 0) {
                        sb.append(';');
                    }
                    sb.append(dataMap.get(single));
                }
                displayName = sb.toString();
            } else {
                displayName = dataMap.get(value);
            }
            return displayName;
        }
        return "";
    }

    public void beforeClosed(BeforeClosedEvent event) {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }

    private List<ComboItem> getEnumComboData(String fetchSource, String fieldCode) {
        this.comboItemMap = ComboValueInputEdit.getComboItemMap(fetchSource, fieldCode);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        this.comboItemMap.forEach((key, value) -> list.add(new ComboItem(new LocaleString(value), key)));
        this.cacheComboItemMap();
        return list;
    }

    static Map<String, String> getComboItemMap(String fetchSource, String fieldCode) {
        HashMap<String, String> comboItemMap = new HashMap<String, String>(16);
        MainEntityType entityType = RetrievalUtil.getDataEntityType((String)fetchSource, (String)fieldCode);
        if (entityType == null) {
            return comboItemMap;
        }
        Map propertyMap = entityType.getAllFields();
        if (WTCCollections.isEmpty((Map)propertyMap)) {
            return comboItemMap;
        }
        IDataEntityProperty property = (IDataEntityProperty)propertyMap.get(fieldCode.substring(fieldCode.lastIndexOf(46) + 1));
        if (property instanceof BooleanProp) {
            String falseStr = ResManager.loadKDString((String)"\u5426", (String)"RetrievalComboValueInputEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            String trueStr = ResManager.loadKDString((String)"\u662f", (String)"RetrievalComboValueInputEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
            comboItemMap.put("0", falseStr);
            comboItemMap.put("1", trueStr);
        } else if (property instanceof ComboProp) {
            ComboProp fieldValueCombo = (ComboProp)property;
            List comboItems = fieldValueCombo.getComboItems();
            if (WTCCollections.isEmpty((Collection)comboItems)) {
                return comboItemMap;
            }
            for (ValueMapItem item : comboItems) {
                String value = item.getValue();
                LocaleString name = item.getName();
                comboItemMap.put(value, name.getLocaleValue());
            }
        }
        return comboItemMap;
    }

    private void cacheComboItemMap() {
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        pageCache.put(CACHE_KEY_COMBOITEMMAP, this.comboItemMap);
    }

    private Map<String, String> getCacheComboItemMap() {
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        Map dataMap = (Map)pageCache.get(CACHE_KEY_COMBOITEMMAP, Map.class);
        return dataMap;
    }

    private List<ComboItem> getCompareValueTypeComboData(String fieldType, String compareType) {
        List tempList;
        this.comboItemMap = new HashMap<String, String>(16);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        List valueTypeList1 = ConditionFieldTypeEnum.getValueTypeByCondition((String)compareType);
        List valueTypeList2 = ConditionFieldTypeEnum.getValueTypeByFieldType((String)fieldType);
        if (!(WTCCollections.isEmpty((Collection)valueTypeList1) || WTCCollections.isEmpty((Collection)valueTypeList2) || WTCCollections.isEmpty(tempList = valueTypeList1.stream().filter(single -> valueTypeList2.contains(single)).collect(Collectors.toList())))) {
            for (ConditionValueTypeEnum operatorEnum : tempList) {
                String code = operatorEnum.getCode();
                String desc = operatorEnum.getDesc();
                list.add(new ComboItem(new LocaleString(desc), code));
                this.comboItemMap.put(code, desc);
            }
        }
        this.cacheComboItemMap();
        return list;
    }

    private List<ComboItem> getPersonAffiliationParamsComboData(String type) {
        this.comboItemMap = new HashMap<String, String>(16);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)type)) {
            List personParams = PersonParamsEnum.getPersonParams();
            for (PersonParamsEnum personParamsEnum : personParams) {
                String desc = personParamsEnum.getDesc();
                String code = personParamsEnum.getCode();
                list.add(new ComboItem(new LocaleString(desc), code));
                this.comboItemMap.put(code, desc);
            }
        } else if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_AFFILIATION.getCode(), (String)type)) {
            List affiliationParams = AffiliationParamsEnum.getAffiliationParams();
            for (AffiliationParamsEnum affiliationParamsEnum : affiliationParams) {
                String desc = affiliationParamsEnum.getDesc();
                String code = affiliationParamsEnum.getCode();
                list.add(new ComboItem(new LocaleString(desc), code));
                this.comboItemMap.put(code, desc);
            }
        }
        this.cacheComboItemMap();
        return list;
    }

    private void showFieldByFieldType(String field, String fieldType, String compareValue, String compareType) {
        if (WTCStringUtils.equals((String)field, (String)"comparetype") || WTCStringUtils.equals((String)field, (String)"comparevaluetype")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"textfield", "datefield", "bigintfield", "mulcombofield"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"combofield"});
        } else {
            List<String> multiCompareTypeList = Arrays.asList("in", "not_in");
            String value = WTCStringUtils.isEmpty((String)compareValue) ? "" : compareValue;
            switch (fieldType) {
                case "BigDecimal": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"combofield", "textfield", "datefield", "mulcombofield"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bigintfield"});
                    this.getModel().setValue("bigintfield", (Object)value);
                    break;
                }
                case "Date": {
                    if (WTCStringUtils.equals((String)field, (String)"affiliation")) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"textfield", "datefield", "bigintfield", "mulcombofield"});
                        this.getView().setVisible(Boolean.TRUE, new String[]{"combofield"});
                        break;
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{"combofield", "textfield", "bigintfield", "mulcombofield"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"datefield"});
                    this.getModel().setValue("datefield", (Object)value);
                    break;
                }
                case "String": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"combofield", "datefield", "bigintfield", "mulcombofield"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"textfield"});
                    this.getModel().setValue("textfield", (Object)value);
                    break;
                }
                default: {
                    if (multiCompareTypeList.contains(compareType)) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"textfield", "datefield", "bigintfield", "combofield"});
                        this.getView().setVisible(Boolean.TRUE, new String[]{"mulcombofield"});
                        break;
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{"textfield", "datefield", "bigintfield", "mulcombofield"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"combofield"});
                }
            }
        }
    }

    private String getValue(String field, String fieldType, String compareType, List<String> multiCompareTypeList) {
        String value = "";
        Object combofield = this.getModel().getValue("combofield");
        BigDecimal bigintfield = this.getModel().getDataEntity().getBigDecimal("bigintfield");
        if (WTCStringUtils.equals((String)field, (String)"comparetype") || WTCStringUtils.equals((String)field, (String)"comparevaluetype")) {
            if (combofield != null) {
                value = (String)combofield;
            }
        } else if (WTCStringUtils.equals((String)fieldType, (String)ConditionFieldTypeEnum.TYPE_NUM.getCode())) {
            if (bigintfield != null) {
                value = bigintfield.stripTrailingZeros().toPlainString();
            }
        } else if (WTCStringUtils.equals((String)fieldType, (String)ConditionFieldTypeEnum.TYPE_DATE.getCode()) && !WTCStringUtils.equals((String)field, (String)"affiliation")) {
            Date dateValue = this.getModel().getDataEntity().getDate("datefield");
            if (dateValue != null) {
                value = WTCDateTimeUtils.format((Date)dateValue, (String)"yyyy-MM-dd HH:mm:ss");
            }
        } else if (WTCStringUtils.equals((String)fieldType, (String)ConditionFieldTypeEnum.TYPE_TEXT.getCode())) {
            Object textfield = this.getModel().getValue("textfield");
            if (textfield != null) {
                value = (String)textfield;
            }
        } else if (multiCompareTypeList.contains(compareType)) {
            Object mulcombofield = this.getModel().getValue("mulcombofield");
            if (mulcombofield != null) {
                String mulValue = (String)mulcombofield;
                value = mulValue.substring(1, mulValue.length() - 1);
            }
        } else if (combofield != null) {
            value = (String)combofield;
        }
        return value;
    }

    private List<ComboItem> getCompareTypeComboData(String fieldType) {
        this.comboItemMap = new HashMap<String, String>(16);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        List judgeConditionByType = ConditionFieldTypeEnum.getJudgeConditionByType((String)fieldType);
        if (!WTCCollections.isEmpty((Collection)judgeConditionByType)) {
            for (RuleOperatorEnum operatorEnum : judgeConditionByType) {
                String name = operatorEnum.getName();
                String value = operatorEnum.getValue();
                list.add(new ComboItem(new LocaleString(name), value));
                this.comboItemMap.put(value, name);
            }
        }
        this.cacheComboItemMap();
        return list;
    }
}

