/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.retrieval;

import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class ItemDefineFieldTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener {
    private static final Log log = LogFactory.getLog(ItemDefineFieldTreePlugin.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        TreeView tv = (TreeView)this.getView().getControl("tv_fields");
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        if (!this.isMultiSelected()) {
            tv.setMulti(false);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
            String currNodeId = this.getPageCache().get("nodeids");
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                this.getView().returnDataToParent((Object)currNodeId);
            } else {
                this.getView().returnDataToParent((Object)"");
            }
        }
        this.getView().close();
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String json = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        String cacheNodes = "";
        TreeView treeView = (TreeView)event.getSource();
        List checkedNodeMap = treeView.getTreeState().getSelectedNodes();
        if (checkedNodeMap != null) {
            try {
                cacheNodes = HRJSONUtils.toString((Object)checkedNodeMap);
            }
            catch (IOException e1) {
                log.error((Throwable)e1);
            }
        }
        this.getPageCache().put("nodeids", cacheNodes);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            return;
        }
        this.getPageCache().put("nodeids", nodeId);
    }

    private void fillTreeNodes(String strJson) {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl("tv_fields");
        tree.addNode(rootNode);
        if (this.isMultiSelected()) {
            tree.setMulti(true);
        }
    }

    private boolean isMultiSelected() {
        String isMulti = (String)this.getView().getFormShowParameter().getCustomParam("ismulti");
        if (WTCStringUtils.isEmpty((String)isMulti)) {
            return false;
        }
        return isMulti.equalsIgnoreCase("true") || isMulti.equalsIgnoreCase("1");
    }
}

