/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.retrieval;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.query.QueryEntityParseHelper;
import kd.bos.designer.query.QueryEntityTreeBuildParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.retrieval.DataReaderHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalConfigHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalUtil;
import kd.wtc.wtbd.business.retrieval.service.RetrievalMCConfig;
import kd.wtc.wtbd.common.constants.retrieval.WTCDataTypeEnum;
import kd.wtc.wtbd.common.constants.scenecfg.SceneCfgKDString;
import kd.wtc.wtbd.common.enums.retrieval.AffiliationParamsEnum;
import kd.wtc.wtbd.common.enums.retrieval.ConditionFieldTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.ConditionValueTypeEnum;
import kd.wtc.wtbd.common.enums.retrieval.FetchModeEnum;
import kd.wtc.wtbd.common.enums.retrieval.OutputModeEnum;
import kd.wtc.wtbd.common.enums.retrieval.PersonParamsEnum;
import kd.wtc.wtbd.common.enums.retrieval.RetrievalConditionEntryFieldEnum;
import kd.wtc.wtbd.common.enums.retrieval.RuleOperatorEnum;
import kd.wtc.wtbd.common.utils.WTCObjectUtils;
import kd.wtc.wtbd.common.vo.retrieval.RetrievalItemCheckResultVo;
import kd.wtc.wtbd.fromplugin.web.retrieval.ComboValueInputEdit;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class RetrievalConfigEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(RetrievalConfigEdit.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject args) {
        super.registerListener(args);
        this.addClickListeners(new String[]{"comparevaluetype", "comparetype", "comparevaluetext", "fetchmode", "grouptype"});
        BasedataEdit fetchSource = (BasedataEdit)this.getView().getControl("fetchsource");
        fetchSource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fetchItem = (BasedataEdit)this.getView().getControl("fetchitem");
        fetchItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterLoadData(EventObject args) {
        super.afterLoadData(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "deleterelationentry": {
                this.getPageCache().remove("conditionentryindex");
                break;
            }
            case "movefieldentryup": 
            case "movefieldentrydown": {
                this.updateFieldEntryEnable();
                break;
            }
        }
    }

    private void groupTypeChange() {
        Map comboItemLocaleMap = RetrievalUtil.getComboItemLocaleMap((String)"wtbd_retrievalconfig", (String)"fetchmode");
        String groupType = this.getModel().getDataEntity().getString("grouptype");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(2);
        comboItemList.add(new ComboItem((LocaleString)comboItemLocaleMap.get(FetchModeEnum.DATABASE.getCode()), FetchModeEnum.DATABASE.getCode()));
        if (WTCStringUtils.equals((String)groupType, (String)"1")) {
            comboItemList.add(new ComboItem((LocaleString)comboItemLocaleMap.get(FetchModeEnum.CONTEXT.getCode()), FetchModeEnum.CONTEXT.getCode()));
        } else {
            String fetchMode = this.getModel().getDataEntity().getString("fetchmode");
            if (WTCStringUtils.equals((String)fetchMode, (String)FetchModeEnum.CONTEXT.getCode())) {
                this.getModel().setValue("fetchmode", (Object)FetchModeEnum.DATABASE.getCode());
            }
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("fetchmode");
        comboEdit.setComboItems(comboItemList);
    }

    private void fetchModeChange() {
        Map comboItemLocaleMap = RetrievalUtil.getComboItemLocaleMap((String)"wtbd_retrievalconfig", (String)"outputmode");
        String fetchMode = this.getModel().getDataEntity().getString("fetchmode");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(2);
        comboItemList.add(new ComboItem((LocaleString)comboItemLocaleMap.get(OutputModeEnum.ONE.getCode()), OutputModeEnum.ONE.getCode()));
        if (WTCStringUtils.equals((String)fetchMode, (String)FetchModeEnum.CONTEXT.getCode())) {
            String outputMode = this.getModel().getDataEntity().getString("outputmode");
            if (WTCStringUtils.equals((String)outputMode, (String)OutputModeEnum.MORE.getCode())) {
                this.getModel().setValue("outputmode", (Object)OutputModeEnum.ONE.getCode());
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"datasort"});
        } else {
            comboItemList.add(new ComboItem((LocaleString)comboItemLocaleMap.get(OutputModeEnum.MORE.getCode()), OutputModeEnum.MORE.getCode()));
            this.getView().setVisible(Boolean.TRUE, new String[]{"datasort"});
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("outputmode");
        comboEdit.setComboItems(comboItemList);
    }

    public void afterBindData(EventObject args) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("relationentry");
        this.updateConditionEntryEnable(entryEntity);
        this.groupTypeChange();
        this.fetchModeChange();
        this.updateFieldEntryEnable();
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject args) {
        super.beforeBindData(args);
        boolean isSysPreSet = this.getModel().getDataEntity().getBoolean("issyspreset");
        FormShowParameter form = this.getView().getFormShowParameter();
        if (isSysPreSet) {
            form.setStatus(OperationStatus.VIEW);
        }
        this.setConditionEntryData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        FormOperate operate = (FormOperate)args.getSource();
        switch (opKey = operate.getOperateKey()) {
            case "addfetchfieldentry": {
                this.openFieldTreeAddForm("fetchfieldentry");
                break;
            }
            case "deletefetchfieldentry": {
                this.validateDeleteEntry("fetchfieldentry", opKey);
                args.setCancel(false);
                break;
            }
            case "addrelationentry": {
                this.openFieldTreeAddForm("relationentry");
                break;
            }
            case "deleterelationentry": {
                this.validateDeleteEntry("relationentry", opKey);
                args.setCancel(false);
                break;
            }
            case "adddatasortentry": {
                this.openFieldTreeAddForm("fetchsortentry");
                break;
            }
            case "deletedatasortentry": {
                this.validateDeleteEntry("fetchsortentry", opKey);
                args.setCancel(false);
                break;
            }
            case "save": {
                boolean checkFlag;
                if (!operate.getOption().tryGetVariableValue("save", new RefObject()) && (checkFlag = this.checkFetchItemConfig("save"))) {
                    args.setCancel(true);
                    break;
                }
                DynamicObjectCollection relationEntry = this.getModel().getEntryEntity("relationentry");
                IFormView view = this.getView();
                if (operate.getOption().tryGetVariableValue("checkEntryFlag", new RefObject())) break;
                boolean checkMustFlag = this.checkConditionEntry(relationEntry, view);
                if (checkMustFlag) {
                    args.setCancel(true);
                    break;
                }
                boolean deleteFlag = this.checkFetchItemDeleteOrEdit();
                if (deleteFlag) {
                    args.setCancel(true);
                    break;
                }
                boolean checkTypeFlag = this.checkConditionType(relationEntry);
                if (!checkTypeFlag) break;
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u53d6\u6570\u914d\u7f6e\u7684\u5173\u8054\u4fe1\u606f\u4e2d\u672a\u8bbe\u7f6e\u4eba\u5458\u53c2\u6570\u53ca\u65e5\u671f\u53c2\u6570\uff0c\u5982\u679c\u53d6\u6570\u5b9e\u4f53\u7684\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u53ef\u80fd\u9020\u6210\u53d6\u6570\u5931\u8d25\uff0c\u5efa\u8bae\u68c0\u67e5\u5e76\u4f18\u5316\u3002\u8bf7\u786e\u5b9a\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\uff1f", (String)"RetrievalConfigEdit_29", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                this.openChangeConfirm("", "checkEntryFlag", msg);
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean checkFetchItemDeleteOrEdit() {
        DynamicObject itemDynamicObject;
        Long fetchItem;
        DynamicObject param2;
        int i;
        Map<String, Map<String, String>> propertyMap;
        try {
            this.getPageCache().remove("propertyMapStr");
            propertyMap = this.assemblePropertyMap();
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
            return true;
        }
        Map<String, String> propertyClassMap = propertyMap.get("nameMap");
        Map<String, String> propertyCodeMap = propertyMap.get("codeMap");
        if (propertyClassMap == null) {
            return true;
        }
        DynamicObject queryObj = this.getModel().getDataEntity().getDynamicObject("fetchsource");
        String entityName = queryObj.getString("id");
        String groupType = this.getModel().getDataEntity().getString("grouptype");
        String outputMode = this.getModel().getDataEntity().getString("outputmode");
        DynamicObjectCollection fieldEntry = this.getModel().getEntryEntity("fetchfieldentry");
        DynamicObjectCollection relationEntry = this.getModel().getEntryEntity("relationentry");
        DynamicObjectCollection sortEntry = this.getModel().getEntryEntity("fetchsortentry");
        ArrayList<Long> itemIds = new ArrayList<Long>(10);
        ArrayList<Integer> fieldEntryDeleteList = new ArrayList<Integer>(fieldEntry.size());
        ArrayList<Integer> fieldEntryFieldList = new ArrayList<Integer>(fieldEntry.size());
        ArrayList<Integer> fieldEntryIdTypeList = new ArrayList<Integer>(fieldEntry.size());
        ArrayList<Integer> fieldEntryUpdateList = new ArrayList<Integer>(fieldEntry.size());
        ArrayList<Integer> relationEntryDeleteList = new ArrayList<Integer>(relationEntry.size());
        ArrayList<Integer> relationEntryFieldList = new ArrayList<Integer>(relationEntry.size());
        ArrayList<Integer> relationEntryIdTypeList = new ArrayList<Integer>(relationEntry.size());
        ArrayList<Integer> relationEntryUpdateList = new ArrayList<Integer>(relationEntry.size());
        ArrayList<Integer> sortEntryFieldList = new ArrayList<Integer>(sortEntry.size());
        for (int i2 = 0; i2 < fieldEntry.size(); ++i2) {
            DynamicObject param3 = (DynamicObject)fieldEntry.get(i2);
            Long fetchItem2 = param3.getLong("fetchitem.id");
            if (fetchItem2 != null && fetchItem2 != 0L) {
                itemIds.add(fetchItem2);
                continue;
            }
            fieldEntryDeleteList.add(i2 + 1);
        }
        relationEntry.stream().forEach(param -> {
            Long fetchItem;
            if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)param.getString("valuetype")) && (fetchItem = Long.valueOf(param.getLong("comparevalue"))) != null && fetchItem != 0L) {
                itemIds.add(fetchItem);
            }
        });
        Map<Object, Object> itemMap = new HashMap(itemIds.size());
        if (WTCCollections.isNotEmpty(itemIds)) {
            DynamicObject[] dynamicObjects = RetrievalConfigHelper.selectRetrievalItemList(itemIds);
            itemMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        }
        for (i = 0; i < fieldEntry.size(); ++i) {
            param2 = (DynamicObject)fieldEntry.get(i);
            fetchItem = param2.getLong("fetchitem.id");
            if (!propertyClassMap.containsKey(param2.getString("field"))) {
                fieldEntryFieldList.add(i + 1);
            } else if (this.isIdText(propertyCodeMap, entityName, param2.getString("field"))) {
                fieldEntryIdTypeList.add(i + 1);
            }
            if (fetchItem == null || fetchItem == 0L) continue;
            if (!itemMap.containsKey(fetchItem)) {
                fieldEntryDeleteList.add(i + 1);
                continue;
            }
            itemDynamicObject = (DynamicObject)itemMap.get(fetchItem);
            if (WTCStringUtils.equals((String)"1", (String)itemDynamicObject.getString("way")) && WTCStringUtils.equals((String)groupType, (String)itemDynamicObject.getString("parent.grouptype")) && (!WTCStringUtils.equals((String)OutputModeEnum.ONE.getCode(), (String)outputMode) || RetrievalUtil.getItemTypeList((String)param2.getString("datatype")).contains(itemDynamicObject.getString("type"))) && (!WTCStringUtils.equals((String)OutputModeEnum.MORE.getCode(), (String)outputMode) || "array".equals(itemDynamicObject.getString("type")))) continue;
            fieldEntryUpdateList.add(i + 1);
        }
        for (i = 0; i < relationEntry.size(); ++i) {
            param2 = (DynamicObject)relationEntry.get(i);
            if (!propertyClassMap.containsKey(param2.getString("filterfield"))) {
                relationEntryFieldList.add(i + 1);
            } else if (this.isIdText(propertyCodeMap, entityName, param2.getString("filterfield"))) {
                relationEntryIdTypeList.add(i + 1);
            }
            if (!WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)param2.getString("valuetype")) || (fetchItem = Long.valueOf(param2.getLong("comparevalue"))) == null || fetchItem == 0L) continue;
            if (!itemMap.containsKey(fetchItem)) {
                relationEntryDeleteList.add(i + 1);
                continue;
            }
            itemDynamicObject = (DynamicObject)itemMap.get(fetchItem);
            if (WTCStringUtils.equals((String)"1", (String)itemDynamicObject.getString("way")) && WTCStringUtils.equals((String)groupType, (String)itemDynamicObject.getString("parent.grouptype")) && RetrievalUtil.getItemTypeList((String)param2.getString("filterdatatype")).contains(itemDynamicObject.getString("type"))) continue;
            relationEntryUpdateList.add(i + 1);
        }
        for (i = 0; i < sortEntry.size(); ++i) {
            param2 = (DynamicObject)sortEntry.get(i);
            if (propertyClassMap.containsKey(param2.getString("sortfield"))) continue;
            sortEntryFieldList.add(i + 1);
        }
        StringBuilder content = new StringBuilder();
        if (WTCCollections.isNotEmpty(fieldEntryDeleteList)) {
            Collections.sort(fieldEntryDeleteList);
            content.append(MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u5b57\u6bb5\u7b2c{0}\u884c\u53d6\u6570\u9879\u76ee\u4e3a\u7a7a\u6216\u5df2\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\u3002", (String)"RetrievalConfigEdit_23", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), ((Object)fieldEntryDeleteList).toString()));
            content.append("\r\n");
        }
        if (WTCCollections.isNotEmpty(fieldEntryUpdateList)) {
            content.append(MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u5b57\u6bb5\u7b2c{0}\u884c\u53d6\u6570\u9879\u76ee\u7684\u53d6\u6570\u6765\u6e90/\u7c7b\u522b/\u7c7b\u578b\u5df2\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RetrievalConfigEdit_25", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), ((Object)fieldEntryUpdateList).toString()));
            content.append("\r\n");
        }
        if (WTCCollections.isNotEmpty(fieldEntryFieldList)) {
            content.append(MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u5b57\u6bb5\u7b2c{0}\u884c\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u5df2\u8c03\u6574\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\u3002", (String)"RetrievalConfigEdit_30", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), ((Object)fieldEntryFieldList).toString()));
            content.append("\r\n");
        }
        if (WTCCollections.isNotEmpty(fieldEntryIdTypeList)) {
            content.append(MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u5b57\u6bb5\u7b2c{0}\u884c\u201c\u5b57\u6bb5\u201d\u4e3a\u4e3b\u952e\u7c7b\u578b\uff0c\u4f46\u5b9e\u4e3a\u5b57\u7b26\u4e32\uff0c\u4e0d\u53ef\u4f7f\u7528\uff0c\u8bf7\u5220\u9664\u3002", (String)"RetrievalConfigEdit_37", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), ((Object)fieldEntryIdTypeList).toString()));
            content.append("\r\n");
        }
        if (WTCCollections.isNotEmpty(relationEntryDeleteList)) {
            content.append(MessageFormat.format(ResManager.loadKDString((String)"\u5173\u8054\u4fe1\u606f\u7b2c{0}\u884c\u53d6\u6570\u9879\u76ee\u4e3a\u7a7a\u6216\u5df2\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\u3002", (String)"RetrievalConfigEdit_24", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), ((Object)relationEntryDeleteList).toString()));
            content.append("\r\n");
        }
        if (WTCCollections.isNotEmpty(relationEntryUpdateList)) {
            content.append(MessageFormat.format(ResManager.loadKDString((String)"\u5173\u8054\u4fe1\u606f\u7b2c{0}\u884c\u53d6\u6570\u9879\u76ee\u7684\u53d6\u6570\u6765\u6e90/\u7c7b\u522b/\u7c7b\u578b\u5df2\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RetrievalConfigEdit_26", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), ((Object)relationEntryUpdateList).toString()));
        }
        if (WTCCollections.isNotEmpty(relationEntryFieldList)) {
            content.append(MessageFormat.format(ResManager.loadKDString((String)"\u5173\u8054\u4fe1\u606f\u7b2c{0}\u884c\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u5df2\u8c03\u6574\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\u3002", (String)"RetrievalConfigEdit_31", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), ((Object)relationEntryFieldList).toString()));
            content.append("\r\n");
        }
        if (WTCCollections.isNotEmpty(relationEntryIdTypeList)) {
            content.append(MessageFormat.format(ResManager.loadKDString((String)"\u5173\u8054\u4fe1\u606f\u7b2c{0}\u884c\u201c\u5b57\u6bb5\u201d\u4e3a\u4e3b\u952e\u7c7b\u578b\uff0c\u4f46\u5b9e\u4e3a\u5b57\u7b26\u4e32\uff0c\u4e0d\u53ef\u4f7f\u7528\uff0c\u8bf7\u5220\u9664\u3002", (String)"RetrievalConfigEdit_38", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), ((Object)relationEntryIdTypeList).toString()));
            content.append("\r\n");
        }
        if (WTCCollections.isNotEmpty(sortEntryFieldList)) {
            content.append(MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u6392\u5e8f\u7b2c{0}\u884c\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u5df2\u8c03\u6574\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\u3002", (String)"RetrievalConfigEdit_32", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), ((Object)sortEntryFieldList).toString()));
            content.append("\r\n");
        }
        if (WTCStringUtils.isNotEmpty((String)content.toString())) {
            this.getView().showErrorNotification(content.toString());
            return true;
        }
        return false;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        EntryGrid entryGrid = (EntryGrid)this.getControl("relationentry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        DynamicObjectCollection filterEntry = this.getModel().getEntryEntity("relationentry");
        String caption = "";
        if (WTCStringUtils.equals((String)key, (String)"comparetype")) {
            caption = ResManager.loadKDString((String)"\u5224\u65ad\u6761\u4ef6", (String)"RetrievalConfigEdit_18", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        } else if (WTCStringUtils.equals((String)key, (String)"comparevaluetype")) {
            caption = ResManager.loadKDString((String)"\u6bd4\u8f83\u503c\u7c7b\u578b", (String)"RetrievalConfigEdit_19", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        } else if (WTCStringUtils.equals((String)key, (String)"comparevaluetext")) {
            caption = ResManager.loadKDString((String)"\u6bd4\u8f83\u503c", (String)"RetrievalConfigEdit_20", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
        }
        switch (key) {
            case "filterfieldname": {
                this.getPageCache().put("conditionentryindex", String.valueOf(selectedRows[0]));
                this.openFieldTreeAddForm("relationentry");
                break;
            }
            case "comparetype": 
            case "comparevaluetype": {
                DynamicObject row = (DynamicObject)filterEntry.get(selectedRows[0]);
                if (this.checkConditionField(row, key)) break;
                this.openCompareTypeComboForm(caption, row, key, "", "");
                break;
            }
            case "comparevaluetext": {
                DynamicObject row1 = (DynamicObject)filterEntry.get(selectedRows[0]);
                if (this.checkConditionField(row1, key)) break;
                this.openCompareValueForm(caption, row1, key);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData data;
        String fieldKey = args.getProperty().getName();
        ChangeData changeData = data = WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).isPresent() ? (ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).get() : null;
        if (data == null) {
            return;
        }
        int index = data.getRowIndex();
        DynamicObjectCollection collection = this.getModel().getEntryEntity("fetchfieldentry");
        DynamicObjectCollection collection1 = this.getModel().getEntryEntity("relationentry");
        DynamicObjectCollection collection2 = this.getModel().getEntryEntity("fetchsortentry");
        boolean flag = collection.isEmpty() && collection1.isEmpty() && collection2.isEmpty();
        switch (fieldKey) {
            case "fetchsource": {
                DynamicObject oldObjectType = (DynamicObject)data.getOldValue();
                if (oldObjectType == null || flag) break;
                String msg = ResManager.loadKDString((String)"\u66f4\u6539\u53d6\u6570\u5b9e\u4f53\u540e\uff0c\u5173\u8054\u7684\u201c\u53d6\u6570\u5b57\u6bb5\u201d\u3001\u201c\u5173\u8054\u4fe1\u606f\u201d\u3001\u201c\u53d6\u6570\u6392\u5e8f\u201d\u5c06\u4f1a\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RetrievalConfigEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                this.openChangeConfirm(oldObjectType.getString("id"), "fetchsource", msg);
                break;
            }
            case "grouptype": {
                String groupType = String.valueOf(data.getOldValue());
                if (groupType == null || flag) {
                    this.groupTypeChange();
                    break;
                }
                String msg = ResManager.loadKDString((String)"\u66f4\u6539\u4e86\u201c\u53d6\u6570\u7c7b\u522b\u201d\uff0c\u5173\u8054\u7684\u201c\u53d6\u6570\u5b57\u6bb5\u201d\u3001\u201c\u5173\u8054\u4fe1\u606f\u201d\u3001\u201c\u53d6\u6570\u6392\u5e8f\u201d\u5c06\u4f1a\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RetrievalConfigEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                this.openChangeConfirm(groupType, "grouptype", msg);
                break;
            }
            case "fetchmode": {
                String fetchMode = String.valueOf(data.getOldValue());
                if (fetchMode == null || flag) {
                    this.fetchModeChange();
                    break;
                }
                String msg = ResManager.loadKDString((String)"\u66f4\u6539\u4e86\u201c\u53d6\u6570\u6765\u6e90\u201d\uff0c\u5173\u8054\u7684\u201c\u53d6\u6570\u5b57\u6bb5\u201d\u3001\u201c\u5173\u8054\u4fe1\u606f\u201d\u3001\u201c\u53d6\u6570\u6392\u5e8f\u201d\u5c06\u4f1a\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RetrievalConfigEdit_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                this.openChangeConfirm(fetchMode, "fetchmode", msg);
                break;
            }
            case "outputmode": {
                if (collection.isEmpty()) {
                    this.updateFieldEntryEnable();
                    break;
                }
                String outputMode = String.valueOf(data.getOldValue());
                String msg = ResManager.loadKDString((String)"\u66f4\u6539\u4e86\u201c\u7ed3\u679c\u8f93\u51fa\u65b9\u5f0f\u201d\uff0c\u5173\u8054\u7684\u201c\u53d6\u6570\u5b57\u6bb5\u201d\u5c06\u4f1a\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RetrievalConfigEdit_27", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]);
                this.openChangeConfirm(outputMode, "outputmode", msg);
                break;
            }
            case "comparevaluetype": {
                this.cleanEntryRowData(index, "comparevaluetext", "comparevalue");
                String compareValueType = (String)data.getNewValue();
                if (!WTCStringUtils.isEmpty((String)compareValueType)) break;
                this.getModel().setValue("valuetype", null, index);
                break;
            }
            case "comparetype": {
                String compareType = (String)data.getNewValue();
                if (WTCStringUtils.equals((String)RuleOperatorEnum.IS_NULL.getName(), (String)compareType) || WTCStringUtils.equals((String)RuleOperatorEnum.IS_NOT_NULL.getName(), (String)compareType)) {
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{"comparevaluetype", "valuetype", "comparevaluetext", "comparevalue"});
                    this.cleanEntryRowData(index, "comparevaluetype", "valuetype", "comparevaluetext", "comparevalue");
                } else {
                    this.getView().setEnable(Boolean.TRUE, index, new String[]{"comparevaluetype", "valuetype", "comparevaluetext", "comparevalue"});
                }
                if (WTCStringUtils.isEmpty((String)compareType)) {
                    this.getModel().setValue("condition", null, index);
                }
                this.updateField(index, "condition", "comparevaluetype", "valuetype", "comparevaluetext", "comparevalue");
                break;
            }
            case "fetchitem": {
                this.setFetchItemDataStatus(data, "fetchitem");
                if (index != 0) break;
                this.updateFieldEntryEnable();
                break;
            }
            case "filterfieldname": {
                this.cleanEntryRowData(index, "filterfield", "filterdatatype", "comparetype", "condition", "comparevaluetype", "valuetype", "comparevaluetext", "comparevalue");
                break;
            }
            case "comparevaluetext": {
                Object newValue1 = data.getNewValue();
                if (!WTCStringUtils.isEmpty((String)(newValue1 + ""))) break;
                this.getModel().setValue("comparevalue", null, index);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String oldValue = messageBoxClosedEvent.getCustomVaule();
        switch (callBackId) {
            case "fetchsource": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.getModel().deleteEntryData("fetchfieldentry");
                    this.getModel().deleteEntryData("relationentry");
                    this.getModel().deleteEntryData("fetchsortentry");
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue("fetchsource", (Object)oldValue);
                this.getModel().endInit();
                this.getView().updateView("fetchsource");
                break;
            }
            case "grouptype": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.getModel().deleteEntryData("fetchfieldentry");
                    this.getModel().deleteEntryData("relationentry");
                    this.getModel().deleteEntryData("fetchsortentry");
                    this.groupTypeChange();
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue("grouptype", (Object)oldValue);
                this.getModel().endInit();
                this.getView().updateView("grouptype");
                break;
            }
            case "fetchmode": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.getModel().deleteEntryData("fetchfieldentry");
                    this.getModel().deleteEntryData("relationentry");
                    this.getModel().deleteEntryData("fetchsortentry");
                    this.fetchModeChange();
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue("fetchmode", (Object)oldValue);
                this.getModel().endInit();
                this.getView().updateView("fetchmode");
                break;
            }
            case "outputmode": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.getModel().deleteEntryData("fetchfieldentry");
                    this.updateFieldEntryEnable();
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue("outputmode", (Object)oldValue);
                this.getModel().endInit();
                this.getView().updateView("outputmode");
                break;
            }
            case "deletefetchfieldentry": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.deleteEntry("fetchfieldentry");
                this.updateFieldEntryEnable();
                break;
            }
            case "deleterelationentry": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.deleteEntry("relationentry");
                break;
            }
            case "deletedatasortentry": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.deleteEntry("fetchsortentry");
                break;
            }
            case "fetch_too_many_notify": 
            case "checkEntryFlag": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("save", "false");
                operateOption.setVariableValue("checkEntryFlag", "false");
                this.getView().invokeOperation("save", operateOption);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData)) {
            this.getPageCache().remove("conditionentryindex");
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("relationentry");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        int index = 0;
        if (selectedRows.length > 0) {
            index = selectedRows[0];
        }
        DynamicObjectCollection conditionEntry = this.getModel().getEntryEntity("relationentry");
        String f7Source = this.getPageCache().get("f7source");
        if (WTCStringUtils.equals((String)actionId, (String)f7Source)) {
            ListSelectedRowCollection selected = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (WTCCollections.isEmpty((Collection)selected)) {
                return;
            }
            StringBuilder valueSb = new StringBuilder();
            for (ListSelectedRow rowData : selected) {
                if (valueSb.length() > 0) {
                    valueSb.append(';');
                }
                valueSb.append(rowData.getPrimaryKeyValue());
            }
            this.getModel().setValue("comparevaluetext", (Object)valueSb.toString(), index);
            this.getModel().setValue("comparevalue", (Object)valueSb.toString(), index);
        }
        switch (actionId) {
            case "fetchitem": {
                ListSelectedRowCollection selected = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                int entryIndex = this.getModel().getEntryCurrentRowIndex("fetchfieldentry");
                long fetchItem = (Long)ObjectConverter.convert((Object)(WTCCollectionIndexUtil.getEleFromList((List)selected, (int)0).isPresent() ? ((ListSelectedRow)WTCCollectionIndexUtil.getEleFromList((List)selected, (int)0).get()).getPrimaryKeyValue() : Long.valueOf(0L)), Long.class, (boolean)true);
                this.getModel().beginInit();
                this.getModel().setValue("fetchitem", (Object)fetchItem, entryIndex);
                this.getModel().endInit();
                this.getView().updateView("fetchitem", entryIndex);
                this.getView().updateView("fetchitemttype", entryIndex);
                this.updateFieldEntryEnable();
                break;
            }
            case "fetchfieldentry": {
                this.setQueryFields((String)returnData, "fetchfieldentry", true);
                this.updateFieldEntryEnable();
                break;
            }
            case "relationentry": {
                String rowIndex = this.getPageCache().get("conditionentryindex");
                if (WTCStringUtils.isEmpty((String)rowIndex)) {
                    this.setQueryFields((String)returnData, "relationentry", false);
                }
                this.getPageCache().remove("conditionentryindex");
                break;
            }
            case "fetchsortentry": {
                this.setQueryFields((String)returnData, "fetchsortentry", true);
                break;
            }
            case "wtbd_scenefieldcfg": {
                ListSelectedRowCollection fetchItemFilter = (ListSelectedRowCollection)returnData;
                if (CollectionUtils.isEmpty((Collection)fetchItemFilter)) {
                    return;
                }
                Long itemId = WTCCollectionIndexUtil.getEleFromList((List)fetchItemFilter, (int)0).isPresent() ? ((ListSelectedRow)WTCCollectionIndexUtil.getEleFromList((List)fetchItemFilter, (int)0).get()).getPrimaryKeyValue() : Long.valueOf(0L);
                this.getModel().setValue("comparevaluetext", WTCCollectionIndexUtil.getEleFromList((List)fetchItemFilter, (int)0).isPresent() ? ((ListSelectedRow)WTCCollectionIndexUtil.getEleFromList((List)fetchItemFilter, (int)0).get()).getName() : null, index);
                this.getModel().setValue("comparevalue", (Object)itemId, index);
                this.getView().updateView("comparevaluetext", index);
                this.getView().updateView("comparevalue", index);
                break;
            }
            case "comparetype": 
            case "comparevaluetype": {
                Map data = (Map)returnData;
                String value = (String)data.get("value");
                if (WTCStringUtils.equals((String)actionId, (String)"comparetype")) {
                    if (WTCStringUtils.isEmpty((String)value)) {
                        this.getModel().setValue("comparetype", null, index);
                        this.getModel().setValue("condition", null, index);
                        this.getModel().setValue("comparevaluetype", null, index);
                        this.getModel().setValue("valuetype", null, index);
                        break;
                    }
                    RuleOperatorEnum opEnum = RuleOperatorEnum.getEnum((String)value);
                    if (opEnum != null) {
                        this.getModel().setValue("comparetype", (Object)opEnum.getName(), index);
                        this.getModel().setValue("condition", (Object)opEnum.getValue(), index);
                    }
                } else if (WTCStringUtils.equals((String)actionId, (String)"comparevaluetype")) {
                    if (WTCStringUtils.isEmpty((String)value)) {
                        this.getModel().setValue("comparevaluetype", null, index);
                        this.getModel().setValue("valuetype", null, index);
                        break;
                    }
                    ConditionValueTypeEnum valueTypeEnum = ConditionValueTypeEnum.getEnumByCode((String)value);
                    if (valueTypeEnum != null) {
                        this.getModel().setValue("comparevaluetype", (Object)valueTypeEnum.getDesc(), index);
                        this.getModel().setValue("valuetype", (Object)valueTypeEnum.getCode(), index);
                    }
                }
                this.checkEntryCompareValueType(index, conditionEntry);
                break;
            }
            case "person": 
            case "affiliation": 
            case "enum": 
            case "comparevaluetext": {
                Map map = (Map)returnData;
                if (map == null || map.size() <= 0) break;
                String name = (String)map.get("name");
                String compareValue = (String)map.get("value");
                this.getModel().setValue("comparevaluetext", (Object)(WTCStringUtils.isEmpty((String)name) ? compareValue : name), index);
                this.getModel().setValue("comparevalue", (Object)compareValue, index);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        switch (key = event.getProperty().getName()) {
            case "fetchitem": {
                this.setFetchItemSubjectVF7Filter(event);
                break;
            }
            case "fetchsource": {
                this.setFetchSourcesF7Filter(event);
                break;
            }
        }
    }

    private void checkEntryCompareValueType(int index, DynamicObjectCollection conditionEntry) {
        boolean checkMultiData;
        DynamicObject entryObj = (DynamicObject)conditionEntry.get(index);
        String valueType = entryObj.getString("valuetype");
        String fieldType = entryObj.getString("filterdatatype");
        String compareTypeValue = entryObj.getString("condition");
        String compareValue = entryObj.getString("comparevalue");
        boolean checkFlag = this.checkHasSameCompareValueType(compareTypeValue, valueType, fieldType);
        if (!checkFlag) {
            this.cleanEntryRowData(index, "comparevaluetype", "valuetype", "comparevaluetext", "comparevalue");
        }
        boolean bl = checkMultiData = (WTCStringUtils.equals((String)RuleOperatorEnum.EQUAL.getValue(), (String)compareTypeValue) || WTCStringUtils.equals((String)RuleOperatorEnum.NOT_EQUAL.getValue(), (String)compareTypeValue)) && compareValue.contains(";");
        if (checkMultiData) {
            this.cleanEntryRowData(index, "comparevaluetext", "comparevalue");
        }
    }

    private boolean checkHasSameCompareValueType(String compareType, String valueType, String fieldType) {
        List valueTypeList1 = ConditionFieldTypeEnum.getValueTypeByCondition((String)compareType);
        List valueTypeList2 = ConditionFieldTypeEnum.getValueTypeByFieldType((String)fieldType);
        if (!WTCCollections.isEmpty((Collection)valueTypeList1) && !WTCCollections.isEmpty((Collection)valueTypeList2)) {
            List tempList = valueTypeList1.stream().filter(single -> valueTypeList2.contains(single)).collect(Collectors.toList());
            if (WTCCollections.isEmpty(tempList)) {
                return false;
            }
            for (ConditionValueTypeEnum single2 : tempList) {
                if (!WTCStringUtils.equals((String)single2.getCode(), (String)valueType)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkConditionField(DynamicObject row, String key) {
        String field = row.getString("filterfieldname");
        String compareType = row.getString("comparetype");
        String compareValueType = row.getString("comparevaluetype");
        if (WTCStringUtils.equals((String)key, (String)"comparetype") && WTCStringUtils.isEmpty((String)field)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6761\u4ef6\u5b57\u6bb5\u3002", (String)"RetrievalConfigEdit_16", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (WTCStringUtils.equals((String)key, (String)"comparevaluetype") && WTCStringUtils.isEmpty((String)compareType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5224\u65ad\u6761\u4ef6\u3002", (String)"RetrievalConfigEdit_21", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (WTCStringUtils.equals((String)key, (String)"comparevaluetext") && WTCStringUtils.isEmpty((String)compareValueType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6bd4\u8f83\u503c\u7c7b\u578b\u3002", (String)"RetrievalConfigEdit_22", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void updateField(int index, String ... fields) {
        this.getModel().beginInit();
        for (String field : fields) {
            this.getView().updateView(field, index);
        }
        this.getModel().endInit();
    }

    private void cleanEntryRowData(int index, String ... fields) {
        this.getModel().beginInit();
        for (String field : fields) {
            this.getModel().setValue(field, null, index);
            this.getView().updateView(field, index);
        }
        this.getModel().endInit();
    }

    private void openCompareValueForm(String caption, DynamicObject row, String key) {
        String fieldType = row.getString("filterdatatype");
        String compareValueType = row.getString("valuetype");
        String fetchSource = this.getModel().getDataEntity().getDynamicObject("fetchsource").getString("id");
        String fieldCode = row.getString("filterfield");
        String selectedData = row.getString("comparevalue");
        String compareType = row.getString("condition");
        Map<String, Map<String, String>> propertyMap = this.assemblePropertyMap();
        Map<String, String> sourceMap = propertyMap.get("sourceMap");
        boolean isMultiSelect = ConditionFieldTypeEnum.getMultiSelectByCompareType((String)compareType);
        switch (fieldType) {
            case "Id": {
                if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)compareValueType)) {
                    this.openCompareTypeComboForm(caption, row, "person", fetchSource, fieldCode);
                    break;
                }
                if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)compareValueType)) {
                    this.openSourceFieldF7("wtbd_scenefieldcfg", fieldType, isMultiSelect, selectedData);
                    break;
                }
                if (!WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FIXED.getCode(), (String)compareValueType)) break;
                String f7Source = WTCStringUtils.equals((String)"id", (String)fieldCode) || WTCStringUtils.equals((String)"boid", (String)fieldCode) ? fetchSource : sourceMap.get(fieldCode);
                MainEntityType mainEntity = RetrievalUtil.getDataEntityType((String)f7Source);
                if (mainEntity instanceof QueryEntityType) {
                    f7Source = ((QueryEntityType)mainEntity).getEntityName();
                }
                if (!WTCStringUtils.isNotEmpty((String)f7Source)) break;
                this.getPageCache().put("f7source", f7Source);
                this.openSourceFieldF7(f7Source, fieldType, isMultiSelect, selectedData);
                break;
            }
            case "Enum": {
                if (!WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FIXED.getCode(), (String)compareValueType)) break;
                this.openCompareTypeComboForm(caption, row, key, fetchSource, fieldCode);
                break;
            }
            case "BigDecimal": 
            case "Date": 
            case "String": {
                if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FIXED.getCode(), (String)compareValueType)) {
                    this.openCompareTypeComboForm(caption, row, key, fetchSource, fieldCode);
                    break;
                }
                if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)compareValueType)) {
                    this.openSourceFieldF7("wtbd_scenefieldcfg", fieldType, isMultiSelect, selectedData);
                    break;
                }
                if (!WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_AFFILIATION.getCode(), (String)compareValueType)) break;
                this.openCompareTypeComboForm(caption, row, "affiliation", fetchSource, fieldCode);
                break;
            }
        }
    }

    private void openSourceFieldF7(String entity, String fieldType, boolean isMultiSelect, String selectedData) {
        ArrayList filterList = new ArrayList(1);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entity, (boolean)isMultiSelect, (int)2);
        Optional dataFilterOpl = HRAuthService.getInstance().getF7PermQFilterByDataRule(entity);
        dataFilterOpl.ifPresent(qFilter -> showParameter.getListFilterParameter().getQFilters().add(qFilter));
        if (WTCStringUtils.equals((String)entity, (String)"wtbd_scenefieldcfg")) {
            List fetchItemIdList;
            DynamicObjectCollection filterEntry;
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("type", "in", (Object)RetrievalUtil.getItemTypeList((String)fieldType)));
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            if (WTCStringUtils.equals((String)entity, (String)"wtbd_scenefieldcfg") && !WTCCollections.isEmpty((Collection)(filterEntry = this.getModel().getEntryEntity("fetchfieldentry"))) && !WTCCollections.isEmpty(fetchItemIdList = filterEntry.stream().map(single -> single.getLong("fetchitem.id")).collect(Collectors.toList()))) {
                qFilters.add(new QFilter("id", "not in", fetchItemIdList));
            }
            String groupType = this.getModel().getDataEntity().getString("grouptype");
            qFilters.add(new QFilter("parent.grouptype", "=", (Object)groupType));
            qFilters.add(new QFilter("way", "not in", Arrays.asList("2", "3")));
            qFilters.add(new QFilter("category", "in", (Object)Lists.newArrayList((Object[])new String[]{"1"})));
            qFilters.add(new QFilter("id", "not in", (Object)RetrievalMCConfig.defaultConfig().getHiddenRetrievalItemIds()));
            qFilters.addAll(filterList);
            showParameter.setFormId("bos_listf7");
            showParameter.setCaption(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee", (String)"RetrievalRuleParamPlugin_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        } else if (WTCStringUtils.equals((String)entity, (String)"haos_adminorghr")) {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("iscurrentversion", "=", (Object)true));
        }
        if (WTCStringUtils.isNotEmpty((String)selectedData)) {
            Object[] ids = selectedData.split(";");
            showParameter.setSelectedRows(ids);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entity);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openCompareTypeComboForm(String caption, DynamicObject row, String key, String fetchSource, String fieldCode) {
        String fieldType = row.getString("filterdatatype");
        String compareType = row.getString("condition");
        String compareValue = row.getString("comparevalue");
        String compareValueType = row.getString("valuetype");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(caption);
        showParameter.setFormId("wtbs_combovalueinput");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("fieldType", (Object)fieldType);
        showParameter.setCustomParam("field", (Object)key);
        showParameter.setCustomParam("compareType", (Object)compareType);
        showParameter.setCustomParam("fetchSource", (Object)fetchSource);
        showParameter.setCustomParam("fieldCode", (Object)fieldCode);
        showParameter.setCustomParam("compareValue", (Object)compareValue);
        showParameter.setCustomParam("compareValueType", (Object)compareValueType);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void setFetchItemSubjectVF7Filter(BeforeF7SelectEvent event) {
        DynamicObjectCollection fieldEntry = this.getModel().getEntryEntity("fetchfieldentry");
        DynamicObjectCollection relationEntry = this.getModel().getEntryEntity("relationentry");
        ArrayList<Long> list = new ArrayList<Long>(10);
        fieldEntry.stream().forEach(param -> {
            Long fetchItem = param.getLong("fetchitem.id");
            if (fetchItem != null && fetchItem != 0L && !list.contains(fetchItem)) {
                list.add(fetchItem);
            }
        });
        relationEntry.stream().forEach(param -> {
            Long fetchItem;
            if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)param.getString("valuetype")) && (fetchItem = Long.valueOf(param.getLong("comparevalue"))) != null && fetchItem != 0L && !list.contains(fetchItem)) {
                list.add(fetchItem);
            }
        });
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int focusRow = proxy.getEntryState("fetchfieldentry").getFocusRow();
        FormShowParameter parameter = event.getFormShowParameter();
        ListShowParameter listParameter = (ListShowParameter)parameter;
        QFilter qFilter = this.setFetchItemFilter(focusRow, list, listParameter);
        event.getCustomQFilters().add(qFilter);
        listParameter.setFormId("bos_listf7");
        listParameter.setCaption(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee", (String)"RetrievalRuleParamPlugin_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        listParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fetchitem"));
    }

    private void setFetchSourcesF7Filter(BeforeF7SelectEvent event) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        QFilter qFilter = new QFilter("modeltype", "in", (Object)new String[]{"QueryListModel", "BaseFormModel", "BillFormModel"});
        filterList.add(qFilter);
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        showParameter.getListFilterParameter().setQFilters(filterList);
    }

    private QFilter setFetchItemFilter(int focusRow, List<Long> list, ListShowParameter listParameter) {
        QFilter filter = new QFilter("enable", "in", (Object)"1");
        DynamicObject dy = this.getModel().getEntryRowEntity("fetchfieldentry", focusRow);
        if (dy == null) {
            return filter;
        }
        String outputMode = this.getModel().getDataEntity().getString("outputmode");
        if (WTCStringUtils.equals((String)outputMode, (String)OutputModeEnum.MORE.getCode())) {
            filter.and("type", "=", (Object)"array");
        } else {
            String datatype = dy.getString("datatype");
            filter.and("type", "in", (Object)RetrievalUtil.getItemTypeList((String)datatype));
        }
        long id = dy.getLong("fetchitem.id");
        if (id != 0L) {
            list.remove(id);
        }
        Object enable = this.getView().getModel().getValue("enable");
        long fetchConfigId = 0L;
        if (WTCObjectUtils.equals((Object)enable, (Object)"1")) {
            fetchConfigId = (Long)this.getView().getModel().getValue("id");
        }
        List FetchItemIdList = RetrievalConfigHelper.getRelatedFetchItemIdByFetchConfigId((Long)fetchConfigId);
        FetchItemIdList.addAll(list);
        filter.and("id", "not in", (Object)FetchItemIdList);
        String groupType = this.getModel().getDataEntity().getString("grouptype");
        filter.and("parent.grouptype", "=", (Object)groupType);
        filter.and("way", "not in", Arrays.asList("2", "3"));
        filter.and("category", "in", (Object)Lists.newArrayList((Object[])new String[]{"1"}));
        filter.and("id", "not in", (Object)RetrievalMCConfig.defaultConfig().getHiddenRetrievalItemIds());
        if (id > 0L) {
            listParameter.setSelectedRow((Object)id);
        }
        return filter;
    }

    private void openChangeConfirm(String oldValue, String type, String msg) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(type, (IFormPlugin)this);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, null, oldValue);
    }

    private void openFieldTreeAddForm(String entityId) {
        DynamicObject baseObject = this.getModel().getDataEntity();
        DynamicObject queryObj = (DynamicObject)baseObject.get("fetchsource");
        if (ObjectUtils.isEmpty((Object)queryObj)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d6\u6570\u5b9e\u4f53\u3002", (String)"RetrievalConfigEdit_8", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entityId);
        String fieldName = "field";
        boolean showId = false;
        if (WTCStringUtils.equals((String)entityId, (String)"fetchsortentry")) {
            fieldName = "sortfield";
        } else if (WTCStringUtils.equals((String)entityId, (String)"relationentry")) {
            fieldName = "filterfield";
            showId = true;
        } else if (WTCStringUtils.equals((String)entityId, (String)"fetchfieldentry")) {
            showId = true;
        }
        TreeNode fieldTreeNode = null;
        try {
            fieldTreeNode = this.getTreeNodes(collection, queryObj, fieldName, showId);
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        catch (Exception e) {
            logger.warn("RetrievalConfigEdit.getTreeNodes error ", (Throwable)e);
        }
        if (ObjectUtils.isEmpty((Object)fieldTreeNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u6dfb\u52a0\u5b57\u6bb5\u3002", (String)"RetrievalConfigEdit_7", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return;
        }
        String isMultiSelect = WTCStringUtils.equals((String)"fetchfieldentry", (String)entityId) ? "true" : "false";
        this.showQueryForm(fieldTreeNode, isMultiSelect, entityId);
    }

    boolean isEntryProp(String property) {
        DynamicProperty dynamicProperty;
        DynamicObject baseObject = this.getModel().getDataEntity();
        DynamicObject queryObj = (DynamicObject)baseObject.get("fetchsource");
        String queryPK = queryObj.getString("id");
        MainEntityType mainEntity = RetrievalUtil.getDataEntityType((String)queryPK);
        if (mainEntity instanceof QueryEntityType) {
            mainEntity = RetrievalUtil.getDataEntityType((String)((QueryEntityType)mainEntity).getEntityName());
        }
        return (dynamicProperty = mainEntity.getProperty(property)) instanceof EntryProp;
    }

    private TreeNode getTreeNodes(DynamicObjectCollection collection, DynamicObject queryObj, String fieldName, boolean showId) {
        HashSet<String> fieldIdSet;
        String queryPK = queryObj.getString("id");
        MainEntityType mainEntity = RetrievalUtil.getDataEntityType((String)queryPK);
        if (mainEntity instanceof QueryEntityType) {
            mainEntity = RetrievalUtil.getDataEntityType((String)((QueryEntityType)mainEntity).getEntityName());
        }
        Map propertyMap = DataReaderHelper.getPropertyClassMap((Map)mainEntity.getAllEntities());
        try {
            this.getPageCache().put("propertyMapStr", JSONUtils.toString((Object)propertyMap));
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
        TreeNode parentEntityFieldTreeNode = RetrievalConfigEdit.buildTreeNodesByEntityType(mainEntity, false);
        if (showId) {
            List parentNodeList = parentEntityFieldTreeNode.getChildren();
            for (TreeNode childNode : parentNodeList) {
                this.addIdNode(childNode);
            }
        }
        String rootTablePrefix = parentEntityFieldTreeNode.getId().split("\\.")[0];
        if (!WTCStringUtils.equals((String)fieldName, (String)"filterfield") && !CollectionUtils.isEmpty((Collection)collection)) {
            fieldIdSet = new HashSet(collection.size());
            for (DynamicObject dynamicObject : collection) {
                fieldIdSet.add(rootTablePrefix + "." + dynamicObject.getString(fieldName));
            }
        } else {
            fieldIdSet = new HashSet<String>(0);
        }
        this.filterFields(parentEntityFieldTreeNode, fieldIdSet, (Map)propertyMap.get("codeMap"));
        return parentEntityFieldTreeNode;
    }

    void addIdNode(TreeNode childNode) {
        if (WTCCollections.isEmpty((Collection)childNode.getChildren())) {
            return;
        }
        childNode.setChildren(RetrievalConfigEdit.buildCopyOnWriteTreeNode(childNode.getChildren()));
        if (WTCCollections.isNotEmpty((Collection)childNode.getChildren())) {
            TreeNode idNode;
            TreeNode treeNode = (TreeNode)childNode.getChildren().get(0);
            if (treeNode.getParentid().startsWith("{")) {
                String nodeId = treeNode.getParentid().replace("}", ".id}").trim();
                idNode = new TreeNode(treeNode.getParentid(), nodeId, "id");
            } else {
                idNode = new TreeNode(treeNode.getParentid(), "{" + treeNode.getParentid() + "}", "id");
            }
            childNode.addChild(0, idNode);
            for (TreeNode treeNode1 : childNode.getChildren()) {
                this.addIdNode(treeNode1);
            }
        }
    }

    private static TreeNode buildTreeNodesByEntityType(MainEntityType mainEntityType, boolean showId) {
        QueryEntityTreeBuildParameter parameter = new QueryEntityTreeBuildParameter(mainEntityType);
        parameter.setIncludePKField(showId);
        parameter.setOnlyPhysicsField(false);
        parameter.setDynamicText(true);
        return QueryEntityParseHelper.buildBillTreeNodes((QueryEntityTreeBuildParameter)parameter, (boolean)showId, (String)".id");
    }

    private void filterFields(TreeNode treeNode, Set<String> fieldIdSet, Map<String, String> propertyClassMap) {
        treeNode.setChildren(RetrievalConfigEdit.buildCopyOnWriteTreeNode(treeNode.getChildren()));
        List parentNodeList = treeNode.getChildren();
        String rootTablePrefix = treeNode.getId().split("\\.")[0];
        for (TreeNode childNode : parentNodeList) {
            childNode.setChildren(RetrievalConfigEdit.buildCopyOnWriteTreeNode(childNode.getChildren()));
            for (TreeNode gradeChildNode : childNode.getChildren()) {
                RetrievalConfigEdit.doFilterFields(treeNode, childNode, gradeChildNode, fieldIdSet, rootTablePrefix, propertyClassMap);
            }
            if (CollectionUtils.isEmpty((Collection)childNode.getChildren())) {
                treeNode.deleteChildNode(childNode.getId());
            }
            this.delBranchWithoutLeaf(treeNode, childNode);
        }
    }

    private static List<TreeNode> buildCopyOnWriteTreeNode(List<TreeNode> nodes) {
        return Lists.newCopyOnWriteArrayList(nodes);
    }

    private static void doFilterFields(TreeNode grandParentNode, TreeNode parentNode, TreeNode childNode, Set<String> fieldIdSet, String prefix, Map<String, String> propertyClassMap) {
        if (CollectionUtils.isEmpty((Collection)childNode.getChildren())) {
            String nodeId = childNode.getId().replace('{', ' ').replace('}', ' ').trim();
            if (fieldIdSet.contains(nodeId)) {
                parentNode.deleteChildNode(childNode.getId());
            } else if (propertyClassMap.get(nodeId.substring(nodeId.indexOf(46) + 1)) == null) {
                parentNode.deleteChildNode(childNode.getId());
            }
            if (CollectionUtils.isEmpty((Collection)parentNode.getChildren())) {
                grandParentNode.deleteChildNode(parentNode.getId());
            }
            return;
        }
        childNode.setChildren(RetrievalConfigEdit.buildCopyOnWriteTreeNode(childNode.getChildren()));
        for (TreeNode branchNode : childNode.getChildren()) {
            RetrievalConfigEdit.doFilterFields(parentNode, childNode, branchNode, fieldIdSet, prefix, propertyClassMap);
        }
    }

    private void delBranchWithoutLeaf(TreeNode parentNode, TreeNode node) {
        if (Objects.isNull(node)) {
            return;
        }
        List childNodes = node.getChildren();
        if (Objects.isNull(childNodes)) {
            return;
        }
        for (TreeNode childNoe : childNodes) {
            this.delBranchWithoutLeaf(node, childNoe);
        }
        if (Objects.nonNull(node.getChildren()) && node.getChildren().isEmpty()) {
            parentNode.deleteChildNode(node.getId());
        }
    }

    private void showQueryForm(TreeNode entityFieldTreeNode, String isMultiSelect, String actionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wtbs_field");
        String nodesJson = SerializationUtils.toJsonString((Object)entityFieldTreeNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("ismulti", isMultiSelect);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    boolean checkRelationEntryLevel(String fullFieldName) {
        String[] splitFullFieldName = fullFieldName.split("\\.");
        if (splitFullFieldName.length > 5) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u4fe1\u606f\u5c42\u6b21\u4e0d\u80fd\u8d85\u8fc7\u4e09\u5c42\u3002", (String)"RetrievalConfigEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void setQueryFields(String fields, String actionId, boolean isFilterBaseData) {
        ArrayList<String> fieldList;
        if (WTCStringUtils.isEmpty((String)fields)) {
            return;
        }
        int entryType = this.assembleEntryType(actionId);
        Map<String, Map<String, String>> propertyMap = this.assemblePropertyMap();
        Map<String, String> propertyClassMap = propertyMap.get("codeMap");
        DynamicObjectCollection dyObjs = this.getModel().getEntryEntity(actionId);
        String fieldId = this.assembleFieldId(entryType);
        if (entryType != 1) {
            fieldList = new ArrayList<String>(10);
            for (DynamicObject dyObj : dyObjs) {
                String field = dyObj.getString(fieldId);
                fieldList.add(field);
            }
        } else {
            fieldList = new ArrayList(0);
        }
        DynamicObject object = this.getModel().getDataEntity();
        String queryId = object.getString("fetchsource.id");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        this.initSetterField(entryType, setter);
        int index = 0;
        if (WTCStringUtils.equals((String)"fetchfieldentry", (String)actionId)) {
            boolean flag = this.assembleMultiEntryRowData(fields, queryId, fieldList, isFilterBaseData, entryType, propertyClassMap, setter, index);
            if (flag) {
                return;
            }
        } else {
            String fullFieldName = fields.replace('{', ' ').replace('}', ' ').trim();
            String fieldName = fullFieldName.substring(fullFieldName.indexOf(46) + 1);
            String fieldType = propertyClassMap.get(fieldName);
            if (WTCStringUtils.isNotEmpty((String)fieldType) && !WTCStringUtils.equals((String)"id", (String)fieldName) && WTCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_ID.getCode(), (String)fieldType) && !WTCStringUtils.equals((String)"boid", (String)fieldName)) {
                fullFieldName = fullFieldName + ".id";
            }
            String replace = fieldName.replace(".id", "");
            String[] splitFullFieldName = replace.split("\\.");
            boolean entryProp = this.isEntryProp(splitFullFieldName[0]);
            String fetchMode = this.getModel().getDataEntity().getString("fetchmode");
            if (WTCStringUtils.equals((String)fetchMode, (String)"2") && (entryProp && splitFullFieldName.length > 2 || !entryProp && splitFullFieldName.length > 1)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6570\u6765\u6e90\u4e3a\u4e0a\u4e0b\u6587\u53d6\u6570\u65f6\uff0c\u53ea\u80fd\u9009\u53d6\u4e00\u5c42\u3002", (String)"RetrievalConfigEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                return;
            }
            if (WTCStringUtils.equals((String)"relationentry", (String)actionId) && this.checkRelationEntryLevel(fullFieldName)) {
                return;
            }
            boolean flag = this.assembleSingleEntryRowData(fullFieldName, queryId, fieldList, isFilterBaseData, entryType, propertyClassMap, setter);
            if (flag) {
                return;
            }
        }
        model.batchCreateNewEntryRow(actionId, setter);
        model.endInit();
        this.getView().updateView(actionId);
        if (entryType == 1) {
            dyObjs = this.getModel().getEntryEntity(actionId);
            this.updateConditionEntryEnable(dyObjs);
        }
    }

    private void updateConditionEntryEnable(DynamicObjectCollection dyObjs) {
        for (int i = 0; i < dyObjs.size(); ++i) {
            String compareType = ((DynamicObject)dyObjs.get(i)).getString("comparetype");
            if (!WTCStringUtils.equals((String)RuleOperatorEnum.IS_NULL.getName(), (String)compareType) && !WTCStringUtils.equals((String)RuleOperatorEnum.IS_NOT_NULL.getName(), (String)compareType)) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"comparevaluetype", "valuetype", "comparevaluetext", "comparevalue"});
        }
    }

    private void updateFieldEntryEnable() {
        DynamicObjectCollection fieldEntity = this.getModel().getEntryEntity("fetchfieldentry");
        if (WTCCollections.isEmpty((Collection)fieldEntity)) {
            return;
        }
        String outputMode = this.getModel().getDataEntity().getString("outputmode");
        if (WTCStringUtils.equals((String)outputMode, (String)OutputModeEnum.MORE.getCode())) {
            Object fetchItem = ((DynamicObject)fieldEntity.get(0)).get("fetchitem");
            for (int i = 0; i < fieldEntity.size(); ++i) {
                if (i != 0) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"fetchitem"});
                    this.getModel().setValue("fetchitem", fetchItem, i);
                    continue;
                }
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"fetchitem"});
            }
        } else {
            for (int i = 0; i < fieldEntity.size(); ++i) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"fetchitem"});
            }
        }
    }

    private boolean assembleMultiEntryRowData(String fields, String queryId, List<String> fieldList, boolean isFilterBaseData, int entryType, Map<String, String> propertyClassMap, TableValueSetter setter, int index) {
        JSONArray jsonArr = JSONArray.parseArray((String)fields);
        ArrayList<String> errorList = new ArrayList<String>(10);
        String fetchMode = this.getModel().getDataEntity().getString("fetchmode");
        for (Object obj : jsonArr) {
            JSONObject jsonObj = (JSONObject)obj;
            String fullFieldName = jsonObj.getString("id").replace('{', ' ').replace('}', ' ').trim();
            if (((Boolean)jsonObj.get((Object)"isParent")).booleanValue()) continue;
            String fieldName = fullFieldName.substring(fullFieldName.indexOf(46) + 1);
            String replace = fieldName.replace(".id", "");
            String[] splitFullFieldName = replace.split("\\.");
            boolean entryProp = this.isEntryProp(splitFullFieldName[0]);
            if (WTCStringUtils.equals((String)fetchMode, (String)"2")) {
                Map<String, String> rowMap = this.getRowInfo(fullFieldName, queryId, fieldList, isFilterBaseData);
                if (rowMap == null) continue;
                if (entryProp && splitFullFieldName.length > 2 || !entryProp && splitFullFieldName.length > 1) {
                    errorList.add(rowMap.get("displayName"));
                    continue;
                }
            }
            this.assembleSingleEntryRowData(fullFieldName, queryId, fieldList, isFilterBaseData, entryType, propertyClassMap, setter);
        }
        if (WTCCollections.isNotEmpty(errorList)) {
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u6765\u6e90\u4e3a\u4e0a\u4e0b\u6587\u53d6\u6570\u65f6\uff0c\u53ea\u80fd\u9009\u53d6\u4e00\u5c42\u3002\u4ee5\u4e0b\u8d85\u8fc7\u4e00\u5c42\uff1a{0}", (String)"RetrievalConfigEdit_11", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), ((Object)errorList).toString()));
            return true;
        }
        return false;
    }

    private boolean assembleSingleEntryRowData(String fullFieldName, String queryId, List<String> fieldList, boolean isFilterBaseData, int entryType, Map<String, String> propertyClassMap, TableValueSetter setter) {
        Map<String, String> rowMap = this.getRowInfo(fullFieldName, queryId, fieldList, isFilterBaseData);
        if (rowMap == null) {
            return true;
        }
        String fieldAlias = rowMap.get("fieldAlias");
        String displayName = rowMap.get("displayName");
        if (entryType != 2) {
            String dataType = fieldAlias.endsWith(".id") ? propertyClassMap.get(fieldAlias.substring(0, fieldAlias.length() - 3)) : propertyClassMap.get(fieldAlias);
            if (WTCStringUtils.isEmpty((String)dataType)) {
                return true;
            }
            if (entryType == 1) {
                dataType = RetrievalConfigHelper.getSwitchDataType((String)dataType, (String)"relationentry");
                setter.addRow(new Object[]{fieldAlias, displayName, dataType});
            } else {
                dataType = RetrievalConfigHelper.getSwitchDataType((String)dataType, (String)"fetchfieldentry");
                setter.addRow(new Object[]{fieldAlias, displayName, dataType});
            }
        } else {
            setter.addRow(new Object[]{fieldAlias, displayName});
        }
        return false;
    }

    private void initSetterField(int entryType, TableValueSetter setter) {
        if (entryType == 0) {
            setter.addField("field", new Object[0]);
            setter.addField("fieldname", new Object[0]);
            setter.addField("datatype", new Object[0]);
        } else if (entryType == 1) {
            setter.addField("filterfield", new Object[0]);
            setter.addField("filterfieldname", new Object[0]);
            setter.addField("filterdatatype", new Object[0]);
        } else {
            setter.addField("sortfield", new Object[0]);
            setter.addField("sortfieldname", new Object[0]);
        }
    }

    private String assembleFieldId(int entryType) {
        String fieldId = entryType == 0 ? "field" : (entryType == 1 ? "filterfield" : "sortfield");
        return fieldId;
    }

    private Map<String, Map<String, String>> assemblePropertyMap() {
        Map propertyMap = new HashMap(16);
        try {
            propertyMap = (Map)JSONUtils.cast((String)this.getPageCache().get("propertyMapStr"), Map.class);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
        if (propertyMap.size() == 0) {
            DynamicObject baseObject = this.getModel().getDataEntity();
            DynamicObject queryObj = (DynamicObject)baseObject.get("fetchsource");
            if (queryObj == null) {
                return propertyMap;
            }
            String queryPK = queryObj.getString("id");
            MainEntityType mainEntity = RetrievalUtil.getDataEntityType((String)queryPK);
            propertyMap = DataReaderHelper.getPropertyClassMap((Map)mainEntity.getAllEntities());
        }
        return propertyMap;
    }

    private int assembleEntryType(String actionId) {
        if (WTCStringUtils.equals((String)actionId, (String)"relationentry")) {
            return 1;
        }
        if (WTCStringUtils.equals((String)actionId, (String)"fetchsortentry")) {
            return 2;
        }
        return 0;
    }

    private Map<String, String> getRowInfo(String fullFieldName, String queryId, List<String> fieldList, boolean isFilterBaseData) {
        String fieldAlias;
        String fieldValue;
        String[] fieldName = fullFieldName.split("\\.");
        String entityAlias = null;
        String entityNumber = null;
        String displayName = "";
        if (fieldName.length > 1) {
            entityAlias = fieldName[0];
            entityNumber = fieldName[0];
        }
        String fieldBaseData = "";
        if (fieldName.length == 0) {
            fieldValue = fullFieldName;
        } else if (fieldName.length == 3) {
            fieldBaseData = fieldName[fieldName.length - 2];
            fieldValue = fieldName[fieldName.length - 1];
        } else if (fieldName.length == 4) {
            fieldBaseData = fieldName[fieldName.length - 3];
            fieldValue = fieldName[fieldName.length - 2] + "." + fieldName[fieldName.length - 1];
        } else {
            fieldValue = fieldName[fieldName.length - 1];
        }
        if (fieldValue.toLowerCase().contains("billhead")) {
            return null;
        }
        boolean isMainEntityField = false;
        MainEntityType mainEntity = RetrievalUtil.getDataEntityType((String)queryId);
        if (mainEntity instanceof QueryEntityType) {
            mainEntity = RetrievalUtil.getDataEntityType((String)((QueryEntityType)mainEntity).getEntityName());
        }
        String mainEntityName = mainEntity.getName();
        if (null != entityAlias && entityAlias.equals(mainEntityName)) {
            StringBuilder fieldValues = new StringBuilder(fieldName[1]);
            for (int cunt = 2; cunt < fieldName.length; ++cunt) {
                fieldValues.append('.');
                fieldValues.append(fieldName[cunt]);
            }
            fieldAlias = String.valueOf(fieldValues);
            isMainEntityField = true;
        } else {
            fieldAlias = fullFieldName;
        }
        if (!WTCStringUtils.isEmpty((String)entityNumber)) {
            MainEntityType dataEntityType = RetrievalUtil.getDataEntityType((String)entityNumber);
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            String entityName = dataEntityType.getDisplayName().toString();
            String baseName = "";
            boolean isBaseData = false;
            for (IDataEntityProperty dtProp : properties) {
                if (dtProp.getName().equals(fieldBaseData)) {
                    baseName = dtProp.getDisplayName() != null ? dtProp.getDisplayName().toString() : dtProp.getAlias();
                    displayName = this.findPropertity(fieldValue, dtProp);
                    break;
                }
                if (!dtProp.getName().equals(fieldValue)) continue;
                if (dtProp instanceof BasedataProp) {
                    isBaseData = true;
                }
                if (dtProp.getDisplayName() != null) {
                    displayName = dtProp.getDisplayName().toString();
                    continue;
                }
                displayName = dtProp.getAlias();
            }
            if (isBaseData && isFilterBaseData) {
                return null;
            }
            if (!WTCStringUtils.isEmpty((String)baseName)) {
                displayName = baseName + "." + displayName;
            }
            if (!isMainEntityField) {
                displayName = entityName + "." + displayName;
            }
        }
        if (fieldList.contains(fieldAlias)) {
            return null;
        }
        HashMap<String, String> rowMap = new HashMap<String, String>(2);
        Map<String, Map<String, String>> propertyMap = this.assemblePropertyMap();
        Map<String, String> propertyClassMap = propertyMap.get("nameMap");
        String name = propertyClassMap.get(fieldAlias);
        if (WTCStringUtils.isEmpty((String)name)) {
            return null;
        }
        displayName = name;
        rowMap.put("fieldAlias", fieldAlias);
        rowMap.put("displayName", displayName);
        return rowMap;
    }

    private String findPropertity(String fieldValue, IDataEntityProperty dtProp) {
        MainEntityType bdType2;
        String displayName = "";
        DataEntityPropertyCollection properties = null;
        if (dtProp instanceof BasedataProp) {
            BasedataProp bdProp2 = (BasedataProp)dtProp;
            bdType2 = (MainEntityType)bdProp2.getComplexType();
            properties = bdType2.getProperties();
        } else if (dtProp instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)dtProp;
            IDataEntityType entryEntitytype = entryProp.getItemType();
            properties = entryEntitytype.getProperties();
        }
        if (properties != null) {
            String[] fieldValueArray = fieldValue.split("\\.");
            String baseDataProp = fieldValueArray[0];
            for (IDataEntityProperty baseProp : properties) {
                if (fieldValueArray.length > 1 && baseProp instanceof BasedataProp && baseProp.getName().equals(baseDataProp)) {
                    String baseDataPropVal = fieldValueArray[1];
                    BasedataProp bdProp2 = (BasedataProp)baseProp;
                    bdType2 = (MainEntityType)bdProp2.getComplexType();
                    properties = bdType2.getProperties();
                    for (IDataEntityProperty endBaseProp : properties) {
                        if (!endBaseProp.getName().equals(baseDataPropVal)) continue;
                        displayName = bdProp2.getDisplayName() == null ? bdProp2.getAlias() : bdProp2.getDisplayName().toString();
                        String propDisplayName = endBaseProp.getDisplayName() == null ? endBaseProp.getAlias() : endBaseProp.getDisplayName().toString();
                        displayName = displayName + "." + propDisplayName;
                        return displayName;
                    }
                    continue;
                }
                if (!baseProp.getName().equals(fieldValue)) continue;
                if (baseProp.getDisplayName() != null) {
                    displayName = baseProp.getDisplayName().toString();
                    break;
                }
                displayName = baseProp.getAlias();
                break;
            }
        }
        return displayName;
    }

    private void validateDeleteEntry(String entryId, String calBackId) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] selectRows = proxy.getEntryState(entryId).getSelectedRows();
        if (selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RetrievalConfigEdit_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(calBackId, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"RetrievalConfigEdit_34", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"RetrievalConfigEdit_35", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684{0}\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"RetrievalConfigEdit_36", (String)"wtc-wtbd-formplugin", (Object[])new Object[]{selectRows.length});
        String changeDescStr = this.getModel().getChangeDesc();
        this.getView().showConfirm(msg, changeDescStr, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    private void deleteEntry(String entryId) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryId);
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        this.getModel().deleteEntryRows(entryId, selectedRows);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"RetrievalConfigEdit_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
    }

    private void setConditionEntryData() {
        DynamicObject dynamicObject;
        int index;
        Map<String, Map<String, String>> propertyMap;
        try {
            propertyMap = this.assemblePropertyMap();
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        Map<String, String> propertyClassMap = propertyMap.get("nameMap");
        if (propertyClassMap == null) {
            return;
        }
        DynamicObjectCollection fieldEntryCollection = this.getModel().getEntryEntity("fetchfieldentry");
        DynamicObjectCollection relationCollection = this.getModel().getEntryEntity("relationentry");
        DynamicObjectCollection sortEntryCollection = this.getModel().getEntryEntity("fetchsortentry");
        List fetchItemList = relationCollection.stream().filter(item -> WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)item.getString("valuetype"))).map(param -> param.getLong("comparevalue")).collect(Collectors.toList());
        Map<Object, Object> idNameMap = new HashMap(fetchItemList.size());
        if (WTCCollections.isNotEmpty(fetchItemList)) {
            DynamicObject[] dynamicObjects = RetrievalConfigHelper.selectRetrievalItemList(fetchItemList);
            idNameMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name")));
        }
        this.getModel().beginInit();
        for (index = 0; index < fieldEntryCollection.size(); ++index) {
            dynamicObject = (DynamicObject)fieldEntryCollection.get(index);
            this.getModel().setValue("fieldname", (Object)propertyClassMap.get(dynamicObject.getString("field")), index);
        }
        for (index = 0; index < sortEntryCollection.size(); ++index) {
            dynamicObject = (DynamicObject)sortEntryCollection.get(index);
            this.getModel().setValue("sortfieldname", (Object)propertyClassMap.get(dynamicObject.getString("sortfield")), index);
        }
        for (index = 0; index < relationCollection.size(); ++index) {
            Object compareValue;
            dynamicObject = (DynamicObject)relationCollection.get(index);
            String compareType = dynamicObject.getString("condition");
            String compareTypeName = ConditionFieldTypeEnum.getCompareTypeByValue((String)compareType);
            this.getModel().setValue("comparetype", (Object)compareTypeName, index);
            String valueType = dynamicObject.getString("valuetype");
            String valueTypeName = ConditionValueTypeEnum.getDesc((String)valueType);
            this.getModel().setValue("comparevaluetype", (Object)valueTypeName, index);
            if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)valueType)) {
                compareValue = dynamicObject.getLong("comparevalue");
                String itemName = (String)idNameMap.get(compareValue);
                this.getModel().setValue("comparevaluetext", (Object)itemName, index);
            }
            compareValue = dynamicObject.getString("comparevalue");
            if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)valueType)) {
                this.getModel().setValue("comparevaluetext", (Object)PersonParamsEnum.getDesc((String)compareValue), index);
            }
            if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_AFFILIATION.getCode(), (String)valueType)) {
                this.getModel().setValue("comparevaluetext", (Object)AffiliationParamsEnum.getDesc((String)compareValue), index);
            }
            this.getModel().setValue("filterfieldname", (Object)propertyClassMap.get(dynamicObject.getString("filterfield")), index);
            String dataType = dynamicObject.getString("filterdatatype");
            if (!WTCStringUtils.equals((String)dataType, (String)ConditionFieldTypeEnum.TYPE_ENUM.getCode()) || WTCStringUtils.equals((String)RuleOperatorEnum.IS_NULL.getValue(), (String)compareType) || WTCStringUtils.equals((String)RuleOperatorEnum.IS_NOT_NULL.getValue(), (String)compareType)) continue;
            try {
                Map<String, String> comboItemMap = ComboValueInputEdit.getComboItemMap(this.getModel().getDataEntity().getString("fetchsource.id"), dynamicObject.getString("filterfield"));
                if (comboItemMap != null && comboItemMap.size() > 0) {
                    String displayName = ComboValueInputEdit.getDisplayName(comboItemMap, (String)compareValue, compareType, Arrays.asList("in", "not_in"));
                    this.getModel().setValue("comparevaluetext", (Object)displayName, index);
                    continue;
                }
                this.getModel().setValue("comparevaluetext", (Object)"", index);
                continue;
            }
            catch (KDBizException e) {
                this.getModel().setValue("comparevaluetext", (Object)"", index);
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
        }
        this.getModel().endInit();
    }

    private boolean checkFetchItemConfig(String opType) {
        boolean itemCycle;
        ArrayList<Long> fetchItemIds;
        DynamicObjectCollection relationEntry;
        DynamicObjectCollection calItemMatchEntry;
        IFormView view = this.getView();
        if (this.checkFetchFieldEntry(view, calItemMatchEntry = this.getModel().getEntryEntity("fetchfieldentry"), relationEntry = this.getModel().getEntryEntity("relationentry"), fetchItemIds = new ArrayList<Long>(10))) {
            return true;
        }
        long configId = this.getModel().getDataEntity().getLong("id");
        String configName = this.getModel().getDataEntity().getString("name");
        if (this.checkFetchItemUsed(view, fetchItemIds, configId)) {
            return true;
        }
        ArrayList<String> relationItemIdList = new ArrayList<String>(10);
        for (DynamicObject param : relationEntry) {
            String fetchItemId;
            if (!WTCStringUtils.equals((String)param.getString("valuetype"), (String)ConditionValueTypeEnum.TYPE_FTITEM.getCode()) || WTCStringUtils.isEmpty((String)(fetchItemId = param.getString("comparevalue")))) continue;
            if (fetchItemId.contains(";")) {
                String[] itemsArr = fetchItemId.split(";");
                Collections.addAll(relationItemIdList, itemsArr);
                continue;
            }
            relationItemIdList.add(fetchItemId);
        }
        return !CollectionUtils.isEmpty(relationItemIdList) && (itemCycle = this.checkFetchItemCycle(view, relationItemIdList, configId, configName, fetchItemIds));
    }

    private boolean checkConditionType(DynamicObjectCollection relationEntry) {
        String fetchMode = this.getModel().getDataEntity().getString("fetchmode");
        if (WTCStringUtils.equals((String)FetchModeEnum.DATABASE.getCode(), (String)fetchMode)) {
            boolean personFlag = false;
            boolean affiliationFlag = false;
            for (DynamicObject single : relationEntry) {
                String valueType = single.getString("valuetype");
                if (WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)valueType)) {
                    personFlag = true;
                }
                if (!WTCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_AFFILIATION.getCode(), (String)valueType)) continue;
                affiliationFlag = true;
            }
            if (!personFlag || !affiliationFlag) {
                return true;
            }
        }
        return false;
    }

    private boolean checkConditionEntry(DynamicObjectCollection relationEntry, IFormView view) {
        return this.checkConditionEntryMustInput(view, relationEntry);
    }

    private boolean checkConditionEntryMustInput(IFormView view, DynamicObjectCollection relationEntry) {
        int index = 1;
        ArrayList<String> errMsgList = new ArrayList<String>(10);
        DynamicObjectCollection fieldEntry = this.getModel().getEntryEntity("fetchfieldentry");
        if (WTCCollections.isEmpty((Collection)fieldEntry)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53d6\u6570\u5b57\u6bb5\u201d\u3002", (String)"RetrievalConfigEdit_33", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return true;
        }
        String fetchMode = this.getModel().getDataEntity().getString("fetchmode");
        if (WTCStringUtils.equals((String)FetchModeEnum.DATABASE.getCode(), (String)fetchMode) && WTCCollections.isEmpty((Collection)relationEntry)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5173\u8054\u4fe1\u606f\u201d\u3002", (String)"RetrievalConfigEdit_28", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            return true;
        }
        for (DynamicObject entryObj : relationEntry) {
            String compareType = entryObj.getString("comparetype");
            if (WTCStringUtils.equals((String)RuleOperatorEnum.IS_NULL.getName(), (String)compareType) || WTCStringUtils.equals((String)RuleOperatorEnum.IS_NOT_NULL.getName(), (String)compareType)) {
                ++index;
                continue;
            }
            Map<String, String> entryFieldMap = this.assembleEntryFieldMap(entryObj);
            String errMsg = this.checkIsNull(entryFieldMap, index++);
            if (!WTCStringUtils.isNotEmpty((String)errMsg)) continue;
            errMsgList.add(errMsg);
        }
        if (!WTCCollections.isEmpty(errMsgList)) {
            StringBuilder msgSb = new StringBuilder();
            for (String msg : errMsgList) {
                if (msgSb.length() == 0) {
                    msgSb.append(msg);
                    continue;
                }
                msgSb.append("\r\n").append(msg);
            }
            view.showTipNotification(msgSb.toString());
            return true;
        }
        return false;
    }

    private Map<String, String> assembleEntryFieldMap(DynamicObject entryObj) {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>(16);
        dataMap.put("condition", entryObj.getString("condition"));
        dataMap.put("valuetype", entryObj.getString("valuetype"));
        dataMap.put("comparevalue", entryObj.getString("comparevalue"));
        return dataMap;
    }

    private String checkIsNull(Map<String, String> entryFieldMap, int index) {
        StringBuilder errMsgSb = new StringBuilder();
        for (Map.Entry<String, String> entry : entryFieldMap.entrySet()) {
            if (!WTCStringUtils.isEmpty((String)entry.getValue())) continue;
            if (errMsgSb.length() == 0) {
                errMsgSb.append(RetrievalConditionEntryFieldEnum.getDesc((String)entry.getKey()));
                continue;
            }
            errMsgSb.append('\uff0c').append(RetrievalConditionEntryFieldEnum.getDesc((String)entry.getKey()));
        }
        if (errMsgSb.length() > 0) {
            return MessageFormat.format(ResManager.loadKDString((String)"\u5173\u8054\u4fe1\u606f\u7b2c{0}\u884c\u4ee5\u4e0b\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff1a{1}", (String)"RetrievalConfigEdit_15", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), index, errMsgSb.toString());
        }
        return errMsgSb.toString();
    }

    private boolean checkFetchItemUsed(IFormView view, List<Long> fetchItemIds, long configId) {
        RetrievalItemCheckResultVo retrievalItemCheckResultVo = RetrievalConfigHelper.checkBatchFetchItemEnableByIds(fetchItemIds, (long)configId);
        if (WTCStringUtils.equals((String)"3", (String)retrievalItemCheckResultVo.getResult())) {
            view.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5b58\u5728\u4ee5\u4e0b\u53d6\u6570\u9879\u76ee\u5df2\u7ecf\u88ab\u4f7f\u7528\uff1a{0}\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"RetrievalConfigEdit_13", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), retrievalItemCheckResultVo.getFetchItemList()));
            return true;
        }
        return false;
    }

    private boolean checkFetchItemCycle(IFormView view, List<String> relationItemIdList, long configId, String configName, List<Long> fetchItemIds) {
        RetrievalItemCheckResultVo result = RetrievalConfigHelper.checkFetchConfigItemCycle((long)configId, (String)configName, relationItemIdList, fetchItemIds);
        if (WTCStringUtils.equals((String)"1", (String)result.getResult())) {
            String fetchItemStr = this.assembleFetchItemStr(result.getFetchItemList());
            view.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e{0}\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u914d\u7f6e\uff0c\u5e76\u4fee\u6539\u3002", (String)"RetrievalConfigEdit_11", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), fetchItemStr));
            return true;
        }
        return false;
    }

    private boolean checkFetchFieldEntry(IFormView view, DynamicObjectCollection calItemMatchEntry, DynamicObjectCollection relationEntry, List<Long> fetchItemIds) {
        boolean flag = false;
        String message = "";
        for (DynamicObject dynamicObject : calItemMatchEntry) {
            for (DynamicObject relationObject : relationEntry) {
                long fetchItem = dynamicObject.getLong("fetchitem.id");
                String filterFetchItem = relationObject.getString("comparevalue");
                if (!WTCStringUtils.equals((String)relationObject.getString("comparevaluetype"), (String)ConditionValueTypeEnum.TYPE_FTITEM.getCode()) || !WTCStringUtils.isNotEmpty((String)filterFetchItem) || fetchItem != Long.parseLong(filterFetchItem)) continue;
                message = dynamicObject.getString("comparevaluetext");
                flag = true;
                break;
            }
            if (flag) {
                view.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee:[{0}]\uff0c\u5faa\u73af\u4f9d\u8d56\u7684\u6570\u636e\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"RetrievalConfigEdit_9", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), message));
                return true;
            }
            fetchItemIds.add(dynamicObject.getLong("fetchitem.id"));
        }
        return false;
    }

    private String assembleFetchItemStr(List<String> fetchItemList) {
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty(fetchItemList)) {
            fetchItemList.stream().forEach(item -> sb.append('\u3010').append((String)item).append('\u3011'));
        }
        return sb.toString();
    }

    private void setFetchItemDataStatus(ChangeData data, String fieldMark) {
        int seq = Integer.parseInt(data.getDataEntity().getString("seq")) - 1;
        String filterCheck = this.getView().getPageCache().get(fieldMark + "_filterCheck_" + seq);
        if (!WTCStringUtils.equals((String)filterCheck, (String)"1")) {
            this.getView().getPageCache().put(fieldMark + "_filterCheck_" + seq, "1");
            this.getModel().beginInit();
            if (StringUtils.equals((CharSequence)fieldMark, (CharSequence)"fetchitem")) {
                this.getModel().setValue(fieldMark, data.getNewValue(), seq);
            } else {
                this.getModel().setValue(fieldMark, data.getOldValue(), seq);
            }
            this.getModel().endInit();
        } else {
            this.getView().getPageCache().put(fieldMark + "_filterCheck_" + seq, null);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        if (!WTCGrayscaleUtils.isRetrievalOpen().booleanValue()) {
            args.setCancel(true);
            args.setCancelMessage(SceneCfgKDString.grayscaleStatusIsClosed());
        }
    }

    private boolean isIdText(Map<String, String> propertyCodeMap, String entityName, String keyPath) {
        String dataType = keyPath.endsWith(".id") ? propertyCodeMap.get(keyPath.substring(0, keyPath.length() - 3)) : propertyCodeMap.get(keyPath);
        if (!WTCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_ID.getCode(), (String)dataType)) {
            return false;
        }
        return WTCDataTypeEnum.TEXT == RetrievalUtil.getTypePropertyDataTypeByPath((String)entityName, (String)keyPath);
    }
}

