/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.retrieval;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.retrieval.service.RetrievalMCConfig;
import kd.wtc.wtbd.common.constants.scenecfg.SceneCfgKDString;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class RetrievalGroupEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[a-zA-Z0-9_]+$");
    private HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtbd_retrievalgroup");

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.groupTypeChange();
        this.setEnable();
        this.getModel().setDataChanged(false);
    }

    public void afterCopyData(EventObject event) {
        super.afterCopyData(event);
        String groupType = this.getModel().getDataEntity().getString("grouptype");
        if (HRStringUtils.equals((String)"3", (String)groupType)) {
            this.getModel().getDataEntity().set("grouptype", null);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        if (!WTCGrayscaleUtils.isRetrievalOpen().booleanValue()) {
            args.setCancel(true);
            args.setCancelMessage(SceneCfgKDString.grayscaleStatusIsClosed());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if (WTCStringUtils.equals((String)dataEntity.getString("parent.category"), (String)"1")) {
                this.getView().showTipNotification(SceneCfgKDString.isFiledItem());
                args.setCancel(true);
                return;
            }
            String objType = dataEntity.getString("parent.grouptype");
            if ("3".equals(objType)) {
                this.getView().showTipNotification(SceneCfgKDString.isAttItem());
                args.setCancel(true);
                return;
            }
            if (objType != null && !WTCStringUtils.equals((String)dataEntity.getString("grouptype"), (String)objType)) {
                this.getView().showTipNotification(SceneCfgKDString.groupTypeDiff());
                args.setCancel(true);
                return;
            }
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit parent = (BasedataEdit)this.getControl("parent");
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String objType = dataEntity.getString("parent.grouptype");
        if (WTCStringUtils.isNotEmpty((String)objType)) {
            this.getModel().setValue("grouptype", (Object)objType);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        if (propName.equals("parent")) {
            Object newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).get()).getNewValue() : null;
            DynamicObject parentDy = (DynamicObject)newValue;
            if (parentDy != null) {
                this.getModel().setValue("grouptype", (Object)parentDy.getString("grouptype"));
            }
        } else if (propName.equals("grouptype")) {
            this.groupTypeChange();
            String objType = this.getModel().getDataEntity().getString("parent.grouptype");
            if (objType != null && !WTCStringUtils.equals((String)this.getModel().getDataEntity().getString("grouptype"), (String)objType)) {
                this.getView().showTipNotification(SceneCfgKDString.groupTypeDiff());
                return;
            }
        } else if (propName.equals("numberx")) {
            String number = this.getModel().getDataEntity().getString("numberx");
            if (HRStringUtils.isNotEmpty((String)number) && !this.validateParamCode(number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4ec5\u652f\u6301\u8f93\u5165\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u8bf7\u8c03\u6574\u3002", (String)"RetrievalItemEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("numberx", null);
                this.getView().updateView("numberx");
                return;
            }
            this.getModel().setValue("number", (Object)this.getModel().getDataEntity().getString("numberx"));
        }
    }

    private boolean validateParamCode(String number) {
        Matcher matcher = NUMBER_PATTERN.matcher(number);
        return matcher.matches();
    }

    private void setEnable() {
        QFilter qFilter;
        DynamicObject[] dynamicObjects;
        long pkValue = this.getModel().getDataEntity().getLong("id");
        if (pkValue != 0L && (dynamicObjects = this.serviceHelper.queryOriginalArray("id", (qFilter = new QFilter("parent", "=", (Object)pkValue)).toArray())).length > 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "numberx", "grouptype", "calctype", "parent", "index", "description"});
        }
    }

    private void groupTypeChange() {
        String groupType = this.getModel().getDataEntity().getString("grouptype");
        if (HRStringUtils.equals((String)"2", (String)groupType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"calctype"});
            ((MulComboEdit)this.getControl("calctype")).setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"calctype"});
            ((MulComboEdit)this.getControl("calctype")).setMustInput(false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if ("parent".equals(propName)) {
            QFilter filters = new QFilter("category", "in", (Object)Lists.newArrayList((Object[])new String[]{"2", "3"}));
            filters.and("grouptype", "!=", (Object)"3");
            filters.and("id", "not in", (Object)RetrievalMCConfig.defaultConfig().getHiddenRetrievalGroupIds());
            long pkValue = this.getModel().getDataEntity().getLong("id");
            String groupType = this.getModel().getDataEntity().getString("grouptype");
            if (pkValue != 0L) {
                QFilter qFilter = new QFilter("parent", "=", (Object)pkValue);
                qFilter.and("category", "in", (Object)Lists.newArrayList((Object[])new String[]{"2", "3"}));
                qFilter.or("id", "=", (Object)pkValue);
                DynamicObjectCollection dynamicObjects = this.serviceHelper.queryOriginalCollection("id", qFilter.toArray());
                Set collect = dynamicObjects.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
                filters.and("id", "not in", collect);
            }
            if (WTCStringUtils.isNotEmpty((String)groupType)) {
                filters.and("grouptype", "=", (Object)groupType);
            }
            beforeF7SelectEvent.getCustomQFilters().add(filters);
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(filters);
            listShowParameter.getTreeFilterParameter().setQFilters(qFilters);
            listShowParameter.setFormId("bos_listf7");
        }
    }
}

