/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.retrieval;

import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbd.business.retrieval.service.RetrievalMCConfig;
import kd.wtc.wtbd.common.constants.scenecfg.SceneCfgKDString;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class RetrievalGroupList
extends StandardTreeListPlugin {
    private HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtbd_retrievalgroup");

    public void refreshNode(RefreshNodeEvent refreshNodeEvent) {
        TreeListModel treeModel = (TreeListModel)this.getTreeModel();
        treeModel.getQueryParas().put("order", "level asc,index asc,createtime desc");
        super.refreshNode(refreshNodeEvent);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (WTCStringUtils.equals((String)"delete", (String)operateKey)) {
            args.setListSelectedData(operate.getListSelectedData());
        }
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (!showParameter.isLookUp()) {
            QFilter itemGroupQFilter = new QFilter("category", "in", (Object)Lists.newArrayList((Object[])new String[]{"2", "3"}));
            itemGroupQFilter.and("id", "not in", (Object)RetrievalMCConfig.defaultConfig().getHiddenRetrievalGroupIds());
            evt.getCustomQFilters().add(itemGroupQFilter);
        }
        evt.setOrderBy("modifytime desc,numberx asc");
    }

    public void setCustomerParam() {
        super.setCustomerParam();
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (!showParameter.isLookUp()) {
            List treeFilters = this.getTreeModel().getTreeFilter();
            QFilter itemGroupQFilter = new QFilter("category", "in", (Object)Lists.newArrayList((Object[])new String[]{"2", "3"}));
            itemGroupQFilter.and("id", "not in", (Object)RetrievalMCConfig.defaultConfig().getHiddenRetrievalGroupIds());
            treeFilters.add(itemGroupQFilter);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent evt) {
        DynamicObject dynamicObject;
        super.beforeShowBill(evt);
        Long pkId = (Long)evt.getParameter().getPkId();
        if (pkId == null) {
            DynamicObject dynamicObject2;
            String objType;
            String rootId = this.getTreeModel().getRoot().getId();
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            if (!WTCStringUtils.equals((String)currentNodeId.toString(), (String)rootId) && "3".equals(objType = (dynamicObject2 = this.serviceHelper.queryOriginalOne("id,grouptype", (Object)Long.parseLong((String)currentNodeId))).getString("grouptype"))) {
                this.getView().showTipNotification(SceneCfgKDString.isAttItem());
                evt.setCancel(true);
            }
        }
        if (pkId != null && (dynamicObject = this.serviceHelper.queryOriginalOne("id,issyspreset", (Object)pkId)) != null) {
            boolean isSysPreset = dynamicObject.getBoolean("issyspreset");
            Boolean isCopy = (Boolean)evt.getParameter().getCustomParam("iscopy");
            if (isSysPreset && (isCopy == null || !isCopy.booleanValue())) {
                evt.getParameter().setStatus(OperationStatus.VIEW);
                evt.getParameter().setBillStatus(BillOperationStatus.VIEW);
            }
        }
        BillShowParameter parameter = evt.getParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        if (!WTCGrayscaleUtils.isRetrievalOpen().booleanValue()) {
            args.setCancel(true);
            args.setCancelMessage(SceneCfgKDString.grayscaleStatusIsClosed());
        }
    }
}

