/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.retrieval;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.retrieval.RetrievalConfigHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalItemHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalUtil;
import kd.wtc.wtbd.business.retrieval.service.RetrievalMCConfig;
import kd.wtc.wtbd.common.constants.retrieval.RetrievalItemConstants;
import kd.wtc.wtbd.common.constants.scenecfg.SceneCfgKDString;
import kd.wtc.wtbd.common.enums.EnumInfo;
import kd.wtc.wtbs.business.util.BaseDataUtils;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class RetrievalItemEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
RetrievalItemConstants {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[a-zA-Z0-9_]+$");
    private static final Pattern UNICODE_PATTERN = Pattern.compile("^[a-zA-Z0-9_$]+$");

    public void afterCopyData(EventObject event) {
        super.afterCopyData(event);
        this.clearPresetData();
        this.parentChange();
        this.typeChange();
        this.wayChange(false);
        this.getModel().setValue("uniquecode", null);
        this.getModel().setValue("config", null);
        this.getModel().setValue("multiple", null);
        this.getModel().setValue("dateformat", null);
        this.getModel().setValue("combofield", null);
        this.getModel().setValue("sourcetag", (Object)"1");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject belongObjDy = dataEntity.getDynamicObject("belongobj");
        if (belongObjDy != null) {
            String belongObjId = belongObjDy.getString("id");
            String fieldNumber = (String)this.getView().getFormShowParameter().getCustomParam("retrievalItemFieldNumber");
            this.setFieldComboItem(belongObjId, fieldNumber);
            this.getModel().setValue("number", (Object)fieldNumber);
            this.getModel().setValue("fieldlist", (Object)fieldNumber);
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        String isUpgradeSuccessStr = (String)this.getView().getFormShowParameter().getCustomParam("isUpgradeSuccess");
        boolean isUpgradeSuccess = HRStringUtils.equals((String)"true", (String)isUpgradeSuccessStr);
        this.getView().setEnable(Boolean.valueOf(isUpgradeSuccess), new String[]{"btnsave"});
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject groupDy = dataEntity.getDynamicObject("parent");
        dataEntity.set("parentf7", (Object)groupDy);
        this.getView().updateView("parentf7");
        this.parentChange();
        this.typeChange();
        this.wayChange(false);
        String assignType = this.getModel().getDataEntity().getString("assigntype");
        if (HRStringUtils.isEmpty((String)assignType)) {
            this.getModel().getDataEntity().set("assigntype", (Object)"1");
        }
        this.assignTypeChange();
        this.checkRef(dataEntity, dataEntity.getPkValue());
        boolean hasComboField = this.setComboField();
        this.getView().setVisible(Boolean.valueOf(hasComboField), new String[]{"comboap"});
        if (!HRStringUtils.equals((String)"0", (String)String.valueOf(dataEntity.getPkValue())) && Objects.isNull(this.getModel().getValue("belongobj")) && WTCStringUtils.equals((String)"2", (String)dataEntity.getString("sourcetag"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"belongobj", "fieldlist"});
            ((BasedataEdit)this.getControl("belongobj")).setMustInput(false);
            ((ComboEdit)this.getControl("fieldlist")).setMustInput(false);
            this.getPageCache().put("CACHE_FROM_SCENE", "true");
        }
        this.getModel().setDataChanged(false);
    }

    private void checkRef(DynamicObject dataEntity, Object id) {
        Map queryUsedItemConfigMap;
        BaseDataCheckRefrenceResult refResult;
        if (HRStringUtils.equals((String)"0", (String)String.valueOf(id))) {
            return;
        }
        boolean isRef = false;
        Map referenceMap = BaseDataUtils.existReferences((String)"wtbd_scenefieldcfg", (Object[])new Object[]{id});
        if (null != referenceMap && referenceMap.containsKey(id) && (refResult = (BaseDataCheckRefrenceResult)referenceMap.get(id)) != null && refResult.isRefence()) {
            isRef = true;
        }
        if (!isRef && (queryUsedItemConfigMap = RetrievalConfigHelper.queryUsedItemConfigMap(Stream.of(String.valueOf(id)).collect(Collectors.toSet()))).containsKey(String.valueOf(id))) {
            isRef = true;
        }
        if (!isRef && HRStringUtils.isNotEmpty((String)dataEntity.getString("uniquecode"))) {
            HashMap<Long, String> idToUnicodeMap = new HashMap<Long, String>(1);
            idToUnicodeMap.put(dataEntity.getLong("id"), dataEntity.getString("uniquecode"));
            Map unicodeToFormulaSetNameMap = RetrievalItemHelper.checkUsedByFormula(idToUnicodeMap);
            if (unicodeToFormulaSetNameMap.containsKey(dataEntity.getLong("id"))) {
                isRef = true;
            }
        }
        if (isRef) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"numberx", "parentf7", "way", "type", "belongobj", "fieldlist", "scale", "tailprocessing", "uniquecode", "description", "assigntype", "applyorg"});
        }
    }

    public void afterLoadData(EventObject evt) {
        super.afterLoadData(evt);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject belongObjDy = dataEntity.getDynamicObject("belongobj");
        if (belongObjDy != null) {
            String belongObjId = belongObjDy.getString("id");
            String number = dataEntity.getString("number");
            this.setFieldComboItem(belongObjId, number);
            this.getModel().setValue("fieldlist", (Object)number);
            this.getModel().setDataChanged(false);
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit parentEdit = (BasedataEdit)this.getControl("parentf7");
        parentEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        BasedataEdit edit = (BasedataEdit)event.getSource();
        String key = edit.getKey();
        if (HRStringUtils.equals((String)"parentf7", (String)key)) {
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            QFilter qFilter = new QFilter("category", "in", Stream.of("2", "3").collect(Collectors.toList()));
            qFilter.and(new QFilter("grouptype", "in", Stream.of("1", "2").collect(Collectors.toList())));
            qFilter.and(new QFilter("id", "not in", (Object)RetrievalMCConfig.defaultConfig().getHiddenRetrievalGroupIds()));
            qFilter.and(new QFilter("issyspreset", "=", (Object)Boolean.FALSE));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            event.getCustomQFilters().add(qFilter);
            listShowParameter.setFormId("bos_listf7");
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String evtKey = args.getProperty().getName();
        if (HRStringUtils.equals((String)"type", (String)evtKey)) {
            this.typeChange();
        } else if (HRStringUtils.equals((String)"way", (String)evtKey)) {
            this.wayChange(true);
        } else if (HRStringUtils.equals((String)"numberx", (String)evtKey)) {
            String number = this.getModel().getDataEntity().getString("numberx");
            if (HRStringUtils.isNotEmpty((String)number)) {
                if (!this.validateParamCode(number)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4ec5\u652f\u6301\u8f93\u5165\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u8bf7\u8c03\u6574\u3002", (String)"RetrievalItemEdit_0", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("numberx", null);
                    this.getView().updateView("numberx");
                    return;
                }
                this.unicodeChange();
            }
            DynamicObject groupDy = this.getModel().getDataEntity().getDynamicObject("parentf7");
            this.getModel().getDataEntity().set("parent", (Object)groupDy);
            if (null == groupDy || HRStringUtils.equals((String)"2", (String)groupDy.getString("grouptype"))) {
                this.getModel().setValue("number", (Object)this.getModel().getDataEntity().getString("numberx"));
            }
        } else if (HRStringUtils.equals((String)"parentf7", (String)evtKey)) {
            this.parentChange();
            this.typeChange();
            this.wayChange(false);
            this.unicodeChange();
        } else if ("belongobj".equals(evtKey)) {
            Object newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).get()).getNewValue() : null;
            DynamicObject belongObjDy = (DynamicObject)newValue;
            ComboEdit comboEdit = (ComboEdit)this.getControl("fieldlist");
            if (belongObjDy == null) {
                comboEdit.setComboItems((List)Lists.newArrayList());
                this.getModel().setValue("fieldlist", null);
                return;
            }
            this.setFieldComboItem(belongObjDy.getString("id"), null);
            this.getModel().setValue("fieldlist", null);
        } else if ("fieldlist".equals(evtKey)) {
            Object newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).get()).getNewValue() : null;
            String fieldNumber = (String)newValue;
            if (HRStringUtils.isEmpty((String)fieldNumber)) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject dynamicObject = dataEntity.getDynamicObject("belongobj");
            String belongObjId = dynamicObject.getString("id");
            IDataEntityProperty property = null;
            MainEntityType dataEntityType = this.getMainEntityType(belongObjId);
            if (null != dataEntityType) {
                DataEntityPropertyCollection properties = dataEntityType.getProperties();
                property = (IDataEntityProperty)properties.get((Object)fieldNumber);
            }
            if (null == property) {
                return;
            }
            this.getModel().setValue("number", (Object)property.getName());
            String fieldType = this.getFieldTypeFormProperty(property, property.getName());
            this.getModel().setValue("type", (Object)fieldType);
            this.getView().setEnable(Boolean.FALSE, new String[]{"type"});
        } else if ("assigntype".equals(evtKey)) {
            this.assignTypeChange();
        }
    }

    private MainEntityType getMainEntityType(String belongObjId) {
        MainEntityType dataEntityType = null;
        try {
            dataEntityType = RetrievalUtil.getDataEntityType((String)belongObjId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataEntityType;
    }

    private String getFieldTypeFormProperty(IDataEntityProperty property, String propertyName) {
        if (WTCStringUtils.equals((String)"id", (String)propertyName)) {
            return "dynamicObject";
        }
        String fieldType = property instanceof TimeProp ? "number" : (property instanceof BooleanProp ? "boolean" : (property instanceof TextProp || property instanceof AdminDivisionProp ? "string" : (property instanceof ComboProp ? "enum" : (property instanceof DateTimeProp ? "date" : (property instanceof DecimalProp ? "number" : (property instanceof BasedataProp ? "dynamicObject" : "string"))))));
        return fieldType;
    }

    private boolean validateParamCode(String paramCode) {
        Matcher matcher = NUMBER_PATTERN.matcher(paramCode);
        return matcher.matches();
    }

    private boolean validateUnicode(String paramCode) {
        Matcher matcher = UNICODE_PATTERN.matcher(paramCode);
        return matcher.matches();
    }

    private void typeChange() {
        String itemType = this.getModel().getDataEntity().getString("type");
        if (HRStringUtils.equals((String)"number", (String)itemType)) {
            if (this.getModel().getDataEntity().get("scale") == null) {
                this.getModel().getDataEntity().set("scale", (Object)"1");
            }
            if (this.getModel().getDataEntity().get("tailprocessing") == null) {
                this.getModel().getDataEntity().set("tailprocessing", (Object)"1");
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"scale", "tailprocessing"});
        } else {
            this.getModel().getDataEntity().set("scale", null);
            this.getModel().getDataEntity().set("tailprocessing", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"scale", "tailprocessing"});
        }
        this.getView().updateView("scale");
        this.getView().updateView("tailprocessing");
        String comboField = this.getModel().getDataEntity().getString("combofield");
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)itemType, (String)"enum") && HRStringUtils.isNotEmpty((String)comboField)), new String[]{"comboap"});
    }

    private void wayChange(boolean canClear) {
        String way = this.getModel().getDataEntity().getString("way");
        DynamicObject groupDy = this.getModel().getDataEntity().getDynamicObject("parent");
        if (HRStringUtils.equals((String)"2", (String)way) && null != groupDy && HRStringUtils.equals((String)"2", (String)groupDy.getString("grouptype"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"uniquecode"});
            ((FieldEdit)this.getControl("uniquecode")).setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"uniquecode"});
            if (canClear) {
                this.getModel().setValue("uniquecode", null);
            }
            ((FieldEdit)this.getControl("uniquecode")).setMustInput(false);
        }
    }

    private void parentChange() {
        DynamicObject groupDy = this.getModel().getDataEntity().getDynamicObject("parentf7");
        this.getModel().getDataEntity().set("parent", (Object)groupDy);
        if (null != groupDy) {
            String groupType = groupDy.getString("grouptype");
            if (HRStringUtils.equals((String)groupType, (String)"1")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"scale", "tailprocessing"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"belongobj", "fieldlist"});
                ((BasedataEdit)this.getControl("belongobj")).setMustInput(true);
                ((ComboEdit)this.getControl("fieldlist")).setMustInput(true);
                this.getView().setEnable(Boolean.FALSE, new String[]{"type"});
            } else {
                this.parentChangeNotControlGroupType();
            }
        } else {
            this.parentChangeNotControlGroupType();
        }
        this.getView().updateView("parent");
        this.getView().updateView("type");
        this.getView().updateView("way");
        this.getView().updateView("belongobj");
        this.getView().updateView("fieldlist");
    }

    private void parentChangeNotControlGroupType() {
        this.getModel().setValue("belongobj", null);
        this.getView().setEnable(Boolean.TRUE, new String[]{"type"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"scale", "tailprocessing"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"belongobj", "fieldlist"});
        ((BasedataEdit)this.getControl("belongobj")).setMustInput(false);
        ((ComboEdit)this.getControl("fieldlist")).setMustInput(false);
    }

    private void setFieldComboItem(String belongObjId, String fieldNumber) {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(10);
        MainEntityType dataEntityType = this.getMainEntityType(belongObjId);
        if (null != dataEntityType) {
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            for (IDataEntityProperty property : properties) {
                LocaleString displayName = property.getDisplayName();
                String name = property.getName();
                boolean isNormalProp = Arrays.stream(MATCHED_FIELDLIST_TYPE).anyMatch(typeClz -> typeClz.isInstance(property));
                if (!isNormalProp || null == displayName || !HRStringUtils.isNotEmpty((String)name) || "id".equals(name)) continue;
                comboItemList.add(new ComboItem(displayName, name));
            }
        }
        if (HRStringUtils.equals((String)"id", (String)fieldNumber)) {
            comboItemList.add(new ComboItem(new LocaleString("id"), "id"));
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("fieldlist");
        comboEdit.setComboItems(comboItemList);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObject groupDy;
            String cacheFromScene = this.getPageCache().get("CACHE_FROM_SCENE");
            if (WTCStringUtils.equals((String)"true", (String)cacheFromScene)) {
                this.getModel().setValue("number", (Object)this.getModel().getDataEntity().getString("numberx"));
            }
            this.fillUnicode();
            String unicode = this.getModel().getDataEntity().getString("uniquecode");
            if (HRStringUtils.isNotEmpty((String)unicode) && !this.validateUnicode(unicode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u552f\u4e00\u6807\u8bc6\u7801\u4ec5\u652f\u6301\u8f93\u5165\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u201c$\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RetrievalItemEdit_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            boolean isControlType = null != (groupDy = this.getModel().getDataEntity().getDynamicObject("parent")) && HRStringUtils.equals((String)"1", (String)groupDy.getString("grouptype"));
            ArrayList list = Lists.newArrayListWithExpectedSize((int)3);
            if (isControlType && !HRStringUtils.equals((String)"true", (String)cacheFromScene)) {
                if (Objects.isNull(this.getModel().getValue("belongobj"))) {
                    list.add(ResManager.loadKDString((String)"\u201c\u6765\u6e90\u5b9e\u4f53\u201d", (String)"RetrievalItemEdit_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                }
                if (HRStringUtils.isEmpty((String)((String)this.getModel().getValue("fieldlist")))) {
                    list.add(ResManager.loadKDString((String)"\u201c\u6765\u6e90\u5b57\u6bb5\u201d", (String)"RetrievalItemEdit_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                }
            }
            if (WTCCollections.isNotEmpty((Collection)list)) {
                String error = String.join((CharSequence)"\u3001", list);
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199{0}\u3002", (String)"RetrievalItemEdit_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), error));
                args.setCancel(true);
            }
            String paramsType = this.getModel().getDataEntity().getString("type");
            String comboField = this.getModel().getDataEntity().getString("combofield");
            if (HRStringUtils.equals((String)paramsType, (String)"enum")) {
                DynamicObjectCollection colls = this.getModel().getEntryEntity("comboentryentity");
                if (WTCCollections.isEmpty((Collection)colls)) {
                    if (HRStringUtils.isNotEmpty((String)comboField)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u4e0b\u62c9\u9879\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"RetrievalItemEdit_11", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    return;
                }
                ArrayList enumList = Lists.newArrayListWithCapacity((int)10);
                for (DynamicObject dy : colls) {
                    String comboTitle = dy.getString("combotitle");
                    String comboValue = dy.getString("combovalue");
                    if (HRStringUtils.isEmpty((String)comboValue) || HRStringUtils.isEmpty((String)comboTitle)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u4e0b\u62c9\u9879\u3002", (String)"RetrievalItemEdit_8", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    EnumInfo info = new EnumInfo(comboTitle, comboValue);
                    if (enumList.contains(info)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u62c9\u6807\u9898\u91cd\u590d\u3002", (String)"RetrievalItemEdit_9", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    enumList.add(info);
                }
                String comboFieldStr = SerializationUtils.toJsonString((Object)enumList);
                if (HRStringUtils.isNotEmpty((String)comboFieldStr) && comboFieldStr.length() > 2000) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0b\u62c9\u9879\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u5220\u51cf\u3002", (String)"RetrievalItemEdit_10", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getModel().setValue("combofield", (Object)SerializationUtils.toJsonString((Object)enumList));
            } else if (HRStringUtils.isNotEmpty((String)comboField)) {
                this.getModel().setValue("combofield", null);
            }
        }
    }

    private void fillUnicode() {
        String unicode = this.getModel().getDataEntity().getString("uniquecode");
        if (HRStringUtils.isNotEmpty((String)unicode)) {
            return;
        }
        this.unicodeChange();
    }

    private void unicodeChange() {
        String number = this.getModel().getDataEntity().getString("numberx");
        DynamicObject groupDy = this.getModel().getDataEntity().getDynamicObject("parent");
        if (null == groupDy) {
            this.getModel().setValue("uniquecode", (Object)number);
            return;
        }
        if (HRStringUtils.isNotEmpty((String)number)) {
            String groupType = groupDy.getString("grouptype");
            if (HRStringUtils.equals((String)groupType, (String)"1")) {
                this.getModel().setValue("uniquecode", (Object)("CT$A$A$" + number));
            } else if (HRStringUtils.equals((String)groupType, (String)"2")) {
                this.getModel().setValue("uniquecode", (Object)("FM$A$A$" + number));
            } else {
                this.getModel().setValue("uniquecode", (Object)number);
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        if (!WTCGrayscaleUtils.isRetrievalOpen().booleanValue()) {
            args.setCancel(true);
            args.setCancelMessage(SceneCfgKDString.grayscaleStatusIsClosed());
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.clearPresetData();
    }

    private void clearPresetData() {
        DynamicObject groupDy = this.getModel().getDataEntity().getDynamicObject("parent");
        if (null != groupDy && (groupDy.getBoolean("issyspreset") || !HRStringUtils.equals((String)"1", (String)groupDy.getString("enable")))) {
            groupDy = null;
        }
        this.getModel().getDataEntity().set("parent", (Object)groupDy);
        this.getModel().getDataEntity().set("parentf7", (Object)groupDy);
        this.getView().updateView("parentf7");
        String way = this.getModel().getDataEntity().getString("way");
        if (HRStringUtils.equals((String)"3", (String)way)) {
            this.getModel().getDataEntity().set("way", null);
        }
    }

    private void assignTypeChange() {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            this.setComboField();
            this.getModel().setDataChanged(false);
        }
    }

    private boolean setComboField() {
        String paramsType = this.getModel().getDataEntity().getString("type");
        String comboField = this.getModel().getDataEntity().getString("combofield");
        if (HRStringUtils.equals((String)paramsType, (String)"enum") && HRStringUtils.isNotEmpty((String)comboField)) {
            List<EnumInfo> enumList;
            try {
                enumList = SerializationUtils.fromJsonStringToList((String)comboField, EnumInfo.class);
            }
            catch (Exception ignore) {
                enumList = Collections.emptyList();
            }
            this.setComboFieldEntry(enumList);
            return true;
        }
        return false;
    }

    private void setComboFieldEntry(List<EnumInfo> enumList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("comboentryentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("combotitle", new Object[0]);
        vs.addField("combovalue", new Object[0]);
        if (WTCCollections.isNotEmpty(enumList)) {
            for (EnumInfo enumInfo : enumList) {
                vs.addRow(new Object[]{enumInfo.getName().toString(), enumInfo.getValue()});
            }
            model.batchCreateNewEntryRow("comboentryentity", vs);
        }
        model.endInit();
        this.getView().updateView("comboentryentity");
    }
}

