/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.retrieval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.business.retrieval.RetrievalItemHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalUtil;
import kd.wtc.wtbd.business.retrieval.service.RetrievalMCConfig;
import kd.wtc.wtbd.business.scenecfg.SceneCfgHelper;
import kd.wtc.wtbd.common.constants.scenecfg.SceneCfgKDString;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;

public class RetrievalItemList
extends AbstractTreeListPlugin {
    private static final HRBaseServiceHelper itemHelper = new HRBaseServiceHelper("wtbd_scenefieldcfg");
    private Boolean isUpgradeSuccess = Boolean.FALSE;

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.getView().setEnable(this.isUpgradeSuccess, new String[]{"tblnew", "tblcopy", "tbldel", "tbldisable", "tblenable", "tblrefresh", "log", "tblclose"});
        if (!this.isUpgradeSuccess.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RetrievalItemEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow", "iscontainlower"});
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        QFilter listFilter = new QFilter("category", "in", (Object)Lists.newArrayList((Object[])new String[]{"1"}));
        listFilter.and("id", "not in", (Object)RetrievalMCConfig.defaultConfig().getHiddenRetrievalItemIds());
        evt.getCustomQFilters().add(listFilter);
        evt.setOrderBy("modifytime desc,numberx asc");
        this.isUpgradeSuccess = RetrievalUtil.isUpgradeFinished((String)"426TICG+NW7C", (String)"426TB3KG8ASG");
    }

    public void beforeShowBill(BeforeShowBillFormEvent evt) {
        DynamicObject dynamicObject;
        super.beforeShowBill(evt);
        Long pkId = (Long)evt.getParameter().getPkId();
        if (null != pkId && (dynamicObject = SceneCfgHelper.queryFieldCfgById((long)pkId)) != null) {
            boolean isSysPreset = dynamicObject.getBoolean("issyspreset");
            Boolean isCopy = (Boolean)evt.getParameter().getCustomParam("iscopy");
            if (isSysPreset && (isCopy == null || !isCopy.booleanValue())) {
                evt.getParameter().setStatus(OperationStatus.VIEW);
                evt.getParameter().setBillStatus(BillOperationStatus.VIEW);
            }
            if (isCopy != null && isCopy.booleanValue()) {
                evt.getParameter().setCustomParam("retrievalItemFieldNumber", (Object)dynamicObject.getString("number"));
            }
        }
        boolean isUpgradeSuccess = RetrievalUtil.isUpgradeFinished((String)"426TICG+NW7C", (String)"426TB3KG8ASG");
        evt.getParameter().setCustomParam("isUpgradeSuccess", (Object)Boolean.toString(isUpgradeSuccess));
        if (!isUpgradeSuccess) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RetrievalItemEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        String billShowStr = this.getPageCache().get("CACHE_BILL_SHOW");
        if (HRStringUtils.isNotEmpty((String)billShowStr)) {
            this.getPageCache().remove("CACHE_BILL_SHOW");
            evt.setCancel(true);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if (HRStringUtils.equals((String)"config_name", (String)fieldName)) {
            boolean isUpgradeSuccess = RetrievalUtil.isUpgradeFinished((String)"426TICG+NW7C", (String)"426TB3KG8ASG");
            if (!isUpgradeSuccess) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RetrievalItemEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            BillListHyperLinkClickEvent billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            Long id = (Long)billListHyperLinkClickEvent.getCurrentRow().getPrimaryKeyValue();
            long configId = RetrievalItemHelper.getConfigIdById((Long)id);
            if (0L == configId) {
                args.setCancel(true);
                return;
            }
            this.getPageCache().put("CACHE_BILL_SHOW", Boolean.TRUE.toString());
            WTCFormUtils.showDetailView((IFormView)this.getView(), (String)"wtbd_retrievalconfig", (Object)configId);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        if (!WTCGrayscaleUtils.isRetrievalOpen().booleanValue()) {
            args.setCancel(true);
            args.setCancelMessage(SceneCfgKDString.grayscaleStatusIsClosed());
        }
    }

    public void refreshNode(RefreshNodeEvent evt) {
        TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(evt.getNodeId().toString());
        if (WTCCollections.isNotEmpty((Collection)treeNode.getChildren())) {
            evt.setChildNodes(treeNode.getChildren());
        } else {
            evt.setChildNodes(Collections.emptyList());
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent evt) {
        super.buildTreeListFilter(evt);
        String nodeId = evt.getNodeId().toString();
        QFilter listFilter = new QFilter("category", "in", (Object)Lists.newArrayList((Object[])new String[]{"1"}));
        listFilter.and("id", "not in", (Object)RetrievalMCConfig.defaultConfig().getHiddenRetrievalItemIds());
        if (HRStringUtils.equals((String)nodeId, (String)"-2")) {
            listFilter.and("parent.grouptype", "in", (Object)Lists.newArrayList((Object[])new String[]{"1"}));
        } else if (HRStringUtils.equals((String)nodeId, (String)"-3")) {
            listFilter.and("parent.grouptype", "in", (Object)Lists.newArrayList((Object[])new String[]{"2", "3"}));
        } else if (!HRStringUtils.equals((String)nodeId, (String)"-1")) {
            ArrayList<Long> parents = new ArrayList<Long>(10);
            TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(nodeId);
            this.getAllChildIds(treeNode, parents);
            parents.add(Long.parseLong(nodeId));
            listFilter.and("parent", "in", (Object)parents.toArray());
        }
        evt.addQFilter(listFilter);
        evt.setCancel(true);
    }

    private void getAllChildIds(TreeNode treeNode, List<Long> parents) {
        if (null == treeNode || WTCCollections.isEmpty((Collection)treeNode.getChildren())) {
            return;
        }
        treeNode.getChildren().forEach(child -> parents.add(Long.parseLong(child.getId())));
        List children = treeNode.getChildren();
        for (TreeNode child2 : children) {
            this.getAllChildIds(child2, parents);
        }
    }

    public void initializeTree(EventObject evt) {
        super.initializeTree(evt);
        TreeNode root = new TreeNode("", "-1", ResManager.loadKDString((String)"\u5168\u90e8", (String)"RetrievalItemList_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        root.addChildren(this.getRootChildren());
        root.setIsOpened(true);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getTreeModel().setRootVisable(true);
    }

    private List<TreeNode> getRootChildren() {
        TreeNode ctNode = new TreeNode("-1", "-2", ResManager.loadKDString((String)"\u6761\u4ef6\u89c4\u5219", (String)"RetrievalItemList_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        ctNode.addChildren(this.getChildrenByGroupTypes(Lists.newArrayList((Object[])new String[]{"1"})));
        TreeNode formulaNode = new TreeNode("-1", "-3", ResManager.loadKDString((String)"\u8003\u52e4\u516c\u5f0f", (String)"RetrievalItemList_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        formulaNode.addChildren(this.getChildrenByGroupTypes(Lists.newArrayList((Object[])new String[]{"2", "3"})));
        return Lists.newArrayList((Object[])new TreeNode[]{ctNode, formulaNode});
    }

    private List<TreeNode> getChildrenByGroupTypes(List<String> groupTypes) {
        QFilter itemGroupQFilter = new QFilter("category", "in", (Object)Lists.newArrayList((Object[])new String[]{"2", "3"}));
        itemGroupQFilter.and("id", "not in", (Object)RetrievalMCConfig.defaultConfig().getHiddenRetrievalGroupIds());
        if (WTCCollections.isNotEmpty(groupTypes)) {
            itemGroupQFilter.and(new QFilter("grouptype", "in", groupTypes));
        }
        DynamicObject[] allItems = itemHelper.loadDynamicObjectArray(new QFilter[]{itemGroupQFilter});
        Set categoryIds = Arrays.stream(allItems).map(entry -> String.valueOf(entry.getLong("id"))).collect(Collectors.toSet());
        HashMap<String, DynamicObject> idToDyMap = new HashMap<String, DynamicObject>();
        Arrays.stream(allItems).forEach(item -> idToDyMap.put(String.valueOf(item.getLong("id")), (DynamicObject)item));
        ArrayList parentCategoryIds = new ArrayList(categoryIds);
        categoryIds.stream().map(categoryId -> ((DynamicObject)idToDyMap.get(categoryId)).getLong("parent.id")).filter(parentId -> parentId != 0L).forEach(parentId -> parentCategoryIds.add(String.valueOf(parentId)));
        categoryIds.addAll(parentCategoryIds);
        Map<String, TreeNode> nodeMap = categoryIds.stream().map(idToDyMap::get).collect(Collectors.toMap(dy -> String.valueOf(dy.getLong("id")), dy -> new TreeNode("", String.valueOf(dy.getLong("id")), dy.getString("name"))));
        for (String categoryId2 : categoryIds) {
            DynamicObject dy2 = (DynamicObject)idToDyMap.get(categoryId2);
            long parentId2 = dy2.getLong("parent.id");
            TreeNode treeNodeItem = nodeMap.get(categoryId2);
            if (parentId2 == 0L) continue;
            String parentIdStr = String.valueOf(parentId2);
            treeNodeItem.setParentid(parentIdStr);
            List childrenNodes = nodeMap.get(parentIdStr).getChildren();
            if (WTCCollections.isNotEmpty((Collection)childrenNodes)) {
                childrenNodes.add(treeNodeItem);
                this.sortGroupChildrenNode(idToDyMap, childrenNodes);
                continue;
            }
            nodeMap.get(parentIdStr).addChild(treeNodeItem);
        }
        List<TreeNode> resNodes = nodeMap.values().stream().filter(item -> HRStringUtils.isEmpty((String)item.getParentid())).collect(Collectors.toList());
        this.sortGroupChildrenNode(idToDyMap, resNodes);
        return resNodes;
    }

    private void sortGroupChildrenNode(Map<String, DynamicObject> idToDyMap, List<TreeNode> childrenNodes) {
        childrenNodes.sort((node1, node2) -> {
            Date date2;
            DynamicObject nodeDy1 = (DynamicObject)idToDyMap.get(node1.getId());
            DynamicObject nodeDy2 = (DynamicObject)idToDyMap.get(node2.getId());
            if (nodeDy1 == null) {
                return nodeDy2 == null ? 0 : -1;
            }
            if (nodeDy2 == null) {
                return 1;
            }
            Date date1 = nodeDy1.getDate("createtime");
            int result = date1.compareTo(date2 = nodeDy2.getDate("createtime"));
            if (result == 0) {
                result = nodeDy1.getString("numberx").compareTo(nodeDy2.getString("numberx"));
            }
            return result;
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if (HRStringUtils.equals((String)"refresh", (String)key)) {
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            if (null == currentNodeId) {
                return;
            }
            TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId.toString());
            if (null == treeNode) {
                return;
            }
            List parentIdList = this.getTreeModel().getRoot().getChildPath(currentNodeId.toString());
            TreeNode root = new TreeNode("", "-1", ResManager.loadKDString((String)"\u5168\u90e8", (String)"RetrievalItemList_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
            root.addChildren(this.getRootChildren());
            this.getTreeModel().setRoot(root);
            if (WTCCollections.isEmpty((Collection)parentIdList)) {
                this.getTreeModel().setCurrentNodeId((Object)"-1");
                return;
            }
            String currentNodeIdStr = (String)currentNodeId;
            if (HRStringUtils.equals((String)currentNodeIdStr, (String)"-1") || HRStringUtils.equals((String)currentNodeIdStr, (String)"-2") || HRStringUtils.equals((String)currentNodeIdStr, (String)"-3")) {
                return;
            }
            DynamicObject[] groupDys = itemHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)parentIdList.stream().map(Long::parseLong).toArray())});
            HashMap dyMap = new HashMap(16);
            Arrays.stream(groupDys).forEach(groupDy -> dyMap.put(groupDy.getString("id"), groupDy));
            if (!dyMap.containsKey(currentNodeIdStr)) {
                String focusNodeId = null;
                for (int i = parentIdList.size() - 1; i >= 0; --i) {
                    if (dyMap.containsKey(parentIdList.get(i))) {
                        focusNodeId = (String)parentIdList.get(i);
                        break;
                    }
                    if (!HRStringUtils.equals((String)currentNodeIdStr, (String)"-1") && !HRStringUtils.equals((String)currentNodeIdStr, (String)"-2") && !HRStringUtils.equals((String)currentNodeIdStr, (String)"-3")) continue;
                    focusNodeId = currentNodeIdStr;
                    break;
                }
                if (null == focusNodeId) {
                    focusNodeId = "-1";
                }
                this.getTreeModel().setCurrentNodeId((Object)focusNodeId);
            } else {
                this.getTreeModel().setCurrentNodeId((Object)"-1");
                this.getView().getPageCache().put("cacheRetrievalItemNodeId", currentNodeId.toString());
                this.getView().getPageCache().put("cacheParentNodeId", treeNode.getParentid());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if (HRStringUtils.equals((String)"refresh", (String)key)) {
            String currentNodeId;
            String parentNodeId = this.getView().getPageCache().get("cacheParentNodeId");
            if (HRStringUtils.isNotEmpty((String)parentNodeId)) {
                this.getTreeModel().setCurrentNodeId((Object)parentNodeId);
                this.getTreeListView().refresh();
                this.getView().getPageCache().remove("cacheParentNodeId");
            }
            if (HRStringUtils.isNotEmpty((String)(currentNodeId = this.getView().getPageCache().get("cacheRetrievalItemNodeId")))) {
                this.getTreeModel().setCurrentNodeId((Object)currentNodeId);
                this.getTreeListView().refresh();
                TreeNode curNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId);
                this.getTreeListView().getTreeView().focusNode(curNode);
                this.getView().getPageCache().remove("cacheRetrievalItemNodeId");
            }
        }
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow", "iscontainlower"});
    }
}

