/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.retrieval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hbp.formplugin.web.util.TreeViewSearchTool;
import kd.wtc.wtbd.business.retrieval.service.RetrievalMCConfig;
import kd.wtc.wtbd.common.constants.scenecfg.SceneCfgConstants;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class RetrievalParamPropPlugin
extends HRDynamicFormBasePlugin
implements SceneCfgConstants,
SearchEnterListener {
    private static final HRBaseServiceHelper ITEM_SERVICE_HELPER = new HRBaseServiceHelper("wtbd_scenefieldcfg");
    private static final String FIELD_TREE = "fieldtree";
    private static final String LEFT_FIELD_TREE = "leftfieldtree";
    private static final String RIGHT_FIELD_TREE = "rightfieldtree";
    private static final String LEFT_CHECK_NODES = "checkNodes";
    private static final String RIGHT_CHECK_NODES = "unCheckNodes";
    private static final String LEFT_SEARCH_AP = "leftsearchap";
    private static final String RIGHT_SEARCH_AP = "rightsearchap";
    private static final String BTN_OK = "btnok";
    private static final String BTN_MOVE_RIGHT = "moveright";
    private static final String BTN_MOVE_LEFT = "moveleft";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{BTN_OK, BTN_MOVE_RIGHT, BTN_MOVE_LEFT});
        Search searchEdit = (Search)this.getControl(LEFT_SEARCH_AP);
        searchEdit.addEnterListener((SearchEnterListener)this);
        Search rightSearchEdit = (Search)this.getControl(RIGHT_SEARCH_AP);
        rightSearchEdit.addEnterListener((SearchEnterListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_MOVE_RIGHT.equals(key)) {
            this.moveRight();
        } else if (BTN_MOVE_LEFT.equals(key)) {
            this.moveLeft();
        } else if (BTN_OK.equals(key)) {
            this.getPageCache().get(LEFT_CHECK_NODES);
            TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(RIGHT_FIELD_TREE), TreeNode.class);
            List<Map<String, String>> refProps = this.root2ListMap(treeNode, this.getDisplayMap());
            if (this.presetFieldIdDeleted(refProps)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u7981\u6b62\u5220\u9664\u3002", (String)"RetrievalRuleParamPlugin_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)2);
            returnData.put("refProps", refProps);
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
            this.getView().close();
        }
    }

    private boolean presetFieldIdDeleted(List<Map<String, String>> refProps) {
        List presetFieldIdList;
        String presetFieldIdListStr;
        ArrayList<String> selectFieldIdList = new ArrayList<String>(10);
        if (WTCCollections.isNotEmpty(refProps)) {
            for (Map<String, String> refProp : refProps) {
                String fieldId = refProp.get("fieldid");
                if (!HRStringUtils.isNotEmpty((String)fieldId)) continue;
                selectFieldIdList.add(fieldId);
            }
        }
        if (HRStringUtils.isNotEmpty((String)(presetFieldIdListStr = (String)this.getView().getFormShowParameter().getCustomParam("presetFieldIdList"))) && WTCCollections.isNotEmpty((Collection)(presetFieldIdList = SerializationUtils.fromJsonStringToList((String)presetFieldIdListStr, String.class)))) {
            for (String presetFieldId : presetFieldIdList) {
                if (selectFieldIdList.contains(presetFieldId)) continue;
                return true;
            }
        }
        return false;
    }

    private void moveLeft() {
        TreeView tree = (TreeView)this.getView().getControl(RIGHT_FIELD_TREE);
        List checkNodeIds = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(LEFT_CHECK_NODES), String.class);
        checkNodeIds.removeAll(tree.getTreeState().getCheckedNodeIds());
        this.getPageCache().put(LEFT_CHECK_NODES, SerializationUtils.toJsonString((Object)checkNodeIds));
        this.initLeftTree();
        this.initRightTree();
    }

    private void moveRight() {
        TreeView tree = (TreeView)this.getView().getControl(LEFT_FIELD_TREE);
        List checkedNodeIds = tree.getTreeState().getCheckedNodeIds();
        String leftCheckNodeStr = this.getPageCache().get(LEFT_CHECK_NODES);
        if (HRStringUtils.isNotEmpty((String)leftCheckNodeStr)) {
            List oldCheckNodeIds = SerializationUtils.fromJsonStringToList((String)leftCheckNodeStr, String.class);
            checkedNodeIds = Stream.of(oldCheckNodeIds, checkedNodeIds).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }
        this.getPageCache().put(LEFT_CHECK_NODES, SerializationUtils.toJsonString((Object)checkedNodeIds));
        this.initLeftTree();
        this.initRightTree();
    }

    public void search(SearchEnterEvent evt) {
        Search source = (Search)evt.getSource();
        String searchText = evt.getText();
        if (HRStringUtils.equals((String)LEFT_SEARCH_AP, (String)source.getKey())) {
            TreeView tv = (TreeView)this.getView().getControl(LEFT_FIELD_TREE);
            TreeViewSearchTool.search((String)searchText, (TreeView)tv, (IPageCache)this.getPageCache());
        } else {
            TreeView tv = (TreeView)this.getView().getControl(RIGHT_FIELD_TREE);
            TreeViewSearchTool.search((String)searchText, (TreeView)tv, (IPageCache)this.getPageCache());
        }
    }

    public void afterCreateNewData(EventObject evt) {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        if (HRStringUtils.isNotEmpty((String)entityId)) {
            this.initLeftTree();
            this.initRightTree();
        }
    }

    private void initLeftTree() {
        this.initTree(true);
    }

    private void initRightTree() {
        this.initTree(false);
    }

    private TreeNode getTree() {
        String fieldTree = this.getPageCache().get(FIELD_TREE);
        if (HRStringUtils.isNotEmpty((String)fieldTree)) {
            return (TreeNode)SerializationUtils.fromJsonString((String)fieldTree, TreeNode.class);
        }
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        DynamicObject[] retrievalItems = ITEM_SERVICE_HELPER.loadDynamicObjectArray(new QFilter[0]);
        List<String> stdWayRetrievalItemIds = Arrays.stream(retrievalItems).filter(item -> HRStringUtils.equals((String)"1", (String)item.getString("category")) && HRStringUtils.equals((String)"3", (String)item.getString("way"))).map(item -> item.getString("id")).collect(Collectors.toList());
        Optional<DynamicObject> rootDyOpl = Arrays.stream(retrievalItems).filter(item -> HRStringUtils.equals((String)String.valueOf(item.getLong("id")), (String)entityId)).findFirst();
        if (rootDyOpl.isPresent()) {
            DynamicObject rootDy = rootDyOpl.get();
            TreeNode root = new TreeNode("", entityId, rootDy.getString("name"));
            this.buildTree(root, retrievalItems);
            ArrayList<String> emptyNodeIds = new ArrayList<String>(10);
            this.getDeleteEmptyNode(root, root, emptyNodeIds);
            emptyNodeIds.forEach(arg_0 -> ((TreeNode)root).deleteChildNode(arg_0));
            List<String> checkNodeIds = this.getCheckNodeIds();
            RetrievalMCConfig.defaultConfig().getHiddenRetrievalItemIds().forEach(checkNodeId -> {
                if (!checkNodeIds.contains(String.valueOf(checkNodeId))) {
                    root.deleteChildNode(String.valueOf(checkNodeId));
                }
            });
            stdWayRetrievalItemIds.forEach(checkNodeId -> {
                if (!checkNodeIds.contains(String.valueOf(checkNodeId))) {
                    root.deleteChildNode(String.valueOf(checkNodeId));
                }
            });
            this.getPageCache().put(FIELD_TREE, SerializationUtils.toJsonString((Object)root));
            return root;
        }
        return null;
    }

    private void buildTree(TreeNode node, DynamicObject[] retrievalItems) {
        List childDys = Arrays.stream(retrievalItems).filter(item -> HRStringUtils.equals((String)String.valueOf(item.getLong("parent.id")), (String)node.getId())).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(childDys)) {
            for (DynamicObject childDy : childDys) {
                TreeNode childNode = new TreeNode(node.getId(), String.valueOf(childDy.getLong("id")), childDy.getString("name"));
                if (HRStringUtils.equals((String)childDy.getString("category"), (String)"1")) {
                    if (HRStringUtils.equals((String)"0", (String)childDy.getString("enable"))) continue;
                    node.addChild(childNode);
                    childNode.setLeaf(true);
                    childNode.setLongNumber(childDy.getString("numberx"));
                    childNode.setLongText(childDy.getString("type"));
                    continue;
                }
                this.buildTree(childNode, retrievalItems);
                node.addChild(childNode);
            }
        }
    }

    private void getDeleteEmptyNode(TreeNode node, TreeNode root, List<String> deleteNodeIds) {
        if (CollectionUtils.isEmpty((Collection)node.getChildren()) && !node.isLeaf() && node != root) {
            deleteNodeIds.add(node.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)node.getChildren())) {
            for (TreeNode childNode : node.getChildren()) {
                this.getDeleteEmptyNode(childNode, root, deleteNodeIds);
            }
        }
    }

    private void initTree(boolean isLeft) {
        TreeNode root = this.getTree();
        if (null == root) {
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl(isLeft ? LEFT_FIELD_TREE : RIGHT_FIELD_TREE);
        tree.deleteAllNodes();
        tree.addNode(root);
        if (isLeft) {
            List<String> checkNodeIds = this.getCheckNodeIds();
            checkNodeIds.forEach(arg_0 -> ((TreeNode)root).deleteChildNode(arg_0));
            this.getPageCache().put(LEFT_CHECK_NODES, SerializationUtils.toJsonString(checkNodeIds));
        } else {
            List<String> unCheckNodeIds = this.getUnCheckNodeIds(root);
            unCheckNodeIds.forEach(arg_0 -> ((TreeNode)root).deleteChildNode(arg_0));
            this.getPageCache().put(RIGHT_CHECK_NODES, SerializationUtils.toJsonString(unCheckNodeIds));
        }
        tree.expand(root.getId());
        Map<String, TreeNode> leafMap = this.getTreeLeafMap(root);
        leafMap.forEach((nodeId, node) -> {
            if (HRStringUtils.isNotEmpty((String)node.getParentid())) {
                tree.expand(node.getParentid());
            }
        });
        this.getView().updateView(isLeft ? LEFT_FIELD_TREE : RIGHT_FIELD_TREE);
        this.getPageCache().put(isLeft ? LEFT_FIELD_TREE : RIGHT_FIELD_TREE, SerializationUtils.toJsonString((Object)root));
    }

    private List<String> getCheckNodeIds() {
        List<String> checkNodeIds = Lists.newArrayListWithExpectedSize((int)10);
        String leftCheckNodeStr = this.getPageCache().get(LEFT_CHECK_NODES);
        if (HRStringUtils.isNotEmpty((String)leftCheckNodeStr)) {
            checkNodeIds = SerializationUtils.fromJsonStringToList((String)leftCheckNodeStr, String.class);
        } else {
            List refProps = (List)this.getView().getFormShowParameter().getCustomParams().get("value");
            if (refProps == null) {
                refProps = Lists.newArrayListWithExpectedSize((int)10);
            }
            for (Map refProp : refProps) {
                String nodeId = (String)refProp.get("id");
                if (!HRStringUtils.isNotEmpty((String)nodeId)) continue;
                checkNodeIds.add(nodeId);
            }
        }
        return checkNodeIds;
    }

    private List<String> getUnCheckNodeIds(TreeNode root) {
        List<String> checkNodeIds = this.getCheckNodeIds();
        ArrayList checkNodeIdWithParent = new ArrayList(checkNodeIds.size());
        for (String checkNodeId : checkNodeIds) {
            List pathNodeIds = root.getChildPath(checkNodeId);
            if (!WTCCollections.isNotEmpty((Collection)pathNodeIds)) continue;
            checkNodeIdWithParent.addAll(pathNodeIds);
        }
        Map<String, TreeNode> leafMap = this.getTreeLeafMap(root);
        ArrayList<String> allNodeIds = new ArrayList<String>(leafMap.size());
        for (String leafNodeId : leafMap.keySet()) {
            allNodeIds.add(leafNodeId);
            List pathNodeIds = root.getChildPath(leafNodeId);
            if (!WTCCollections.isNotEmpty((Collection)pathNodeIds)) continue;
            allNodeIds.addAll(pathNodeIds);
        }
        allNodeIds.removeAll(checkNodeIdWithParent);
        return allNodeIds;
    }

    private Map<String, TreeNode> getTreeLeafMap(TreeNode root) {
        HashMap<String, TreeNode> leafMap = new HashMap<String, TreeNode>(16);
        this.getTreeLeafMap(root, leafMap);
        return leafMap;
    }

    private void getTreeLeafMap(TreeNode root, Map<String, TreeNode> leafMap) {
        if (!CollectionUtils.isEmpty((Collection)root.getChildren())) {
            for (TreeNode children : root.getChildren()) {
                this.getTreeLeafMap(children, leafMap);
            }
        } else if (root.isLeaf()) {
            leafMap.put(root.getId(), root);
        }
    }

    private Map<String, String> getDisplayMap() {
        List oldRefProps = (List)this.getView().getFormShowParameter().getCustomParams().get("value");
        HashMap<String, String> displayNameMap = new HashMap<String, String>(oldRefProps.size());
        for (Map refProp : oldRefProps) {
            if (!refProp.containsKey("fDName")) continue;
            displayNameMap.put((String)refProp.get("id"), (String)refProp.get("fDName"));
        }
        return displayNameMap;
    }

    private List<Map<String, String>> root2ListMap(TreeNode root, Map<String, String> displayNameMap) {
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>(10);
        Map<String, TreeNode> leafMap = this.getTreeLeafMap(root);
        for (Map.Entry<String, TreeNode> leafEntry : leafMap.entrySet()) {
            TreeNode propNode = leafEntry.getValue();
            mapList.add(this.node2Map(propNode, displayNameMap));
        }
        return mapList;
    }

    private Map<String, String> node2Map(TreeNode node, Map<String, String> displayNameMap) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)5);
        map.put("fielddisplayname", displayNameMap.get(node.getId()));
        map.put("parentId", node.getParentid());
        map.put("fieldid", node.getId());
        return map;
    }
}

