/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbd.fromplugin.web.retrieval;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbd.business.retrieval.RetrievalRuleHelper;
import kd.wtc.wtbd.business.retrieval.RetrievalUtil;
import kd.wtc.wtbd.common.constants.scenecfg.SceneCfgKDString;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class RetrievalRuleEdit
extends HRDataBaseEdit
implements HyperLinkClickListener {
    public void afterCopyData(EventObject event) {
        super.afterCopyData(event);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (WTCCollections.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject entry : entryEntity) {
                entry.set("entryispreset", (Object)Boolean.FALSE);
                DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
                if (!WTCCollections.isNotEmpty((Collection)subEntries)) continue;
                subEntries.forEach(subEntry -> subEntry.set("fieldissyspreset", (Object)Boolean.FALSE));
            }
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("inputnumber".equals(fieldName)) {
            boolean isUpgradeSuccess = RetrievalUtil.isUpgradeFinished((String)"426TICG+NW7C", (String)"426TB3KG8ASG");
            this.getView().setEnable(Boolean.valueOf(isUpgradeSuccess), new String[]{"bar_save"});
            if (!isUpgradeSuccess) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RetrievalItemEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openEditParamsInputDialog(hyperLinkClickEvent.getRowIndex());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && "wtbd_sceneparamsinput".equals(actionId)) {
            int rowCount;
            boolean saveForEdit = Boolean.parseBoolean(this.getPageCache().get("saveForEdit"));
            IDataModel model = this.getModel();
            if (saveForEdit) {
                rowCount = Integer.parseInt(this.getPageCache().get("needToEditLine"));
            } else {
                rowCount = model.getEntryRowCount("entryentity");
                model.batchCreateNewEntryRow("entryentity", 1);
            }
            DynamicObject returnDy = (DynamicObject)returnData;
            model.setValue("inputnumber", (Object)returnDy.getString("inputnumber"), rowCount);
            model.setValue("inputname", returnDy.get("inputname"), rowCount);
            model.setValue("inputparamstype", returnDy.get("inputparamstype"), rowCount);
            model.setValue("inputobject", returnDy.get("inputobject"), rowCount);
            DynamicObjectCollection paramColl = returnDy.getDynamicObjectCollection("entryentity");
            model.setEntryCurrentRowIndex("entryentity", rowCount);
            DynamicObjectCollection oldColls = model.getEntryEntity("subentryentity");
            HashMap<String, DynamicObject> oldMap = new HashMap<String, DynamicObject>(oldColls.size());
            for (DynamicObject dy : oldColls) {
                oldMap.put(dy.getString("fieldid.id"), dy);
            }
            model.deleteEntryData("subentryentity");
            model.batchCreateNewEntryRow("subentryentity", paramColl.size());
            for (int index = 0; index < paramColl.size(); ++index) {
                DynamicObject paramDy = (DynamicObject)paramColl.get(index);
                String fieldId = paramDy.getString("fieldid.id");
                if (oldMap.containsKey(fieldId)) {
                    if (HRStringUtils.isNotEmpty((String)((DynamicObject)oldMap.get(fieldId)).getString("fieldnumber"))) {
                        model.setValue("fieldnumber", (Object)((DynamicObject)oldMap.get(fieldId)).getString("fieldnumber"), index, rowCount);
                    }
                    if (HRStringUtils.isNotEmpty((String)((DynamicObject)oldMap.get(fieldId)).getString("fieldname"))) {
                        model.setValue("fieldname", (Object)((DynamicObject)oldMap.get(fieldId)).getString("fieldname"), index, rowCount);
                    }
                    if (HRStringUtils.isNotEmpty((String)((DynamicObject)oldMap.get(fieldId)).getString("type"))) {
                        model.setValue("type", (Object)((DynamicObject)oldMap.get(fieldId)).getString("type"), index, rowCount);
                    }
                    if (HRStringUtils.isNotEmpty((String)((DynamicObject)oldMap.get(fieldId)).getString("param1"))) {
                        model.setValue("param1", (Object)((DynamicObject)oldMap.get(fieldId)).getString("param1"), index, rowCount);
                    }
                }
                model.setValue("fielddisplayname", paramDy.get("fielddisplayname"), index, rowCount);
                model.setValue("fieldid", paramDy.get("fieldid"), index, rowCount);
                model.setValue("fieldissyspreset", paramDy.get("fieldissyspreset"), index, rowCount);
            }
            DynamicObjectCollection entryEntities = model.getEntryEntity("subentryentity");
            for (int index = 0; index < paramColl.size(); ++index) {
                DynamicObject paramDy = (DynamicObject)paramColl.get(index);
                ((DynamicObject)entryEntities.get(index)).set("id", paramDy.get("id"));
            }
            this.getView().updateView("subentryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if ("grouptype".equals(name)) {
            this.groupTypeChange(true);
            this.getModel().deleteEntryData("entryentity");
        } else if ("calctype".equals(name)) {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    private void groupTypeChange(boolean resetCalcType) {
        String groupType = this.getModel().getDataEntity().getString("grouptype");
        if (HRStringUtils.equals((String)"2", (String)groupType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"calctype"});
            ((ComboEdit)this.getControl("calctype")).setMustInput(true);
        } else {
            if (resetCalcType) {
                this.getModel().setValue("calctype", null);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"calctype"});
            ((ComboEdit)this.getControl("calctype")).setMustInput(false);
        }
    }

    private void openAddParamsInputDialog() {
        String formId = "wtbd_sceneparamsinput";
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        Map<String, List<String>> allInputParams = this.getAllInputParams(-1);
        showParameter.setCustomParam("allInputParamName", allInputParams.get("allInputParamName"));
        showParameter.setCustomParam("allInputParamNumber", allInputParams.get("allInputParamNumber"));
        showParameter.setCustomParam("excludeEntity", allInputParams.get("excludeEntity"));
        showParameter.setCustomParam("allRetrievalItemDisplayName", allInputParams.get("allRetrievalItemDisplayName"));
        showParameter.setCustomParam("grouptype", (Object)this.getModel().getDataEntity().getString("grouptype"));
        showParameter.setCustomParam("calctype", (Object)this.getModel().getDataEntity().getString("calctype"));
        showParameter.setCustomParam("ruleId", (Object)"0");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        this.getView().showForm(showParameter);
        this.getPageCache().put("saveForEdit", "false");
    }

    private void openEditParamsInputDialog(int rowIndex) {
        String formId = "wtbd_sceneparamsinput";
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        DynamicObject currentRowDy = (DynamicObject)entryEntity.get(rowIndex);
        String inputNumber = currentRowDy.getString("inputnumber");
        String inputName = currentRowDy.getString("inputname");
        String inputObjNumber = currentRowDy.getString("inputobject.numberx");
        showParameter.setCustomParam("inputnumber", (Object)inputNumber);
        showParameter.setCustomParam("inputname", currentRowDy.get("inputname"));
        showParameter.setCustomParam("inputparamstype", (Object)currentRowDy.getString("inputparamstype"));
        DynamicObject inputObject = currentRowDy.getDynamicObject("inputobject");
        if (inputObject != null) {
            showParameter.setCustomParam("inputobject", (Object)inputObject.getString("id"));
        }
        DynamicObjectCollection paramFiledColl = currentRowDy.getDynamicObjectCollection("subentryentity");
        showParameter.setCustomParam("dynprop", (Object)this.getDynPropData(paramFiledColl));
        showParameter.setCustomParam("entityId", (Object)formId);
        Map<String, List<String>> allInputParams = this.getAllInputParams(rowIndex);
        List<String> allInputName = allInputParams.get("allInputParamName");
        List<String> allInputNumber = allInputParams.get("allInputParamNumber");
        List<String> allInputObjNumber = allInputParams.get("excludeEntity");
        List<String> retrievalItemDisplayNames = allInputParams.get("allRetrievalItemDisplayName");
        allInputName.remove(inputName);
        allInputNumber.remove(inputNumber);
        allInputObjNumber.remove(inputObjNumber);
        showParameter.setCustomParam("allInputParamName", allInputName);
        showParameter.setCustomParam("allInputParamNumber", allInputNumber);
        showParameter.setCustomParam("excludeEntity", allInputObjNumber);
        showParameter.setCustomParam("allRetrievalItemDisplayName", retrievalItemDisplayNames);
        boolean isSysPreset = currentRowDy.getBoolean("entryispreset");
        showParameter.setCustomParam("issyspreset", (Object)(isSysPreset ? "1" : "0"));
        showParameter.setCustomParam("grouptype", (Object)this.getModel().getDataEntity().getString("grouptype"));
        showParameter.setCustomParam("calctype", (Object)this.getModel().getDataEntity().getString("calctype"));
        showParameter.setCustomParam("ruleId", (Object)String.valueOf(this.getModel().getDataEntity().getLong("id")));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        this.getView().showForm(showParameter);
        this.getPageCache().put("saveForEdit", "true");
        this.getPageCache().put("needToEditLine", String.valueOf(rowIndex));
    }

    private Map<String, List<String>> getAllInputParams(int rowIndex) {
        DynamicObjectCollection inputParams = this.getModel().getEntryEntity("entryentity");
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        ArrayList inputNames = Lists.newArrayListWithCapacity((int)16);
        ArrayList inputNumbers = Lists.newArrayListWithCapacity((int)16);
        ArrayList inputObjNumbers = Lists.newArrayListWithCapacity((int)16);
        ArrayList retrievalItemDisplayNames = Lists.newArrayListWithCapacity((int)16);
        for (int i = 0; i < inputParams.size(); ++i) {
            DynamicObject param = (DynamicObject)inputParams.get(i);
            if (i == rowIndex) continue;
            inputNames.add(param.getString("inputname"));
            inputNumbers.add(param.getString("inputnumber"));
            inputObjNumbers.add(param.getString("inputobject.numberx"));
            param.getDynamicObjectCollection("subentryentity").forEach(subEntry -> {
                DynamicObject fieldDy = subEntry.getDynamicObject("fieldid");
                if (HRStringUtils.isNotEmpty((String)subEntry.getString("fielddisplayname"))) {
                    retrievalItemDisplayNames.add(subEntry.getString("fielddisplayname"));
                } else if (null != fieldDy && HRStringUtils.isNotEmpty((String)fieldDy.getString("name"))) {
                    retrievalItemDisplayNames.add(fieldDy.getString("name"));
                }
            });
        }
        result.put("allInputParamName", inputNames);
        result.put("allInputParamNumber", inputNumbers);
        result.put("excludeEntity", inputObjNumbers);
        result.put("allRetrievalItemDisplayName", retrievalItemDisplayNames);
        return result;
    }

    public void afterBindData(EventObject event) {
        boolean isSysPreset;
        List list;
        super.afterBindData(event);
        String isUpgradeSuccessStr = (String)this.getView().getFormShowParameter().getCustomParam("isUpgradeSuccess");
        boolean isUpgradeSuccess = HRStringUtils.equals((String)"true", (String)isUpgradeSuccessStr);
        this.getView().setEnable(Boolean.valueOf(isUpgradeSuccess), new String[]{"bar_save"});
        this.groupTypeChange(false);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String useCfgName = dataEntity.getString("usecfgname");
        if (HRStringUtils.isEmpty((String)useCfgName) && WTCCollections.isNotEmpty((Collection)(list = RetrievalRuleHelper.getRelatedUseCfgDyList((long)dataEntity.getLong("id"))))) {
            String value = list.stream().map(config -> config.get("name").toString()).collect(Collectors.joining("\uff0c"));
            this.getModel().setValue("usecfgname", (Object)value);
            this.getModel().setDataChanged(false);
        }
        if (isSysPreset = dataEntity.getBoolean("issyspreset")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"fs_baseinfo"});
        }
    }

    private String getDynPropData(DynamicObjectCollection paramFiledColl) {
        String str = SerializationUtils.toJsonString((Object)paramFiledColl);
        JSONArray strArr = JSONArray.parseArray((String)str);
        for (int i = 0; i < strArr.size(); ++i) {
            JSONObject fieldidObj = strArr.getJSONObject(i).getJSONObject("fieldid");
            strArr.getJSONObject(i).put("fieldid", (Object)String.valueOf(fieldidObj.get((Object)"id")));
        }
        return strArr.toString();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"addparam")) {
            this.openAddParamsInputDialog();
        } else if (HRStringUtils.equals((String)operateKey, (String)"preview")) {
            this.openPreviewForm();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"addparam")) {
            boolean isUpgradeSuccess = RetrievalUtil.isUpgradeFinished((String)"426TICG+NW7C", (String)"426TB3KG8ASG");
            this.getView().setEnable(Boolean.valueOf(isUpgradeSuccess), new String[]{"bar_save"});
            if (!isUpgradeSuccess) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RetrievalItemEdit_3", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"deleteentry")) {
            long ruleId;
            int[] selectedRows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
            if (selectedRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RetrievalRuleParamPlugin_2", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection entryColls = this.getModel().getEntryEntity("entryentity");
            for (int selectedRow : selectedRows) {
                boolean isSysPreset = ((DynamicObject)entryColls.get(selectedRow)).getBoolean("entryispreset");
                if (!isSysPreset) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u7981\u6b62\u5220\u9664\u3002", (String)"RetrievalRuleParamPlugin_1", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Map<String, String> paramKeyMap = this.getDeletedParamKeyMap(selectedRows);
            if (RetrievalRuleHelper.checkRetrievalItemUsedByCt(paramKeyMap, (long)(ruleId = this.getModel().getDataEntity().getLong("id")))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u5df2\u88ab\u4f7f\u7528\uff0c\u7981\u6b62\u5220\u9664", (String)"RetrievalRuleParamPlugin_4", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            for (int selectedRow : selectedRows) {
                DynamicObjectCollection subEntryEntity = ((DynamicObject)entryColls.get(selectedRow)).getDynamicObjectCollection("subentryentity");
                if (WTCCollections.isEmpty((Collection)subEntryEntity)) continue;
                for (DynamicObject subEntry : subEntryEntity) {
                    String retrievalWay = subEntry.getString("fieldid.way");
                    if (!HRStringUtils.equals((String)"2", (String)retrievalWay)) continue;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u81ea\u5b9a\u4e49\u53d6\u6570\u9879\u76ee\uff0c\u6b64\u7c7b\u9879\u76ee\u5220\u9664\u540e\u65e0\u6cd5\u518d\u6b21\u6dfb\u52a0\u3002\r\n\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u5220\u9664\uff1f", (String)"RetrievalRuleParamPlugin_6", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("PAGE_CALL_BACK_FROM_CONFIRMDELETE", (IFormPlugin)this));
                    args.setCancel(true);
                    return;
                }
            }
            this.getView().getModel().deleteEntryRows("entryentity", selectedRows);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Yes.equals((Object)event.getResult()) && "PAGE_CALL_BACK_FROM_CONFIRMDELETE".equals(event.getCallBackId())) {
            int[] selectedRows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
            this.getView().getModel().deleteEntryRows("entryentity", selectedRows);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        if (!WTCGrayscaleUtils.isRetrievalOpen().booleanValue()) {
            args.setCancel(true);
            args.setCancelMessage(SceneCfgKDString.grayscaleStatusIsClosed());
        }
    }

    private void openPreviewForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wtbd_scenerulepreview");
        showParameter.setCaption(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u9884\u89c8", (String)"RetrievalRuleParamPlugin_5", (String)"wtc-wtbd-formplugin", (Object[])new Object[0]));
        List treeNodes = RetrievalRuleHelper.getRetrievalRulePreviewTreeNodes((DynamicObject)this.getModel().getDataEntity());
        showParameter.getCustomParams().put("treenodes", SerializationUtils.toJsonString((Object)treeNodes));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(showParameter);
    }

    private Map<String, String> getDeletedParamKeyMap(int[] selectedRows) {
        HashMap<String, String> paramKeyMap = new HashMap<String, String>(selectedRows.length);
        DynamicObjectCollection entryColls = this.getModel().getEntryEntity("entryentity");
        for (int selectedRow : selectedRows) {
            String inputNumber = ((DynamicObject)entryColls.get(selectedRow)).getString("inputnumber");
            DynamicObjectCollection subEntryEntity = ((DynamicObject)entryColls.get(selectedRow)).getDynamicObjectCollection("subentryentity");
            if (WTCCollections.isEmpty((Collection)subEntryEntity)) continue;
            for (int i = 0; i < subEntryEntity.size(); ++i) {
                String belongObjNumber = ((DynamicObject)subEntryEntity.get(i)).getString("fieldid.belongobj.number");
                String fieldNumber = ((DynamicObject)subEntryEntity.get(i)).getString("fieldid.number");
                String fieldType = ((DynamicObject)subEntryEntity.get(i)).getString("fieldid.type");
                StringBuilder paramKeyBuffer = new StringBuilder();
                paramKeyBuffer.append(inputNumber);
                if (HRStringUtils.isNotEmpty((String)belongObjNumber)) {
                    paramKeyBuffer.append(".").append(belongObjNumber);
                }
                paramKeyBuffer.append(".").append(fieldNumber);
                if (HRStringUtils.equals((String)"dynamicObject", (String)fieldType) && !paramKeyBuffer.toString().endsWith(".id")) {
                    paramKeyBuffer.append(".id");
                }
                paramKeyMap.put(paramKeyBuffer.toString(), ((DynamicObject)subEntryEntity.get(i)).getString("fieldid.id"));
            }
        }
        return paramKeyMap;
    }
}

